/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.Comm;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.Request;
import p2pmpi.mpi.dev.BinomialTree;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.ProcTree;

public class IntraComm
extends Comm {
    private int systemTAG = 100000;

    public IntraComm(Device myDevice, RankTable rankTable, int rank, int rankInList, int numRank, MapRankTable mapRankTable) {
        super(myDevice, rankTable, rank, rankInList, numRank, mapRankTable);
    }

    public IntraComm(Group group) {
        super(group);
    }

    public IntraComm Create(Group group) {
        IntraComm newComm = new IntraComm(group);
        return newComm;
    }

    private void BarrierFlatImpl() {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        byte[] dummy = new byte[1];
        if (this.Rank() == 0) {
            int i;
            for (i = 1; i < this.Size(); ++i) {
                this.Recv(dummy, 0, 1, MPI.BYTE, i, this.systemTAG);
            }
            for (i = 1; i < this.Size(); ++i) {
                this.Send(dummy, 0, 1, MPI.BYTE, i, this.systemTAG);
            }
        } else {
            this.Send(dummy, 0, 1, MPI.BYTE, 0, this.systemTAG);
            this.Recv(dummy, 0, 1, MPI.BYTE, 0, this.systemTAG);
        }
        ++this.systemTAG;
    }

    private void BarrierTreeImpl() {
        int i;
        ProcTree procTree = new ProcTree();
        procTree.buildTree(this.Rank(), this.Size());
        int offset = 0;
        Datatype type = MPI.BYTE;
        byte[] dummy = new byte[1];
        int count = 1;
        if (!procTree.isRoot) {
            this.Send(dummy, offset, count, type, procTree.parent, this.systemTAG - this.Rank());
        }
        for (i = 0; i < procTree.child.length; ++i) {
            if (procTree.child[i] == -1) continue;
            this.Recv(dummy, offset, count, type, procTree.child[i], this.systemTAG - procTree.child[i]);
        }
        if (!procTree.isRoot) {
            if (procTree.parent == -1) {
                // empty if block
            }
            this.Recv(dummy, offset, count, type, procTree.parent, this.systemTAG - this.Rank());
        }
        for (i = 0; i < procTree.child.length; ++i) {
            if (procTree.child[i] == -1) continue;
            this.Send(dummy, offset, count, type, procTree.child[i], this.systemTAG - procTree.child[i]);
        }
    }

    public void Barrier() {
        this.BarrierTreeImpl();
    }

    public void Bcast(Object buffer, int offset, int count, Datatype datatype, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.BcastBinomial(buffer, offset, count, datatype, root);
    }

    private void BcastBinomial(Object buffer, int offset, int count, Datatype datatype, int root) {
        int parent;
        int numNode = this.Size();
        BinomialTree bt = new BinomialTree(numNode);
        int maxDegree = bt.getMaxDegree();
        int[] children = new int[maxDegree + 1];
        Request[] sreq = new Request[maxDegree + 1];
        int visualRank = this.Rank() - root;
        if (visualRank < 0) {
            visualRank += this.Size();
        }
        if ((parent = bt.getParentChildrenInverse(visualRank, children)) != -1) {
            parent = (parent + root) % numNode;
            this.Recv(buffer, offset, count, datatype, parent, this.systemTAG);
        }
        int i = 0;
        while (children[i] != -1) {
            sreq[i] = this.Isend(buffer, offset, count, datatype, (children[i] + root) % numNode, this.systemTAG);
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            sreq[j].Wait();
        }
        ++this.systemTAG;
    }

    public void Reduce(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        if (op.isCommute()) {
            this.ReduceBinomial(sendBuffer, sendOffset, recvBuffer, recvOffset, count, datatype, op, root);
        } else {
            this.ReduceFlat(sendBuffer, sendOffset, recvBuffer, recvOffset, count, datatype, op, root);
        }
    }

    private void ReduceBinomial(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op, int root) {
        int numNode = this.Size();
        BinomialTree bt = new BinomialTree(numNode);
        int maxDegree = bt.getMaxDegree();
        int[] children = new int[maxDegree + 1];
        int visualRank = this.Rank() - root;
        if (visualRank < 0) {
            visualRank += this.Size();
        }
        int parent = bt.getParentChildren(visualRank, children);
        int baseType = datatype.getBaseType();
        if (parent != -1) {
            parent = (parent + root) % this.Size();
        }
        int numChild = children.length;
        for (int i = 0; i < numChild && children[i] != -1; ++i) {
            children[i] = (children[i] + root) % this.Size();
        }
        Object result = datatype.createArrayBuffer(count);
        System.arraycopy(sendBuffer, sendOffset, result, 0, count);
        int i = 0;
        while (children[i] != -1) {
            this.Recv(recvBuffer, recvOffset, count, datatype, children[i], this.systemTAG);
            op.Call(recvBuffer, recvOffset, result, 0, count, datatype);
            ++i;
        }
        if (parent != -1) {
            this.Send(result, 0, count, datatype, parent, this.systemTAG);
        } else {
            System.arraycopy(result, 0, recvBuffer, recvOffset, count);
        }
        ++this.systemTAG;
    }

    private void ReduceFlat(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op, int root) {
        if (this.Rank() != root) {
            this.Send(sendBuffer, sendOffset, count, datatype, root, this.systemTAG);
        } else {
            Object tmpRecv = datatype.createArrayBuffer(count);
            for (int i = 0; i < this.Size(); ++i) {
                if (i != root) {
                    this.Recv(tmpRecv, 0, count, datatype, i, this.systemTAG);
                    op.Call(tmpRecv, 0, recvBuffer, recvOffset, count, datatype);
                    continue;
                }
                System.arraycopy(sendBuffer, sendOffset, tmpRecv, 0, count);
                op.Call(tmpRecv, 0, recvBuffer, recvOffset, count, datatype);
            }
        }
        ++this.systemTAG;
    }

    public void Allreduce(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        if (this.myDevice.isPower2()) {
            this.AllreduceButterfly(sendBuffer, sendOffset, recvBuffer, recvOffset, count, datatype, op);
        } else {
            this.AllreduceSimple(sendBuffer, sendOffset, recvBuffer, recvOffset, count, datatype, op);
        }
    }

    public void AllreduceSimple(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce(sendBuffer, sendOffset, recvBuffer, recvOffset, count, datatype, op, 0);
        this.Bcast(recvBuffer, recvOffset, count, datatype, 0);
    }

    public void AllreduceButterfly(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int count, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        int me = this.Rank();
        int size = this.Size();
        Object tmpBuffer = datatype.createArrayBuffer(count);
        System.arraycopy(sendBuffer, sendOffset, recvBuffer, recvOffset, count);
        for (int mask = 1; mask < size; mask <<= 1) {
            int dst = me ^ mask;
            this.Sendrecv(recvBuffer, recvOffset, count, datatype, dst, this.systemTAG, tmpBuffer, 0, count, datatype, dst, this.systemTAG);
            op.Call(tmpBuffer, 0, recvBuffer, recvOffset, count, datatype);
        }
        ++this.systemTAG;
    }

    public void Alltoallv(Object sendBuffer, int sendOffset, int[] sendCount, int[] sdispls, Datatype sendType, Object recvBuffer, int recvOffset, int[] recvCount, int[] rdispls, Datatype recvType) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallvAsynRotate(sendBuffer, sendOffset, sendCount, sdispls, sendType, recvBuffer, recvOffset, recvCount, rdispls, recvType);
    }

    private void AlltoallvAsynRotate(Object sendBuffer, int sendOffset, int[] sendCount, int[] sdispls, Datatype sendType, Object recvBuffer, int recvOffset, int[] recvCount, int[] rdispls, Datatype recvType) {
        int i;
        int myRank = this.Rank();
        int mySize = this.Size();
        int numWait = this.Size() - 1;
        Request[] sreq = new Request[numWait];
        Request[] rreq = new Request[numWait];
        for (int i2 = 1; i2 < mySize; ++i2) {
            int sendTo = (myRank + i2) % mySize;
            sreq[i2 - 1] = this.Isend(sendBuffer, sendOffset + sdispls[sendTo], sendCount[sendTo], sendType, sendTo, this.systemTAG);
        }
        for (i = 1; i < mySize; ++i) {
            int recvFrom = (mySize + (myRank - i)) % mySize;
            rreq[i - 1] = this.Irecv(recvBuffer, recvOffset + rdispls[recvFrom], recvCount[recvFrom], recvType, recvFrom, this.systemTAG);
        }
        System.arraycopy(sendBuffer, sendOffset + sdispls[myRank], recvBuffer, recvOffset + rdispls[myRank], recvCount[myRank]);
        for (i = 0; i < numWait; ++i) {
            sreq[i].Wait();
            rreq[i].Wait();
        }
    }

    public void Alltoall(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallAsynRotate(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, recvType);
        ++this.systemTAG;
    }

    private void AlltoallAsynRotate(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType) {
        int i;
        int myRank = this.Rank();
        int mySize = this.Size();
        int numWait = this.Size() - 1;
        Request[] sreq = new Request[numWait];
        Request[] rreq = new Request[numWait];
        for (int i2 = 1; i2 < mySize; ++i2) {
            int sendTo = (myRank + i2) % mySize;
            int sendOffsetCount = sendTo * sendCount;
            sreq[i2 - 1] = this.Isend(sendBuffer, sendOffset + sendOffsetCount, sendCount, sendType, sendTo, this.systemTAG);
        }
        for (i = 1; i < mySize; ++i) {
            int recvFrom = (mySize + (myRank - i)) % mySize;
            int recvOffsetCount = recvFrom * recvCount;
            this.Recv(recvBuffer, recvOffset + recvOffsetCount, recvCount, recvType, recvFrom, this.systemTAG);
        }
        System.arraycopy(sendBuffer, sendOffset + myRank * sendCount, recvBuffer, recvOffset + myRank * recvCount, recvCount);
        for (i = 0; i < numWait; ++i) {
            sreq[i].Wait();
        }
    }

    public void Gather(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GatherFlatTree(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, recvType, root);
    }

    private void GatherFlatTree(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int recvcount, Datatype recvtype, int root) {
        Request[] rreq = new Request[this.Size() - 1];
        int counter = 0;
        if (this.Rank() == root) {
            int i;
            for (i = 0; i < this.Size(); ++i) {
                if (i != root) {
                    rreq[counter] = this.Irecv(recvbuf, recvoffset + i * recvcount, recvcount, recvtype, i, this.systemTAG);
                    ++counter;
                    continue;
                }
                System.arraycopy(sendbuf, sendoffset, recvbuf, recvoffset + root * recvcount, recvcount);
            }
            for (i = 0; i < counter; ++i) {
                rreq[i].Wait();
            }
        } else {
            this.Send(sendbuf, sendoffset, sendcount, sendtype, root, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Gatherv(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int[] recvCount, int[] displs, Datatype recvType, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GathervFlatTree(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, displs, recvType, root);
    }

    private void GathervFlatTree(Object sendbuf, int sendoffset, int sendcount, Datatype sendtype, Object recvbuf, int recvoffset, int[] recvcount, int[] displs, Datatype recvtype, int root) {
        Request[] rreq = new Request[this.Size() - 1];
        int counter = 0;
        if (this.Rank() == root) {
            int i;
            for (i = 0; i < this.Size(); ++i) {
                if (i != root) {
                    rreq[counter] = this.Irecv(recvbuf, recvoffset + displs[i], recvcount[i], recvtype, i, this.systemTAG);
                    ++counter;
                    continue;
                }
                System.arraycopy(sendbuf, sendoffset, recvbuf, recvoffset + displs[i], recvcount[i]);
            }
            for (i = 0; i < counter; ++i) {
                rreq[i].Wait();
            }
        } else {
            this.Send(sendbuf, sendoffset, sendcount, sendtype, root, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Allgather(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGatherSimple(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, recvType);
    }

    private void AllGatherSimple(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType) {
        this.Gather(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, recvType, 0);
        this.Bcast(recvBuffer, recvOffset, recvCount * this.Size(), recvType, 0);
    }

    public void Allgatherv(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int[] recvCount, int[] displs, Datatype recvType) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGathervSimple(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, displs, recvType);
    }

    private void AllGathervSimple(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int[] recvCount, int[] displs, Datatype recvType) {
        this.Gatherv(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, displs, recvType, 0);
        int counter = displs[displs.length - 1] + recvCount[recvCount.length - 1];
        this.Bcast(recvBuffer, recvOffset, counter, recvType, 0);
    }

    public void Scatter(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScatterSimple(sendBuffer, sendOffset, sendCount, sendType, recvBuffer, recvOffset, recvCount, recvType, root);
    }

    private void ScatterSimple(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int root) {
        int mySize = this.Size();
        Request[] sreq = new Request[mySize - 1];
        int counter = 0;
        if (this.Rank() == root) {
            int i;
            for (i = 0; i < mySize; ++i) {
                if (i != root) {
                    sreq[counter] = this.Isend(sendBuffer, sendOffset + i * sendCount, sendCount, sendType, i, this.systemTAG);
                    ++counter;
                    continue;
                }
                System.arraycopy(sendBuffer, sendOffset + i * sendCount, recvBuffer, recvOffset, recvCount);
            }
            for (i = 0; i < counter; ++i) {
                sreq[i].Wait();
            }
        } else {
            this.Recv(recvBuffer, recvOffset, recvCount, recvType, root, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Scatterv(Object sendBuffer, int sendOffset, int[] sendCount, int[] displs, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int root) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScattervSimple(sendBuffer, sendOffset, sendCount, displs, sendType, recvBuffer, recvOffset, recvCount, recvType, root);
    }

    private void ScattervSimple(Object sendBuffer, int sendOffset, int[] sendCount, int[] displs, Datatype sendType, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int root) {
        int mySize = this.Size();
        Request[] sreq = new Request[mySize - 1];
        int counter = 0;
        if (this.Rank() == root) {
            int i;
            for (i = 0; i < mySize; ++i) {
                if (i != root) {
                    sreq[counter] = this.Isend(sendBuffer, sendOffset + displs[i], sendCount[i], sendType, i, this.systemTAG);
                    ++counter;
                    continue;
                }
                System.arraycopy(sendBuffer, sendOffset + displs[i], recvBuffer, recvOffset, recvCount);
            }
            for (i = 0; i < counter; ++i) {
                sreq[i].Wait();
            }
        } else {
            this.Recv(recvBuffer, recvOffset, recvCount, recvType, root, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Reduce_scatter(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int[] recvCount, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce_scatterSimple(sendBuffer, sendOffset, recvBuffer, recvOffset, recvCount, datatype, op);
    }

    private void Reduce_scatterSimple(Object sendBuffer, int sendOffset, Object recvBuffer, int recvOffset, int[] recvCount, Datatype datatype, Op op) {
        int mySize = this.Size();
        int count = 0;
        for (int i = 0; i < mySize; ++i) {
            count += recvCount[i];
        }
        int[] displs = new int[mySize];
        displs[0] = 0;
        for (int i = 0; i < mySize - 1; ++i) {
            displs[i + 1] = displs[i] + recvCount[i];
        }
        Object tmpBuffer = datatype.createArrayBuffer(count);
        this.Reduce(sendBuffer, 0, tmpBuffer, 0, count, datatype, op, 0);
        this.Scatterv(tmpBuffer, 0, recvCount, displs, datatype, recvBuffer, 0, recvCount[this.Rank()], datatype, 0);
    }

    public void Scan(Object sendbuf, int sendoffset, Object recvbuf, int recvoffset, int count, Datatype datatype, Op op) {
        if (this.Rank() == 0) {
            System.arraycopy(sendbuf, sendoffset, recvbuf, recvoffset, count);
        } else {
            this.Recv(recvbuf, recvoffset, count, datatype, this.Rank() - 1, this.systemTAG);
            op.Call(sendbuf, sendoffset, recvbuf, recvoffset, count, datatype);
        }
        if (this.Rank() < this.Size() - 1) {
            this.Send(recvbuf, recvoffset, count, datatype, this.Rank() + 1, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public IntraComm Split(int color, int key) {
        int mycolor = color;
        int mykey = key;
        int size = this.Size();
        int[] colorKey = new int[]{mycolor, mykey};
        int[] colorKeyTable = new int[2 * size];
        this.Allgather(colorKey, 0, 2, MPI.INT, colorKeyTable, 0, 2, MPI.INT);
        Vector<int[]> keyRanks = new Vector<int[]>();
        for (int i = 0; i < size; ++i) {
            if (colorKeyTable[2 * i] != mycolor) continue;
            int[] keyRank = new int[]{colorKeyTable[2 * i + 1], i};
            keyRanks.add(keyRank);
        }
        Vector<int[]> sortedKeyRanks = new Vector<int[]>();
        int numKey = keyRanks.size();
        while (numKey != 0) {
            int[] keyRank = (int[])keyRanks.elementAt(0);
            int position = 0;
            for (int j = 1; j < numKey; ++j) {
                if (keyRank[0] <= ((int[])keyRanks.elementAt(j))[0]) continue;
                position = j;
                keyRank = (int[])keyRanks.elementAt(j);
            }
            sortedKeyRanks.add(keyRank);
            keyRanks.remove(position);
            numKey = keyRanks.size();
        }
        int memberSize = sortedKeyRanks.size();
        int[] myNewRanks = new int[memberSize];
        for (int i = 0; i < memberSize; ++i) {
            myNewRanks[i] = ((int[])sortedKeyRanks.elementAt(i))[1];
        }
        Group myNewGroup = this.Group().Incl(myNewRanks);
        return this.Create(myNewGroup);
    }
}

