/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.net.URI;
import p2pmpi.mpi.MPI;

public class DevicePort
extends MPI {
    int port;
    int minPort;
    int maxPort;
    URI intUri;
    URI extUri;
    String status;

    public DevicePort(int minPort, int maxPort, String portInfo) {
        String status = null;
        String intIp = DevicePort.getLocalhostIntIp();
        this.port = myDevice.initPort(minPort, maxPort, intIp);
        if (this.port == -1) {
            System.err.println("No available ports for " + portInfo + " in the range allowed " + intIp + ":[" + minPort + "--" + maxPort + "] to run this application");
            System.exit(1);
        }
        try {
            this.intUri = new URI("tcp://" + intIp + ":" + this.port);
            this.extUri = new URI("tcp://" + DevicePort.getLocalhostExtIp() + ":" + this.port);
        }
        catch (Exception e) {
            status = e.getMessage();
        }
    }

    int getPort() {
        return this.port;
    }

    URI getIntURI() {
        return this.intUri;
    }

    URI getExtURI() {
        return this.extUri;
    }

    String getMessage() {
        return this.status;
    }
}

