/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.nio.ByteBuffer;
import p2pmpi.mpi.dev.DevDatatype;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class Datatype
extends DevDatatype {
    public static final int NULL = 0;
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int BOOLEAN = 4;
    public static final int INT = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int PACKED = 9;
    public static final int STRING = 10;
    public static final int OBJECT = 11;
    public static final int[] typeSize = new int[]{0, 1, 2, 2, 1, 4, 8, 4, 8, 0, 1, 1};
    int[] dispSeq;
    int baseType;
    int baseSize;
    P2PMPI_Buffer buffer;

    public Datatype(int type) {
        this.dispSeq = new int[1];
        this.dispSeq[0] = 0;
        this.baseType = type;
        this.baseSize = typeSize[type];
        this.buffer = P2PMPI_Buffer.createBuffer(this.baseType, this.baseSize);
    }

    public Datatype(int type, int[] dispSeq) {
        int dispSeqLen = dispSeq.length;
        this.dispSeq = new int[dispSeqLen];
        for (int i = 0; i < dispSeqLen; ++i) {
            this.dispSeq[i] = dispSeq[i];
        }
        this.baseType = type;
        this.baseSize = typeSize[type];
        this.buffer = P2PMPI_Buffer.createBuffer(this.baseType, this.baseSize);
    }

    public int Lb() {
        int dispSeqLen = this.dispSeq.length;
        int lb = this.dispSeq[0];
        for (int i = 1; i < dispSeqLen; ++i) {
            if (this.dispSeq[i] >= lb) continue;
            lb = this.dispSeq[i];
        }
        return lb;
    }

    public int Ub() {
        int dispSeqLen = this.dispSeq.length;
        int ub = 0;
        for (int i = 0; i < dispSeqLen; ++i) {
            int tmpUb = this.dispSeq[i] + 1;
            if (tmpUb <= ub) continue;
            ub = tmpUb;
        }
        return ub;
    }

    public int Extent() {
        return this.Ub() - this.Lb();
    }

    public int Size() {
        return this.Ub() - this.Lb();
    }

    public Datatype Contiguous(int count) {
        int dispSeqLen = this.dispSeq.length;
        int[] newDispSeq = new int[count * dispSeqLen];
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < dispSeqLen; ++j) {
                newDispSeq[i * dispSeqLen + j] = this.dispSeq[j] + i;
            }
        }
        return new Datatype(this.baseType, newDispSeq);
    }

    public int[] getDisplacementSequence() {
        return this.dispSeq;
    }

    public int getBaseType() {
        return this.baseType;
    }

    public int getBaseSize() {
        return this.baseSize;
    }

    public ByteBuffer getByteBuffer(Object dataBuffer, int offset, int count, short commID, int src, int dest, int tag, int numsend) {
        return this.buffer.getByteBuffer(dataBuffer, offset, count, commID, src, dest, tag, numsend);
    }

    public P2PMPI_Buffer getBuffer() {
        return this.buffer;
    }

    public Object createArrayBuffer(int count) {
        return this.buffer.createArrayBuffer(count);
    }
}

