/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Request;
import p2pmpi.mpi.Status;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.NIORequest;

public class Comm {
    private static short globalCommID = 0;
    protected Device myDevice;
    protected short commID;
    protected Group myGroup;
    protected MapRankTable mapRankTable;
    protected HashMap<String, Integer> midLog = new HashMap();
    private int numReplica;
    private int[] myReplica;
    private int[] myReplicaRIL;
    private static int MAX_REPLICA = 256;
    private int numProc;
    private int waitingTime;

    public Comm(Device myDevice, RankTable rankTable, int rank, int rankInList, int numRank, MapRankTable mapRankTable) {
        this.myDevice = myDevice;
        this.myGroup = new Group(myDevice, rankTable, rank, rankInList, numRank, mapRankTable);
        this.commID = globalCommID;
        globalCommID = (short)(globalCommID + 1);
        this.myReplica = new int[MAX_REPLICA];
        RankTable tmpTable = this.myGroup.__getCommTable();
        MapRankTable tmpMapTable = this.myGroup.__getMapCommTable();
        this.numProc = tmpMapTable.size();
        int myRank = this.myGroup.Rank();
        for (int i = 0; i < this.numProc; ++i) {
            int realRIL = tmpMapTable.getRankInList(i);
            if (!tmpTable.isAlive(realRIL) || myRank != tmpMapTable.getCurrentRank(i)) continue;
            this.myReplica[this.numReplica] = i;
            ++this.numReplica;
        }
        int myRankInList = this.myGroup.RankInList();
        boolean master = true;
        int myMaster = myRankInList;
        for (int i = 0; i < this.numReplica; ++i) {
            int realRIL = tmpMapTable.getRankInList(this.myReplica[i]);
            if (!tmpTable.isAlive(realRIL)) continue;
            if (myRankInList > this.myReplica[i]) {
                master = false;
            }
            if (myMaster <= this.myReplica[i]) continue;
            myMaster = this.myReplica[i];
        }
        myDevice.setMaster(master);
        myDevice.setMyMaster(myMaster);
        String usedProtocol = myDevice.getGossipProtocol();
        this.waitingTime = usedProtocol.equalsIgnoreCase("DBRR") ? (int)(Math.log(this.numProc) / Math.log(2.0)) * 3 * myDevice.getTGossip() * 2 + myDevice.getTMargin() : (int)(Math.log(this.numProc) / Math.log(2.0)) * 2 * myDevice.getTGossip() * 2 + myDevice.getTMargin();
        this.myReplicaRIL = new int[this.myReplica.length];
        for (int i = 0; i < this.numReplica; ++i) {
            int repRIL = this.myReplica[i];
            this.myReplicaRIL[i] = tmpMapTable.getRankInList(this.myReplica[i]);
        }
        myDevice.registerMap(this.commID, this.myGroup.__getMapCommTable());
        myDevice.registerCOMMWORLD(rankTable);
    }

    public Comm(Group group) {
        this.myGroup = group;
        this.myDevice = group.__getDevice();
        this.commID = globalCommID;
        globalCommID = (short)(globalCommID + 1);
        this.myReplica = new int[MAX_REPLICA];
        RankTable tmpTable = this.myGroup.__getCommTable();
        MapRankTable tmpMapTable = this.myGroup.__getMapCommTable();
        this.numProc = tmpMapTable.size();
        int myRank = this.myGroup.Rank();
        for (int i = 0; i < this.numProc; ++i) {
            int realRIL = tmpMapTable.getRankInList(i);
            if (!tmpTable.isAlive(realRIL) || myRank != tmpMapTable.getCurrentRank(i)) continue;
            this.myReplica[this.numReplica] = i;
            ++this.numReplica;
        }
        int myRankInList = this.myGroup.RankInList();
        boolean master = true;
        int myMaster = myRankInList;
        for (int i = 0; i < this.numReplica; ++i) {
            int realRIL = tmpMapTable.getRankInList(this.myReplica[i]);
            if (!tmpTable.isAlive(realRIL)) continue;
            if (myRankInList > this.myReplica[i]) {
                master = false;
            }
            if (myMaster <= this.myReplica[i]) continue;
            myMaster = this.myReplica[i];
        }
        this.myDevice.setMaster(master);
        this.myDevice.setMyMaster(myMaster);
        String usedProtocol = this.myDevice.getGossipProtocol();
        this.waitingTime = usedProtocol.equalsIgnoreCase("DBRR") ? (int)(Math.log(this.numProc) / Math.log(2.0)) * 3 * this.myDevice.getTGossip() * 2 + this.myDevice.getTMargin() : (int)(Math.log(this.numProc) / Math.log(2.0)) * 2 * this.myDevice.getTGossip() * 2 + this.myDevice.getTMargin();
        this.myReplicaRIL = new int[this.myReplica.length];
        for (int i = 0; i < this.numReplica; ++i) {
            int repRIL = this.myReplica[i];
            this.myReplicaRIL[i] = tmpMapTable.getRankInList(this.myReplica[i]);
        }
        this.myDevice.registerMap(this.commID, this.myGroup.__getMapCommTable());
    }

    public Group Group() {
        return this.myGroup;
    }

    public int Size() {
        return this.myGroup.Size();
    }

    public int SizeTotal() {
        return this.myGroup.__sizetotal();
    }

    public int Rank() {
        return this.myGroup.Rank();
    }

    public int Ssend(Object sendBuffer, int offset, int count, Datatype datatype, int dest, int tag) {
        if (this.Rank() == MPI.UNDEFINED) {
            return -1;
        }
        if (datatype.getBaseType() == 0) {
            return 0;
        }
        int numsend = this.increaseAndGetNumSend(this.Rank(), dest, tag);
        ByteBuffer sendMessage = datatype.getByteBuffer(sendBuffer, offset, count, this.commID, this.Rank(), dest, tag, numsend);
        RankTable commTable = this.myGroup.__getCommTable();
        MapRankTable mapCommTable = this.myGroup.__getMapCommTable();
        Vector<Integer> dstRIL = mapCommTable.getRankInListByCurrentRank(dest);
        if (this.myDevice.isMaster()) {
            this.myDevice.ssend(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL);
        } else {
            this.myDevice.sendToBackup(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL);
        }
        return count;
    }

    public int Send(Object sendBuffer, int offset, int count, Datatype datatype, int dest, int tag) {
        if (this.Rank() == MPI.UNDEFINED) {
            return -1;
        }
        if (datatype.getBaseType() == 0) {
            return 0;
        }
        int numsend = this.increaseAndGetNumSend(this.Rank(), dest, tag);
        ByteBuffer sendMessage = datatype.getByteBuffer(sendBuffer, offset, count, this.commID, this.Rank(), dest, tag, numsend);
        RankTable commTable = this.myGroup.__getCommTable();
        MapRankTable mapCommTable = this.myGroup.__getMapCommTable();
        Vector<Integer> dstRIL = mapCommTable.getRankInListByCurrentRank(dest);
        if (this.myDevice.isMaster()) {
            this.myDevice.send(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL);
        } else {
            this.myDevice.sendToBackup(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL);
        }
        return count;
    }

    public Request Isend(Object sendBuffer, int offset, int count, Datatype datatype, int dest, int tag) {
        NIORequest req = null;
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int numsend = this.increaseAndGetNumSend(this.Rank(), dest, tag);
        ByteBuffer sendMessage = datatype.getByteBuffer(sendBuffer, offset, count, this.commID, this.Rank(), dest, tag, numsend);
        RankTable commTable = this.myGroup.__getCommTable();
        MapRankTable mapCommTable = this.myGroup.__getMapCommTable();
        Vector<Integer> dstRIL = mapCommTable.getRankInListByCurrentRank(dest);
        req = this.myDevice.isMaster() ? this.myDevice.isend(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL) : this.myDevice.sendToBackup(commTable, sendMessage, dstRIL, this.commID, this.Rank(), dest, tag, numsend, this.myReplicaRIL);
        return new Request(req);
    }

    public Status Sendrecv(Object sendBuffer, int sendOffset, int sendCount, Datatype sendType, int dest, int sendTag, Object recvBuffer, int recvOffset, int recvCount, Datatype recvType, int source, int recvTag) {
        Request req = this.Irecv(recvBuffer, recvOffset, recvCount, recvType, source, recvTag);
        this.Send(sendBuffer, sendOffset, sendCount, sendType, dest, sendTag);
        return req.Wait();
    }

    public Status Recv(Object recvBuffer, int offset, int count, Datatype datatype, int src, int tag) {
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int numsend = this.increaseAndGetNumSend(src, this.Rank(), tag);
        IStatus istatus = this.myDevice.recv(recvBuffer, offset, count, this.commID, src, this.Rank(), tag, numsend, datatype.getBuffer());
        return new Status(istatus);
    }

    public Request Irecv(Object recvBuffer, int offset, int count, Datatype datatype, int src, int tag) {
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int numsend = this.increaseAndGetNumSend(src, this.Rank(), tag);
        NIORequest req = this.myDevice.irecv(recvBuffer, offset, count, this.commID, src, this.Rank(), tag, numsend, datatype.getBuffer());
        Request reqret = new Request(req);
        return reqret;
    }

    private synchronized int increaseAndGetNumSend(int src, int dest, int tag) {
        int iNumSent;
        String midKey = src + "_" + dest + "_" + tag;
        Integer i = this.midLog.get(midKey);
        if (i == null) {
            iNumSent = 0;
            this.midLog.put(midKey, new Integer(1));
        } else {
            iNumSent = i;
            this.midLog.put(midKey, new Integer(iNumSent + 1));
        }
        return iNumSent;
    }
}

