/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.message;

import java.io.Serializable;
import java.util.Vector;
import p2pmpi.common.OsInfo;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.Version;

public class StatInfoMessage
implements Serializable {
    private static final long serialVersionUID = 2000033L;
    private Vector<ProcessInfo> procInfo;
    String mpdVer;
    String ip;
    int mpdPort;
    String hostname;
    String osname;
    String arch;
    String cpuname;
    String cpufreq;
    String mem;

    public StatInfoMessage(String ip, int mpdPort) {
        this.ip = ip;
        this.mpdPort = mpdPort;
        this.mpdVer = Version.MAINVERSION + "." + Version.SUBVERSION;
        this.procInfo = new Vector();
        this.osname = System.getProperty("os.name");
        this.arch = System.getProperty("os.arch");
        String[] cpuinfo = OsInfo.cpuInfo();
        String[] meminfo = OsInfo.memInfo();
        if (meminfo != null) {
            this.mem = meminfo[0];
        }
        if (cpuinfo == null) {
            this.cpuname = "N/A";
            this.cpufreq = "N/A";
        } else {
            this.cpuname = cpuinfo[0];
            this.cpufreq = cpuinfo[1];
        }
    }

    public StatInfoMessage(String ip, int mpdPort, String version, String osName, String arch, String cpuName, String cpuFreq, String mem) {
        this.ip = ip;
        this.mpdPort = mpdPort;
        this.mpdVer = version;
        this.procInfo = null;
        this.osname = osName;
        this.arch = arch;
        this.cpuname = cpuName;
        this.cpufreq = cpuFreq;
        this.mem = mem;
    }

    public void addInfo(ProcessInfo info) {
        this.procInfo.addElement(info);
    }

    public ProcessInfo getInfo(int index) {
        return this.procInfo.elementAt(index);
    }

    public int size() {
        if (this.procInfo != null) {
            return this.procInfo.size();
        }
        return 0;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getMpdVer() {
        return this.mpdVer;
    }

    public int getMpdPort() {
        return this.mpdPort;
    }

    public String getOsName() {
        return this.osname;
    }

    public String getArch() {
        return this.arch;
    }

    public String getCpuName() {
        return this.cpuname;
    }

    public String getCpuFreq() {
        return this.cpufreq;
    }

    public String getMem() {
        return this.mem;
    }
}

