/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Vector;
import p2pmpi.common.FileCharacteristics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTMessage
implements Serializable {
    private static final long serialVersionUID = 2000015L;
    int cmd;
    String hashID;
    String[] onlyFileNameList;
    boolean[] notToBeSent;
    Vector<FileCharacteristics> fileCharacteristicsVector;
    long[] fileSize;
    URI[] uriList;
    URI replyURI;
    int[] keyList;
    byte[][] fileContent;
    int size;
    URI rank0URI;
    int key;

    public FTMessage(int cmd, String hashID) {
        this.cmd = cmd;
        this.hashID = hashID;
    }

    public void setKeys(int[] keyList) {
        this.keyList = keyList;
    }

    public void setURIs(URI[] uriList) {
        this.uriList = uriList;
    }

    public int[] getKeys() {
        return this.keyList;
    }

    public URI[] getURIs() {
        return this.uriList;
    }

    public void setRank0URI(URI rank0URI) {
        this.rank0URI = rank0URI;
    }

    public void setReplyURI(URI replyURI) {
        this.replyURI = replyURI;
    }

    public URI getReplyURI() {
        return this.replyURI;
    }

    public void setFileContent(String[] fList) throws Exception {
        this.fileContent = new byte[fList.length][];
        for (int i = 0; i < fList.length; ++i) {
            File tmpfile = new File(fList[i]);
            if (fList[i].startsWith("http://")) {
                this.fileContent[i] = new byte[56];
                continue;
            }
            tmpfile = new File(fList[i]);
            int fileSize = (int)tmpfile.length();
            try {
                this.fileContent[i] = new byte[fileSize];
                FileInputStream files = new FileInputStream(fList[i]);
                files.read(this.fileContent[i], 0, fileSize);
                files.close();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.gc();
                System.out.println("** [FT] file " + fList[i] + " to big to fit in memory.");
                throw new Exception("OutOfMemoryError while loading " + fList[i]);
            }
            catch (Exception e) {
                System.out.println("** [FT] Error trying to access file " + fList[i]);
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }

    public void setFileCharacteristicsVector(Vector<FileCharacteristics> fileCharacteristicsVector) {
        this.fileCharacteristicsVector = fileCharacteristicsVector;
    }

    public Vector<FileCharacteristics> getFileCharacteristicsVector() {
        return this.fileCharacteristicsVector;
    }

    public void setBooleanSent(boolean[] notToBeSent) {
        this.notToBeSent = notToBeSent;
    }

    public boolean[] getBooleanSent() {
        return this.notToBeSent;
    }

    public void setOnlyFileNameList(String[] onlyFileNameList) {
        this.onlyFileNameList = onlyFileNameList;
    }

    public String[] getOnlyFileNameList() {
        return this.onlyFileNameList;
    }

    public byte[] getFileContent(int index) {
        return this.fileContent[index];
    }

    public void setSize(int size) {
        this.size = size;
    }

    public URI getRank0URI() {
        return this.rank0URI;
    }

    public void setCmd(int Cmd) {
        this.cmd = Cmd;
    }

    public int getCmd() {
        return this.cmd;
    }

    public String getID() {
        return this.hashID;
    }

    public int getKey(int index) {
        return this.keyList[index];
    }

    public URI getURI(int index) {
        return this.uriList[index];
    }

    public int size() {
        return this.size;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public int getKey() {
        return this.key;
    }
}

