/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;
import java.net.URI;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankTable
implements Serializable {
    private static final long serialVersionUID = 1000004L;
    Vector<TableInfo> table = new Vector();
    int numProcess;
    int numReplica;

    public void addProcess(int rank, URI cmdURI, URI ctrlURI, URI dataURI, int fdPort) {
        TableInfo tableInfo = new TableInfo(rank, cmdURI, ctrlURI, dataURI, true, fdPort);
        this.table.addElement(tableInfo);
    }

    public void setNumProcess(int numProcess) {
        this.numProcess = numProcess;
    }

    public void setNumReplica(int numReplica) {
        this.numReplica = numReplica;
    }

    public int getNumProcess() {
        return this.numProcess;
    }

    public int getNumReplica() {
        return this.numReplica;
    }

    public int size() {
        return this.table.size();
    }

    public URI getDataURI(int index) {
        return this.table.elementAt(index).getDataURI();
    }

    public String getCmdHost(int index) {
        return this.table.elementAt(index).getCmdURI().getHost();
    }

    public int getCmdPort(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return this.table.elementAt(index).getCmdURI().getPort();
    }

    public URI getCmdURI(int index) {
        return this.table.elementAt(index).getCmdURI();
    }

    public URI getCtrlURI(int index) {
        return this.table.elementAt(index).getCtrlURI();
    }

    public String getCtrlHost(int index) {
        return this.table.elementAt(index).getCtrlURI().getHost();
    }

    public int getCtrlPort(int index) {
        return this.table.elementAt(index).getCtrlURI().getPort();
    }

    public String getDataHost(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.getDataURI().getHost();
    }

    public int getDataPort(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.getDataURI().getPort();
    }

    public int getFDPort(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.getFDPort();
    }

    public int getRank(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.getRank();
    }

    public boolean isAlive(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.isAlive();
    }

    public boolean isTerminated(int index) {
        TableInfo tmp = this.table.elementAt(index);
        return tmp.isTerminated();
    }

    public void setAlive(int index, boolean alive) {
        TableInfo tmp = this.table.elementAt(index);
        tmp.setAlive(alive);
    }

    public void setTerminated(int index, boolean terminated) {
        TableInfo tmp = this.table.elementAt(index);
        tmp.setTerminated(terminated);
    }

    public URI[] getURIs() {
        int size = this.size();
        URI[] result = new URI[size];
        for (int i = 0; i < size; ++i) {
            TableInfo tmp = this.table.elementAt(i);
            try {
                result[i] = new URI(tmp.getCmdURI().toString());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public URI[] getFDURIs() {
        int size = this.size();
        URI[] result = new URI[size];
        for (int i = 0; i < size; ++i) {
            TableInfo tmp = this.table.elementAt(i);
            try {
                result[i] = new URI(tmp.getFDURI().toString());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public Vector<Integer> getRankInListByRank(int rank) {
        Vector<Integer> result = new Vector<Integer>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            TableInfo tmp = this.table.elementAt(i);
            if (tmp.getRank() != rank || !tmp.isAlive()) continue;
            Integer element = new Integer(i);
            result.addElement(element);
        }
        return result;
    }

    public int getRankInReplica(URI uri, int rankInList) {
        int size = this.size();
        int position = 0;
        TableInfo tmp = this.table.elementAt(rankInList);
        int rank = tmp.getRank();
        for (int i = 0; i < size; ++i) {
            tmp = this.table.elementAt(i);
            if (tmp.getRank() != rank) continue;
            if (tmp.getDataURI().toString().equals(uri.toString())) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public Vector<URI> getURIByRank(int rank) {
        Vector<URI> result = new Vector<URI>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            TableInfo tmp = this.table.elementAt(i);
            if (tmp.getRank() != rank || !tmp.isAlive()) continue;
            result.addElement(tmp.getCmdURI());
        }
        return result;
    }

    public class TableInfo
    implements Serializable {
        private static final long serialVersionUID = 1000006L;
        int rank;
        URI cmdURI;
        URI ctrlURI;
        URI dataURI;
        boolean alive;
        int fdPort;
        boolean terminated;

        public TableInfo(int rank, URI cmdURI, URI ctrlURI, URI dataURI, boolean alive, int fdPort) {
            this.rank = rank;
            this.cmdURI = cmdURI;
            this.ctrlURI = ctrlURI;
            this.dataURI = dataURI;
            this.alive = alive;
            this.terminated = false;
            this.fdPort = fdPort;
        }

        public void setAlive(boolean alive) {
            this.alive = alive;
        }

        public void setTerminated(boolean terminated) {
            this.terminated = terminated;
        }

        public void setFDPort(int fdPort) {
            this.fdPort = fdPort;
        }

        public int getFDPort() {
            return this.fdPort;
        }

        public URI getFDURI() {
            URI result = null;
            try {
                result = new URI("tcp://" + this.cmdURI.getHost() + ":" + this.fdPort);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        public boolean isAlive() {
            return this.alive;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public URI getCmdURI() {
            return this.cmdURI;
        }

        public URI getDataURI() {
            return this.dataURI;
        }

        public URI getCtrlURI() {
            return this.ctrlURI;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

