/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class OsInfo {
    private static String[] normalizedOsCategory = new String[]{"Linux", "Windows", "Macosx", "SunOS", "WindowsVista"};

    public static String getName() {
        return System.getProperty("os.name");
    }

    public static boolean equalsOs(String realName, String suspectedOs) {
        String simpleRealName = realName.replaceAll(" ", "").toLowerCase();
        return simpleRealName.startsWith(suspectedOs.toLowerCase());
    }

    public static boolean isLinux(String s) {
        return OsInfo.equalsOs(s, normalizedOsCategory[0]);
    }

    public static boolean isWindows(String s) {
        return OsInfo.equalsOs(s, normalizedOsCategory[1]);
    }

    public static boolean isWindowsVista(String s) {
        return OsInfo.equalsOs(s, normalizedOsCategory[4]);
    }

    public static boolean isMacosx(String s) {
        return OsInfo.equalsOs(s, normalizedOsCategory[2]);
    }

    public static String normalizedOsInfo(String s) {
        for (int i = 0; i < normalizedOsCategory.length; ++i) {
            if (!OsInfo.equalsOs(s, normalizedOsCategory[i])) continue;
            return normalizedOsCategory[i];
        }
        return "Unknown";
    }

    public static String[] cpuInfo() {
        String[] infos = null;
        String s = OsInfo.getName();
        if (OsInfo.isLinux(s)) {
            try {
                FileInputStream fstream = new FileInputStream("/proc/cpuinfo");
                BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                boolean stop = false;
                infos = new String[2];
                while (!stop) {
                    String[] m;
                    String tmp = in.readLine();
                    if (tmp.startsWith("model name")) {
                        m = tmp.split(":", 2);
                        infos[0] = new String(m[1]);
                    }
                    if (!tmp.startsWith("cpu MHz")) continue;
                    m = tmp.split(":", 2);
                    infos[1] = new String(m[1]);
                    stop = true;
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("** Warning: could not read /proc/cpuinfo filesystem.");
            }
        }
        if (OsInfo.isMacosx(s)) {
            String modelSymbol = "hw.model =";
            String freqSymbol = "hw.cpufrequency =";
            try {
                Process sysctl = Runtime.getRuntime().exec("sysctl hw");
                InputStream stdout = sysctl.getInputStream();
                InputStreamReader isr = new InputStreamReader(stdout);
                BufferedReader br = new BufferedReader(isr);
                String tmp = null;
                infos = new String[2];
                while ((tmp = br.readLine()) != null) {
                    if (tmp.startsWith(modelSymbol)) {
                        infos[0] = tmp.substring(tmp.indexOf("=") + 1);
                    }
                    if (!tmp.startsWith(freqSymbol)) continue;
                    infos[1] = tmp.substring(tmp.indexOf("=") + 1);
                }
                if (infos[0] == null || infos[1] == null) {
                    infos = null;
                }
                int exitVal = sysctl.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return infos;
    }

    public static String[] memInfo() {
        String[] infos = null;
        String s = OsInfo.getName();
        if (OsInfo.isLinux(s)) {
            try {
                FileInputStream fstream = new FileInputStream("/proc/meminfo");
                BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                String tmp = in.readLine();
                String[] m = tmp.split(":", 2);
                infos = new String[]{new String(m[1])};
                in.close();
            }
            catch (Exception e) {
                System.err.println("** Warning: could not read /proc/meminfo filesystem.");
            }
        }
        if (OsInfo.isMacosx(s)) {
            String memsizeSymbol = "hw.memsize:";
            try {
                Process sysctl = Runtime.getRuntime().exec("sysctl -a hw");
                InputStream stdout = sysctl.getInputStream();
                InputStreamReader isr = new InputStreamReader(stdout);
                BufferedReader br = new BufferedReader(isr);
                String tmp = null;
                while ((tmp = br.readLine()) != null) {
                    if (!tmp.startsWith(memsizeSymbol)) continue;
                    infos = new String[]{tmp.substring(tmp.indexOf(":") + 1)};
                }
                int exitVal = sysctl.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return infos;
    }

    public static int mklink(File appDir, File cacheDir, String fileName) {
        String osname = OsInfo.getName();
        String exe = null;
        if (OsInfo.isLinux(osname) || OsInfo.isMacosx(osname)) {
            exe = new String("ln -s " + cacheDir + File.separator + fileName + " " + appDir + File.separator + fileName);
        } else if (OsInfo.isWindowsVista(osname)) {
            exe = new String("cmd /C mklink \"" + appDir + File.separator + fileName + "\" " + cacheDir + File.separator + fileName + "\"");
        } else {
            return -1;
        }
        try {
            Process result = Runtime.getRuntime().exec(exe);
            result.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        String s = OsInfo.getName();
        System.out.println("Exact system name as returned by  System.getProperty() : " + s);
        System.out.println("normalizedOsInfo(" + s + ") : " + OsInfo.normalizedOsInfo(s));
        System.out.println("normalizedOsInfo(Mac Os X) : " + OsInfo.normalizedOsInfo("Mac Os X"));
        System.out.println("Is Linux : " + OsInfo.isLinux(s));
        System.out.println("Is Windows : " + OsInfo.isWindows(s));
        System.out.println("Is MacOSX : " + OsInfo.isMacosx(s));
        String[] cpuinfo = OsInfo.cpuInfo();
        String[] meminfo = OsInfo.memInfo();
        if (cpuinfo != null) {
            System.out.println("CPU model:" + cpuinfo[0] + " / " + cpuinfo[1] + "MHz");
        } else {
            System.out.println("CPU model: N/A");
        }
        if (meminfo != null) {
            System.out.println("RAM:" + meminfo[0]);
        } else {
            System.out.println("RAM: N/A");
        }
    }
}

