/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class NetIface {
    private byte LINKLOCAL = 1;
    private byte LOOPBACK = (byte)2;
    private byte SITELOCAL = (byte)4;
    private byte IPV4 = (byte)8;
    private byte IPV6 = (byte)16;
    private String INVALID_TAG = "invalid";
    private String ifname = null;
    private String canonicalHostName = null;
    private HashMap<String, Byte> ifaceMapNameType = new HashMap();
    private HashMap<String, InetAddress> ifaceMapNameAddress = new HashMap();
    private String selectedIface = null;
    private String errIfaceMsg = null;
    private String errAddrMsg = null;
    private String extIfIpv4Address = null;
    private String extIfIpv6Address = null;
    private String intIfIpv4Address = null;
    private String intIfIpv6Address = null;

    public NetIface() {
        NetworkInterface iface = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                iface = ifaces.nextElement();
                InetAddress ia = null;
                byte type = 0;
                Enumeration<InetAddress> ips = iface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ia = ips.nextElement();
                    if (NetIface.isIPv4Address(ia.getAddress())) {
                        type = (byte)(type | this.IPV4);
                    }
                    if (NetIface.isIPv6Address(ia.getAddress())) {
                        type = (byte)(type | this.IPV6);
                    }
                    if (ia.isLinkLocalAddress()) {
                        type = (byte)(type | this.LINKLOCAL);
                    }
                    if (ia.isSiteLocalAddress()) {
                        type = (byte)(type | this.SITELOCAL);
                    }
                    if (ia.isLoopbackAddress()) {
                        type = (byte)(type | this.LOOPBACK);
                    }
                    if (this.isUsable(type)) {
                        this.selectedIface = iface.getDisplayName();
                    }
                    if (!NetIface.isIPv4Address(ia.getAddress())) continue;
                    this.ifaceMapNameType.put(iface.getDisplayName(), new Byte(type));
                    this.ifaceMapNameAddress.put(iface.getDisplayName(), ia);
                }
            }
        }
        catch (SocketException e) {
            System.err.println("[Error] cannot determine network interfaces.");
        }
    }

    public NetIface(String prefIface, String prefAddress) {
        this();
        if (this.ifaceMapNameType.containsKey(prefIface)) {
            Byte ifTypeValue = this.ifaceMapNameType.get(prefIface);
            byte ifType = ifTypeValue;
            if (this.isUsable(ifType)) {
                this.selectedIface = prefIface;
            } else {
                this.errIfaceMsg = "the specified network interface '" + prefIface + "' is not usable.";
            }
        } else if (prefIface != null && prefIface.length() > 0) {
            this.errIfaceMsg = "the specified network interface '" + prefIface + "' does not exist.";
        }
        if (prefAddress != null) {
            try {
                InetAddress ia = InetAddress.getByName(prefAddress);
                this.extIfIpv4Address = this.splitStringAddress(ia.toString());
            }
            catch (UnknownHostException e) {
                this.errAddrMsg = "the specified address '" + prefAddress + "' represents an unknown host.";
                this.extIfIpv4Address = this.INVALID_TAG;
            }
        }
    }

    private boolean isUsable(byte mask) {
        return (mask & this.IPV4) == this.IPV4 && (mask & this.LOOPBACK) != this.LOOPBACK;
    }

    public String getErrorIfaceMsg() {
        return this.errIfaceMsg;
    }

    public String getErrorAddrMsg() {
        return this.errAddrMsg;
    }

    public String getIfaceType(String ifName) {
        if (!this.ifaceMapNameType.containsKey(ifName)) {
            return null;
        }
        String typeLine = "";
        Byte ifTypeValue = this.ifaceMapNameType.get(ifName);
        byte ifType = ifTypeValue;
        if ((ifType & this.IPV4) == this.IPV4) {
            typeLine = typeLine + "ipv4 ";
        }
        if ((ifType & this.LINKLOCAL) == this.LINKLOCAL) {
            typeLine = typeLine + "link-local ";
        }
        if ((ifType & this.SITELOCAL) == this.SITELOCAL) {
            typeLine = typeLine + "site-local ";
        }
        if ((ifType & this.LOOPBACK) == this.LOOPBACK) {
            typeLine = typeLine + "loopback ";
        }
        return typeLine;
    }

    public String getAllIface(boolean withType) {
        String typeTab = "";
        for (Map.Entry<String, Byte> me : this.ifaceMapNameType.entrySet()) {
            typeTab = typeTab + "[" + me.getKey() + "] ";
            if (!withType) continue;
            typeTab = typeTab + this.getIfaceType(me.getKey()) + "\n";
        }
        return typeTab;
    }

    private String splitStringAddress(String s) {
        String[] ret = s.split("/", 2);
        if (ret[0].length() > 0) {
            return ret[0];
        }
        return ret[1];
    }

    public String getIfName() {
        return this.selectedIface;
    }

    private void setExternalIpv4(String ifName) {
        byte[] ip = null;
        InetAddress ia = this.ifaceMapNameAddress.get(ifName);
        this.canonicalHostName = ia.getCanonicalHostName();
        if (ia != null) {
            ip = ia.getAddress();
        }
        if (NetIface.isIPv4Address(ip)) {
            this.extIfIpv4Address = this.splitStringAddress(ia.toString());
        }
        if (NetIface.isIPv6Address(ip)) {
            this.extIfIpv6Address = this.splitStringAddress(ia.toString());
        }
    }

    public String getExternalIfIpv4() {
        if (this.extIfIpv4Address == null) {
            this.setExternalIpv4(this.selectedIface);
            return this.extIfIpv4Address;
        }
        if (this.extIfIpv4Address.equals(this.INVALID_TAG)) {
            return null;
        }
        return this.extIfIpv4Address;
    }

    public String getExternalIfIpv6() {
        if (this.extIfIpv6Address == null) {
            return null;
        }
        return this.splitStringAddress(this.extIfIpv6Address);
    }

    public String getInternalIfIpv4() {
        if (this.intIfIpv4Address == null) {
            InetAddress ia = this.ifaceMapNameAddress.get(this.selectedIface);
            this.intIfIpv4Address = this.splitStringAddress(ia.toString());
            return this.intIfIpv4Address;
        }
        return this.intIfIpv4Address;
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    private static boolean isIPv6Address(byte[] address) {
        try {
            Inet6Address.getByAddress(address);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isIPv4Address(byte[] address) {
        return address.length == 4;
    }

    public static void main(String[] args) {
        String prefIface = null;
        String prefIp = null;
        if (args.length >= 1) {
            prefIface = args[0];
            if (args.length >= 2) {
                prefIp = args[1];
            }
        }
        NetIface extIf = new NetIface(prefIface, prefIp);
        String ifName = extIf.getIfName();
        String ifIntAddr = extIf.getInternalIfIpv4();
        String ifExtAddr = extIf.getExternalIfIpv4();
        if (ifName == null) {
            System.out.println("[Error] setting interface name: '" + extIf.getErrorIfaceMsg() + "'");
            System.out.println("[Info] this interface has properties: " + extIf.getIfaceType(prefIface));
        }
        if (ifExtAddr == null || ifIntAddr == null) {
            System.out.println("[Error] setting interface address: '" + extIf.getErrorAddrMsg() + "'");
        }
        System.out.println("* selected interface: [" + ifName + "] int/ext ipv4: [" + ifIntAddr + "/" + ifExtAddr + "]");
    }
}

