/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRankTable
implements Serializable {
    private static final long serialVersionUID = 1000000L;
    Vector<MapTableInfo> mapTable = new Vector();

    public void addMap(int currentRank, int worldRank, int rankInList) {
        MapTableInfo tableInfo = new MapTableInfo(currentRank, worldRank, rankInList);
        this.mapTable.addElement(tableInfo);
    }

    public int size() {
        return this.mapTable.size();
    }

    public int getCurrentRank(int index) {
        MapTableInfo tmp = this.mapTable.elementAt(index);
        return tmp.getCurrentRank();
    }

    public int getWorldRank(int index) {
        MapTableInfo tmp = this.mapTable.elementAt(index);
        return tmp.getWorldRank();
    }

    public int getRankInList(int index) {
        MapTableInfo tmp = this.mapTable.elementAt(index);
        return tmp.getRankInList();
    }

    public Vector<Integer> getRankInListByWorldRank(int worldRank) {
        Vector<Integer> result = new Vector<Integer>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MapTableInfo tmp = this.mapTable.elementAt(i);
            if (tmp.getWorldRank() != worldRank) continue;
            Integer element = new Integer(tmp.getRankInList());
            result.addElement(element);
        }
        return result;
    }

    public Vector<Integer> getRankInListByCurrentRank(int currentRank) {
        Vector<Integer> result = new Vector<Integer>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MapTableInfo tmp = this.mapTable.elementAt(i);
            if (tmp.getCurrentRank() != currentRank) continue;
            Integer element = new Integer(tmp.getRankInList());
            result.addElement(element);
        }
        return result;
    }

    public class MapTableInfo
    implements Serializable {
        private static final long serialVersionUID = 1000001L;
        int currentRank;
        int worldRank;
        int rankInList;

        public MapTableInfo(int currentRank, int worldRank, int rankInList) {
            this.currentRank = currentRank;
            this.worldRank = worldRank;
            this.rankInList = rankInList;
        }

        public int getCurrentRank() {
            return this.currentRank;
        }

        public int getWorldRank() {
            return this.worldRank;
        }

        public int getRankInList() {
            return this.rankInList;
        }
    }
}

