/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostEntry
implements Serializable {
    private static final long serialVersionUID = 1000002L;
    String ip;
    int fdPort;
    int ftPort;
    int mpdPort;
    int rsPort;
    int numProcPerJob;
    boolean alive;
    int rtt;
    long lastUpdate;
    private Vector<String> cacheMd5sums = new Vector();

    public HostEntry(String ip, int mpdPort, int fdPort, int ftPort, int rsPort, int numProcPerJob) {
        this.ip = ip;
        this.mpdPort = mpdPort;
        this.fdPort = fdPort;
        this.ftPort = ftPort;
        this.rsPort = rsPort;
        this.alive = true;
        this.rtt = Integer.MAX_VALUE;
        this.numProcPerJob = numProcPerJob;
        this.lastUpdate = System.currentTimeMillis();
        this.cacheMd5sums = new Vector();
    }

    public void setLastUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setFdPort(int fdPort) {
        this.fdPort = fdPort;
    }

    public void setFtPort(int ftPort) {
        this.ftPort = ftPort;
    }

    public void setMpdPort(int mpdPort) {
        this.mpdPort = mpdPort;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void setRtt(int rtt) {
        if (rtt < this.rtt) {
            this.rtt = rtt;
        }
    }

    public void setNumProcPerJob(int numProcPerJob) {
        this.numProcPerJob = numProcPerJob;
    }

    public String getIp() {
        return this.ip;
    }

    public int getFdPort() {
        return this.fdPort;
    }

    public int getFtPort() {
        return this.ftPort;
    }

    public int getMpdPort() {
        return this.mpdPort;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public int getRtt() {
        return this.rtt;
    }

    public int getNumProcPerJob() {
        return this.numProcPerJob;
    }

    public long getLastUpdate() {
        return System.currentTimeMillis() - this.lastUpdate;
    }

    public boolean isUpdate() {
        return System.currentTimeMillis() - this.lastUpdate < 240000L;
    }

    public int getRsPort() {
        return this.rsPort;
    }

    public String toString() {
        return this.ip + ":" + this.mpdPort + ":" + this.fdPort + ":" + this.ftPort + ":" + this.rsPort + ":" + this.numProcPerJob;
    }

    public void updateCacheMd5sums(Vector<String> md5s) {
        this.cacheMd5sums = md5s;
    }

    public Vector<String> getCacheMd5sums() {
        return this.cacheMd5sums;
    }
}

