/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import p2pmpi.common.FileCharacteristics;
import p2pmpi.common.Md5sum;
import p2pmpi.common.NioCopier;
import p2pmpi.common.OsInfo;
import p2pmpi.common.StreamSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCache {
    private long DISK_CACHE_SIZE_LIMIT = 0xC800000L;
    private final String DEFAULT_DISK_CACHE_DIRNAME = "datacache";
    private String diskCacheDir;
    private long diskCacheSizeBytes = 0L;
    private File diskCache = null;
    private static String hostIP = null;
    private static String osname = OsInfo.getName();

    public DiskCache(String dir, String diskCacheDir, String diskCacheSize) {
        this.diskCache = diskCacheDir != null ? new File(dir + File.separatorChar + diskCacheDir) : new File(dir + File.separatorChar + "datacache");
        try {
            this.diskCacheSizeBytes = Math.min(Long.parseLong(diskCacheSize) * 1024L * 1024L, this.DISK_CACHE_SIZE_LIMIT);
        }
        catch (NumberFormatException e) {
            System.err.println("[DiskCache] bad cache size specification.");
            this.diskCacheSizeBytes = 0L;
        }
        if (!this.diskCache.exists() && !this.diskCache.mkdirs()) {
            System.out.println("[DiskCache] error creating cache " + this.diskCache);
            this.diskCache = null;
            this.diskCacheSizeBytes = 0L;
        }
    }

    public DiskCache(String dir, String diskCacheDir) {
        this.diskCache = diskCacheDir != null ? new File(dir + File.separatorChar + diskCacheDir) : new File(dir + File.separatorChar + "datacache");
        if (!this.diskCache.exists() && !this.diskCache.mkdirs()) {
            System.out.println("[DiskCache] error creating cache " + this.diskCache);
            this.diskCache = null;
            this.diskCacheSizeBytes = 0L;
        }
    }

    public long getSize() {
        return this.diskCacheSizeBytes;
    }

    public File getDir() {
        return this.diskCache;
    }

    public long getUsedSize() {
        long cacheUsed = 0L;
        File[] files = this.getDir().listFiles();
        for (int i = 0; i < files.length; ++i) {
            cacheUsed += files[i].length();
        }
        return cacheUsed;
    }

    public boolean canContain(long size) {
        return this.getUsedSize() + size < this.getSize();
    }

    public Vector<String> searchByMd5(String md5sum) {
        Vector<String> matches = new Vector<String>();
        File[] files = this.getDir().listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!md5sum.equals(Md5sum.md5sum(files[i]))) continue;
            matches.add(files[i].getName());
        }
        return matches;
    }

    public Vector<String> getMd5s() {
        Vector<String> sums = new Vector<String>();
        File[] files = this.getDir().listFiles();
        for (int i = 0; i < files.length; ++i) {
            sums.add(Md5sum.md5sum(files[i]));
        }
        return sums;
    }

    private boolean reclaimLRU(long size) {
        int k;
        File[] files;
        if (size > this.getSize()) {
            return false;
        }
        long occupied = this.getUsedSize();
        do {
            long minTime = Long.MAX_VALUE;
            files = this.getDir().listFiles();
            k = 0;
            for (int j = 0; j < files.length; ++j) {
                if (minTime <= files[j].lastModified()) continue;
                minTime = files[j].lastModified();
                k = j;
            }
            files[k].delete();
        } while ((occupied -= files[k].length()) + size > this.getSize());
        return true;
    }

    public boolean writeToLRU(InputStream stream, String filename, long filesize) {
        if (!this.canContain(filesize) && !this.reclaimLRU(filesize)) {
            System.err.println("[DiskCache] reclaimed " + filesize + " bytes which is greater than cache capacity (" + this.getSize() + ")");
            return false;
        }
        StreamSaver sv = new StreamSaver();
        long bytesRead = sv.saveNetworkInputStream(this.getDir(), filename, filesize, stream);
        if (bytesRead != filesize) {
            System.out.println("[FT] internal error for file " + filename + ": advertized=" + filesize + ", read=" + bytesRead);
            return false;
        }
        return true;
    }

    public int publishFiles(File appDir, Vector<FileCharacteristics> fileCharacs) {
        String osname = OsInfo.getName();
        int numFile = fileCharacs.size();
        if (OsInfo.isWindows(osname) & !OsInfo.isWindowsVista(osname)) {
            String[] fileNames = this.diskCache.list();
            for (int i = 0; i < numFile; ++i) {
                if (!fileCharacs.elementAt(i).isToBeCached()) continue;
                for (int j = 0; j < fileNames.length; ++j) {
                    if (!fileCharacs.elementAt(i).getMd5sum().equals(Md5sum.md5sum(new File(this.diskCache + File.separator + fileNames[j])))) continue;
                    try {
                        NioCopier fc = new NioCopier();
                        fc.copy(new File(this.diskCache, fileNames[j]), new File(appDir, fileNames[j]));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            for (int i = 0; i < numFile; ++i) {
                int returnvalue;
                if (!fileCharacs.elementAt(i).isToBeCached() || (returnvalue = OsInfo.mklink(appDir, this.diskCache, fileCharacs.elementAt(i).getOnlyFileName())) != -1) continue;
                System.err.println("** [Error] link could not be made to the files in data cache.");
                return -1;
            }
        }
        return 0;
    }
}

