package p2pmpi.tools;

import p2pmpi.common.*;
import p2pmpi.message.*;
import java.net.*;
import java.io.*;

public class MPDInfo {
	static public void main(String[] args) {
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		int mpdPort 	= ppConf.getMPDPort();
		System.out.println("Trying to connect to 127.0.0.1:" + mpdPort + "...");
		
		Socket sock = null;
		try {
			sock = new Socket("127.0.0.1", mpdPort);
			InputStream in = sock.getInputStream();
			OutputStream out = sock.getOutputStream();

			ObjectOutputStream oos = new ObjectOutputStream(out);
			StatQueryMessage request = new StatQueryMessage();
			oos.writeObject(request);
			oos.flush();

			ObjectInputStream ois = new ObjectInputStream(in);
			StatInfoMessage statMsg = (StatInfoMessage)ois.readObject();
			System.out.println("========================================================");
			System.out.println("   Gatekeeper (mpd "+ statMsg.getMpdVer() +                      ") up and running.");
			int numApp = statMsg.size();
			if(numApp == 0) {
				System.out.println("   No application running.");
			} else {
				for(int i = 0; i < numApp; i++) {
					// --- must query running MPD (not necessarily oours) to get version number
					System.out.println("--------------------------------------------------------");
					System.out.println("   Application Name : " + statMsg.getInfo(i).getRunCmd());
					System.out.println("   MPI Rank   : " + statMsg.getInfo(i).getRank());
					System.out.println("   Local Port : " + statMsg.getInfo(i).getPort());
					System.out.println("   Rank 0 IP  : " + statMsg.getInfo(i).getIpRank0());
				}
			}
			System.out.println("========================================================");
			ois.close();
			oos.close();
			in.close();
			out.close();
			sock.close();
		} catch (Exception e) {
			System.out.println("=================================================================");
			System.out.println("  Could not connect to local gatekeeper. Have you run 'mpiboot' ?");
			System.out.println("=================================================================");
			System.exit(1); // so we can test the shell return code $?
		}

	}
}
