import p2pmpi.mpi.*;

public class TestReduceScatter {
	public static void main(String[] args) 
	{
		final int BUF = 4;
		MPI.Init(args);
		int size = MPI.COMM_WORLD.Size();
		int rank = MPI.COMM_WORLD.Rank();
		int[] sendBuf = new int[size * BUF];
		int[] recvBuf = new int[BUF];

		//Init sendBuf
		for(int i = 0; i < sendBuf.length; i++) {
			sendBuf[i] = i;
		}
		//Init recvBuf
		for(int i = 0; i < recvBuf.length; i++) {
			recvBuf[i] = 0;
		}
		int[] recvCount = new int[size];
		for(int i = 0; i < size; i++) {
			recvCount[i] = BUF;
		}	
		MPI.COMM_WORLD.Reduce_scatter(sendBuf, 0, recvBuf, 0, 
					      recvCount, MPI.INT, MPI.SUM);
		if(rank == 0) {
			System.out.println("=== Rank 0 ===");
			for(int j = 0; j < BUF; j++) {
				System.out.printf("%4d", recvBuf[j]);
			}
			System.out.println("");
			for(int i = 1; i < size; i++) {
				MPI.COMM_WORLD.Recv(recvBuf, 0, BUF, MPI.INT, i, 100);
				System.out.println("=== Rank " + i + " ===");
				for(int j = 0; j < BUF; j++) {
					System.out.printf("%4d", recvBuf[j]);
				}
				System.out.println("");
			}
		} else {
			MPI.COMM_WORLD.Send(recvBuf, 0, BUF, MPI.INT, 0, 100);
		}
		MPI.Finalize();
	}
}
