package p2pmpi.mpi.dev;

import java.io.*;
import java.nio.*;
import java.util.*;
import p2pmpi.message.*;
import p2pmpi.common.*;

public class SendBufferInformation {
	RankTable commTable;
	ByteBuffer data;
	Vector<Integer> dest;
	short commID;
	int src;
	int dst;
	int tag;
	int numsend;
	int[] repRankInList;

	String mid;
	public SendBufferInformation(RankTable commTable, ByteBuffer data, Vector<Integer> dest,
			short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {

		this.commTable	= commTable;
		this.data	= data;
		this.dest	= dest;
		this.commID	= commID;
		this.src	= src;
		this.dst	= dst;
		this.tag	= tag;
		this.numsend	= numsend;
		this.repRankInList = repRankInList;
	}

	public String toString() {
		return commID + "_" + src + "_" + dst + "_" + tag + "_" + numsend;
	}
	public RankTable getRankTable() {
		return commTable;
	}
	public ByteBuffer getData() {
		return data;
	}

	public Vector<Integer> getDestinations() {
		return dest;
	}

	public short getCommID() {
		return commID;
	}

	public int getSrc() {
		return src;
	}

	public int getDst() {
		return dst;
	}

	public int getTag() {
		return tag;
	}

	public int getNumSend() {
		return numsend;
	}

	public int[] getReplicaRankInList() {
		return repRankInList;
	}


}


