package p2pmpi.mpi.dev;

import java.nio.*;
import p2pmpi.message.*;
public abstract class P2PMPI_Buffer {
	//protected ByteBuffer myBuffer;
	public static int HEADER_SIZE = 24; //magic number(1)+messageType(1)+commID(2)+src(4)+dst(4)+tag(4)+numcount(4)+size(4)
	protected int baseSize;

	short commID;
	int src, dst, tag, numsend;

	public P2PMPI_Buffer(int baseSize) {
		this.baseSize = baseSize;
	}

	public static P2PMPI_Buffer createBuffer(int type, int baseSize) {
		switch(type) {
			case DevDatatype.BYTE :
				return new BufferByte(baseSize);
			case DevDatatype.CHAR :
				return new BufferChar(baseSize);
			case DevDatatype.SHORT :
				return new BufferShort(baseSize);
			case DevDatatype.INT :
				return new BufferInt(baseSize);
			case DevDatatype.DOUBLE:
				return new BufferDouble(baseSize);
			case DevDatatype.BOOLEAN :
				return new BufferBoolean(baseSize);
			case DevDatatype.FLOAT :
				return new BufferFloat(baseSize);
			case DevDatatype.LONG :
				return new BufferLong(baseSize);
			case DevDatatype.OBJECT :
				return new BufferObject(baseSize);
			case DevDatatype.STRING :
				return new BufferString(baseSize);
			case DevDatatype.NULL :
				return new BufferNull(baseSize);
		}
		return new BufferByte(baseSize);
	}

	public abstract Object createArrayBuffer(int count);
	public abstract ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count);
	public abstract int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize);

	public void fillHeader(ByteBuffer buff) {
		buff.put(DatMessage.MAGIC_NUMBER);
		buff.put(DatMessage.DATA_MESSAGE);
		buff.putShort(commID);
		buff.putInt(src);
		buff.putInt(dst);
		buff.putInt(tag);
		buff.putInt(numsend);
	}

	public synchronized ByteBuffer getByteBuffer(Object buffer, int offset, int count, short commID, 
			                int src, int dst, int tag, int numsend) {

		this.commID 	= commID;
		this.src	= src;
		this.dst	= dst;
		this.tag	= tag;
		this.numsend	= numsend;

		int dataSize = count*baseSize;
		//allocate data message
		ByteBuffer myBuffer = ByteBuffer.allocateDirect(HEADER_SIZE + dataSize);

		//fill header
		fillHeader(myBuffer);

		//fill size of data message
		myBuffer.putInt(dataSize);

		//fill data
		myBuffer = fillBuffer(myBuffer, buffer, offset, count);

		//reset position of byteBuffer
		myBuffer.flip();
		//myBuffer.position(0);
		//myBuffer.limit(myBuffer.capacity());

		return myBuffer;
	}
}
