package p2pmpi.mpi.dev;

import java.util.*;
import java.nio.*;
import java.nio.channels.*;

/**
 * The handle of asynchronous communication
 */
public class NIORequest {
	protected Object recvBuffer;
	protected int offset;
	protected int count;
	protected int src;
	protected int tag;
	protected int dst;

	Vector<SmallRequest> reqList;
	P2PMPI_Buffer buffer;
	IStatus status = null;

	protected volatile boolean completed;
	/**
	 * Internal use
	 */
	public NIORequest()
	{
		reqList = new Vector<SmallRequest>();
		completed = false;

	}

	public NIORequest(Object recvBuffer, int offset, int count, int src, int dst, int tag, P2PMPI_Buffer buffer)
	{
		this.recvBuffer = recvBuffer;
		this.offset	= offset;
		this.count	= count;
		this.src	= src;
		this.dst	= dst;
		this.tag	= tag;
		this.buffer	= buffer;
		reqList = new Vector<SmallRequest>();
		completed = false;
	}

	public void fillStatus(IStatus status) {
		this.status = status;
	}

	public void fillStatus(int src, int tag, int length) {
		this.status = new IStatus(src, tag, length);
	}

	public void fillStatus(IStatus status, int length) {
		this.status = status;
		this.status.setLength(length);
	}

	public synchronized void complete() {
		completed = true;
		try {
			notify();
			//System.out.println(dst + " : notify tag = " + tag);
		} catch(Exception e) {}
	}

	public void add(SmallRequest req) {
		reqList.addElement(req);
	}

	public int addData(ByteBuffer data, int dataSize) {
		return buffer.fillRecvData(recvBuffer, offset, count, data, dataSize);
	}

	/**
	 * Blocks until a waiting asynchronous message is received
	 */
	public IStatus Wait() {
		int waitSize = reqList.size();
		//System.out.println("NIOrequest -> waitSize = " + waitSize);
		if(waitSize != 0) {
			//Isend
			for(int i = 0; i < waitSize; i++) {
				//System.out.println("call smallWait");
				reqList.elementAt(i).Wait();
				//System.out.println("done smallWait");
			}
		} else {
			//Irecv
			while(!completed) {
				try {
					//System.out.println(dst + ": wait tag = " + tag);
					wait();
					//System.out.println(dst + ": unwait tag = " + tag);
				} catch(Exception e) {}
			}
		}
		return status;
	}
	/**
	 * Test if message reception has completed.
       * Returns a status object if the operation identified by the request is complete, 
       * or a null reference otherwise. Java binding of the MPI operation MPI_TEST. 
       * After the call, if the operation is complete (ie, if the return value of test is non-null), 
       * the request object becomes an inactive request.
	 **/
	public IStatus Test() {
            return status;
       }
}
