package p2pmpi.mpi.dev;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;
import java.util.concurrent.*;
import p2pmpi.common.*;
import p2pmpi.message.*;

public abstract class Device  implements Runnable {
	protected MessageHandler msgHandle;
	protected int myRank;
	public int numReplica;
	protected int numProc;
	protected int myRankInRep;
	protected int myRankInList;
	protected RankTable rankTable;
	protected boolean terminated;
	protected String myHash;
	protected int fdPort;
	protected int mpdPort;

	protected Vector<RecvBufferInformation> unexpectedQueue;
	protected Vector<RecvBufferInformation> expectedQueue;


	protected Vector<SendBufferInformation> backupBuffer;
	protected MessageIDLog recvLog;
	protected MessageIDLog sendLog;
   	protected boolean master;
        protected int myMaster;
   	protected Map commMap;
	protected RankTable commWorld;

	protected ExecutorService tpes;
	protected boolean N_POWER2;

	public static int EAGER_SIZE = 131072; // 128 KB
//   	protected Properties midLog = new Properties();


	public Device() {
		unexpectedQueue = new Vector<RecvBufferInformation>();
		expectedQueue = new Vector<RecvBufferInformation>();
		backupBuffer = new Vector<SendBufferInformation>();
		recvLog = new MessageIDLog();
		sendLog = new MessageIDLog();
		commMap = new HashMap();
		N_POWER2 = false;
	}

	public boolean isPower2() {
		return N_POWER2;
	}

	public abstract boolean isDone();
	public abstract boolean init();
	public abstract int initPort(int minPort, int maxPort, String bindIP);
	public abstract boolean init(ServerSocket cmdSocket, String myHash, int mpdPort, int fdPort);
	public abstract void spawnMessageHandler(ServerSocket cmdSocket, 
			int numPeers, RankTable rankTable,
			String hash, int mpdPort, int fdPort,
			int tGossip, int tMargin, int tHang,
			String protocol);
	public abstract void connect(int rank, int rankInRep, int rankInList, RankTable rankTable,
					int numPeers, int numReplica);
	public abstract boolean connectToNode(URI uri, int itsRank, int itsRankInRep, SocketChannel[][] channels, byte isInput);

	public abstract void doFailureRepair(int deadNodeRankInList);
	public abstract void run();
	public abstract void commit(RankTable commTable, int[] repRankInList,
			short commID, int src, int dst, int tag, int numsend);

	public abstract int ssend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID,
		                 int src, int dst, int tag, int numsend, int[] repRankInList);
  	public abstract NIORequest issend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID,
		                          int src, int dst, int tag, int numsend, int[] repRankInList);
	/*
	public abstract int ssend(RankTable commTable, ByteBuffer data, short commID,
		                 int src, int dst, int tag, int numsend, int[] repRankInList);
  	public abstract NIORequest issend(RankTable commTable, ByteBuffer data, short commID,
		                          int src, int dst, int tag, int numsend, int[] repRankInList);
					  */
	
	
	public abstract int send(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID,
		                 int src, int dst, int tag, int numsend, int[] repRankInList);
  public abstract NIORequest isend(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID,
		                          int src, int dst, int tag, int numsend, int[] repRankInList);
	public abstract IStatus recv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer);
	public abstract NIORequest irecv(Object recvBuffer, int offset, int count, short commID, int src, int dst, int tag, int numsend, P2PMPI_Buffer buffer);


	public abstract void finalizeConfirm();
	public abstract void finalize(int rankInList);


	public boolean isAllTerminated() {
		synchronized(rankTable) {
			for(int i = 0; i < rankTable.size(); i++) {
				if(!rankTable.isTerminated(i)) {
					return false;
				}
			} 
			return true;
		}
	}

	public boolean isTerminated() {
		return terminated;
	}

	public void meTerminated() {
		synchronized(rankTable) {
			rankTable.setTerminated(0, true);
		}
	}


	/*
	public void setSendBackupAndLog(Vector<SendBufferInformation> backupBuffer, MessageIDLog sendLog) {
		this.backupBuffer = backupBuffer;
		this.sendLog      = sendLog;
	}
	*/

	public void setMaster(boolean master) {
		this.master = master;
	}
	public void setMyMaster(int myMaster) {
		this.myMaster = myMaster;
	}
	public boolean isMaster() {
		return master;
	}
	public int getRank() {
		return msgHandle.getRank();
	}

	public int getCommSize() {
		return msgHandle.getCommSize();
	}

	public int getTGossip() {
		return msgHandle.getTGossip();
	}

	public int getTMargin() {
		return msgHandle.getTMargin();
	}

	public int getTHang() {
		return msgHandle.getTHang();
	}

	public String getGossipProtocol() {
		return msgHandle.getGossipProtocol();
	}

	public int getTDiff() {
		return msgHandle.getTDiff();
	}

	public int getExpectedQueueSize() {
		return expectedQueue.size();
	}
	public int getUnexpectedQueueSize() {
		return unexpectedQueue.size();
	}



	public void shutdown() {
		msgHandle.shutdown();
		tpes.shutdownNow();
	}

	public boolean isRankTableReady() {
		return msgHandle.isReady();
	}

	public RankTable getRankTable() {
		return msgHandle.getRankTable();
	}

	public int getRankInList() {
		return msgHandle.getRankInList();
	}

	public boolean isRequestInExpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend) {
		RecvBufferInformation tmp;
		int numElement = expectedQueue.size();
		for(int i = 0; i < numElement; i++) {
			tmp = expectedQueue.elementAt(i);
			boolean match_dst = (tmp.commID() == commID) && (tmp.fromRank() == fromRank) && 
				(tmp.toRank() == toRank) && (tmp.numSend() == numsend);
			boolean match_tag = tmp.getTag() == tag;
			boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
			boolean any_tag = tag == Tag.MPI_ANYTAG;

			if((match_dst || any_src) && (match_tag || any_tag)) {
				return true;
			}
		}
		return false;
	}

	public NIORequest getRequestFromExpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend, IStatus status) {
		RecvBufferInformation tmp;
		int numElement = expectedQueue.size();
		for(int i = 0; i < numElement; i++) {
			tmp = expectedQueue.elementAt(i);
			boolean match_dst = (tmp.commID() == commID) && (tmp.fromRank() == fromRank) && 
				(tmp.toRank() == toRank) && (tmp.numSend() == numsend);
			boolean match_tag = tmp.getTag() == tag;
			boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
			boolean any_tag = tag == Tag.MPI_ANYTAG;

			if((match_dst || any_src) && (match_tag || any_tag)) {
				status.setStatus(tmp.fromRank(), tmp.getTag());
				expectedQueue.remove(i);
				return tmp.getRequest();
			}
		}
		return null;
	}

	public ByteBuffer getDataFromUnexpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend, IStatus status) {
		RecvBufferInformation tmp;
		int numElement = unexpectedQueue.size();
		for(int i = 0; i < numElement; i++) {
			tmp = unexpectedQueue.elementAt(i);
			boolean match_dst = (tmp.commID() == commID) && (tmp.fromRank() == fromRank) && 
				(tmp.toRank() == toRank) && (tmp.numSend() == numsend);
			boolean match_tag = tmp.getTag() == tag;
			boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
			boolean any_tag = tag == Tag.MPI_ANYTAG;

			if((match_dst || any_src) && (match_tag || any_tag)) {
				status.setStatus(tmp.fromRank(), tmp.getTag());
				unexpectedQueue.remove(i);

				return tmp.getData();
			}
		}
		return null;
	}


	/*
	public Object getDataFromBuffer(int fromRank, int toRank, int tag, IStatus status) {
		RecvBufferInformation tmp;
		synchronized(messageBuffer) {
			int numElement = messageBuffer.size();
			//System.out.println(myRank + ":There are " + numElement + " message in RecvBuffer");
			for(int i = 0; i < numElement; i++) {
				tmp = messageBuffer.elementAt(i);
				boolean match_dst = (tmp.fromRank() == fromRank) && (tmp.toRank() == toRank);
				boolean match_tag = tmp.getTag() == tag;
				boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
				boolean any_tag = tag == Tag.MPI_ANYTAG;

				if((match_dst || any_src) && (match_tag || any_tag)) {
					status.setStatus(tmp.fromRank(), tmp.getTag());
					return tmp.getData();
				}
			}
		}
		return null;
	}

	public void removeDataFromBuffer(int fromRank, int toRank, int tag) {
		RecvBufferInformation tmp;
		synchronized (messageBuffer) {
			int numElement = messageBuffer.size();
			for(int i = 0; i < numElement; i++) {
				tmp = messageBuffer.elementAt(i);

				boolean match_dst = (tmp.fromRank() == fromRank) && (tmp.toRank() == toRank);
				boolean match_tag = tmp.getTag() == tag ;
				boolean any_src   = fromRank == Tag.MPI_ANYSOURCE;
				boolean any_tag   = tag == Tag.MPI_ANYTAG ;

				if ((match_dst || any_src)  && (match_tag || any_tag))
				{
					messageBuffer.removeElementAt(i);
					return;
				}
			}
		}
	}
	*/


	public void cleanupProcess() {
		//Unregister FD Service
		Socket conn = null;
		OutputStream os = null;
		ObjectOutputStream oos = null;
		try {
			GossipMessage gossipMsg = new GossipMessage(MessageCmd.GOSSIP_UNREGISTER, myHash);
			int rankInList = getRankInList();
			gossipMsg.setMyRank(rankInList);
			conn = new Socket("127.0.0.1", fdPort);
			os = conn.getOutputStream();
			oos = new ObjectOutputStream(os);
			oos.writeObject(gossipMsg);
			oos.flush();
			oos.close();
			os.close();
			conn.close();
		} catch (Exception e) {
			System.out.println("Fault Detection Service is not running");
		}

		//Unregister to MPD
		try {
			AppUnregisterMessage unRegMsg = new AppUnregisterMessage(myHash, myRank);
			conn = new Socket("127.0.0.1", mpdPort);
			os = conn.getOutputStream();
			oos = new ObjectOutputStream(os);
			oos.writeObject(unRegMsg);
			oos.flush();
			oos.close();
			os.close();
			conn.close();
		} catch (Exception e) {
			System.out.println("MPD Service is not running");
		}

	}

	/*
	public String getMessageID(int commID, int src, int dest, int tag) {
		int iNumSent;
		String midKey = src + "_" + dest + "_" + tag;
		String strNumSent = midLog.getProperty(midKey);
		if(strNumSent == null) {
			iNumSent = 0;
			// Add my messageID to hashtable
			midLog.setProperty(midKey, "1");
			} else {
			iNumSent = Integer.parseInt(strNumSent);
// Remove messageID from hashtable
midLog.remove(midKey);
// Add new value from messageID to hastable;
midLog.setProperty(midKey, Integer.toString(iNumSent + 1));
			}
			return commID + "_" + midKey + "_" + iNumSent;
	}
	*/

	public String getMessageID(short commID, int src, int dst, int tag, int numsend) {
		try {
			return new String(commID + "_" + src + "_" + dst + "_" + tag + "_" + numsend);
		} catch(Exception e) {
			return null;
		}
	}


	public NIORequest sendToBackup(RankTable commTable, ByteBuffer data, Vector<Integer> dest,
			short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {

		String messageID = getMessageID(commID, src, dst, tag, numsend);
		//System.out.println("Send to backup MID = " + messageID);
		int logIndex;
		synchronized (sendLog) {
			if (sendLog.isExist(messageID)) {
				// master already done sending this message
				// just remove this messageID out of log
				sendLog.remove(messageID);
			} else {
				// master is not done sending this message yet
				// so backup this message in buffer in case master failed
				// this process can resend this message
				sendLog.add(messageID);
				SendBufferInformation backup = new SendBufferInformation(
						commTable,
						data,
						dest,
						commID,
						src,
						dst,
						tag,
						numsend,
						repRankInList
						);
				synchronized (backupBuffer) {
					backupBuffer.addElement(backup);
				}
			}
		}

		NIORequest req = new NIORequest();
		req.complete();
		req.fillStatus(src, tag, 0); //TODO : number length
		//System.out.println("[DONE] Send to backup MID = " + messageID);
		return req;
	}

	public String getHashKey(short commID, int fromRank, int toRank, int tag, int numsend) {
		return  commID + "_" + fromRank + "_" + toRank + "_" + tag + "_" + numsend;
	}


	public void registerMap(short commID, MapRankTable mapTable) {
		commMap.put(Short.toString(commID), mapTable);
	}

	public void registerCOMMWORLD(RankTable commWorld) {
		this.commWorld = commWorld;
	}

	public MapRankTable getMapRankTable(short commID) {
		return (MapRankTable)commMap.get(Short.toString(commID));
	}


}
