package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferShort extends P2PMPI_Buffer {
	public BufferShort(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		ShortBuffer sBuffer = myBuffer.asShortBuffer();
		sBuffer.put((short[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count*baseSize));

		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		int recvData;
		if(dataSize/baseSize < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;

		ShortBuffer sBuffer = data.asShortBuffer();
		sBuffer.get((short[])buffer, offset, recvData);
		data.position(data.position() + (recvData*baseSize));

		return (recvData - count) * baseSize;
	}
	public Object createArrayBuffer(int count) {
		return new short[count];
	}

}
