package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferLong extends P2PMPI_Buffer {
	public BufferLong(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		LongBuffer lBuffer = myBuffer.asLongBuffer();
		lBuffer.put((long[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count*baseSize));

		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		int recvData;
		if(dataSize/baseSize < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;

		LongBuffer lBuffer = data.asLongBuffer();
		lBuffer.get((long[])buffer, offset, recvData);
		data.position(data.position() + (recvData*baseSize));
		return (recvData - offset) * baseSize;
	}

        public Object createArrayBuffer(int count) {
	        return new long[count];
	}

}
