package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferInt extends P2PMPI_Buffer {
	public BufferInt(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		IntBuffer iBuffer = myBuffer.asIntBuffer();
		iBuffer.put((int[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count*baseSize));

		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		int recvData;
		if(dataSize/baseSize < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;

		IntBuffer iBuffer = data.asIntBuffer();
		iBuffer.get((int[])buffer, offset, recvData);
		data.position(data.position() + (recvData*baseSize));

		return (recvData - offset) * baseSize;
	}
     public Object createArrayBuffer(int count) {
	                     return new int[count];
			             }


}
