package p2pmpi.mpi;

import p2pmpi.mpi.dev.*;

/**
 * The handle of asynchronous communication
 */
public class Request {
	protected Device myDevice;
	protected Object recvBuffer;
	protected int offset;
	protected int count;
	protected Datatype datatype;
	protected int src;
	protected int tag;
	protected int dst;

	protected NIORequest myRequest;
	/**
	 * Internal use
	 */
	public Request(	Device myDevice, 
			Object recvBuffer,
			int offset, int count, Datatype datatype,
			int src, int tag, int dst)
	{
		this.myDevice 	= myDevice;
		this.recvBuffer	= recvBuffer;	
		this.offset	= offset;
		this.count	= count;
		this.datatype	= datatype;
		this.src	= src;
		this.tag	= tag;
		this.dst	= dst;
	}

	public Request() {
		myRequest = new NIORequest();
	}

	public Request(Object recvBuffer, int offset, int count, Datatype datatype, int src, int dst, int tag) {
		myRequest = new NIORequest(recvBuffer, offset, count, src, dst, tag, datatype.getBuffer());
	}

	public Request(NIORequest req) {
		myRequest = req;
	}

     /**
      * Blocks until all of the operations associated with the active requests in the array have completed.
      */
	public static Status[] Waitall(Request[] requests) {
	      int size = requests.length;
		Status[] status = new Status[size];
		for(int i = 0; i < size; i++) {
			status[i] = requests[i].Wait();
		}
		return status;
      }

	/**
	 * Blocks until a waiting asynchronous message is received
	 */
	public synchronized Status Wait() {
		IStatus istatus = myRequest.Wait();
		return new Status(istatus);
	}
	/**
	 * Test if message reception has completed.
       * Returns a status object if the operation identified by the request is complete, 
       * or a null reference otherwise. Java binding of the MPI operation MPI_TEST. 
       * After the call, if the operation is complete (ie, if the return value of test is non-null), 
       * the request object becomes an inactive request.
	 **/
	public Status Test() {
		IStatus istatus;
		if((istatus = myRequest.Test()) != null) {
			return new Status(istatus);
		} else {
			return null;
		}
       }
}
