package p2pmpi.mpi;


import p2pmpi.mpi.dev.*;
import p2pmpi.common.*;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Group class
 */
public class Group {
	Device myDevice;
	RankTable rankTable;
	MapRankTable mapRankTable;
	int myRank;
	int myRankInList;
	int groupSize;

	/*
	Vector<SendBufferInformation> backupMessage;
	MessageIDLog log;
	*/


	// Create by MPI_INIT (COMM_WORLD)
	/**
	 * Internal constructor 
	 *
	 * @param device        the communication device to use 
	 * @param rankTable	list of nodes
	 * @param myRank	MPI rank
	 * @param myRankInList	Rank in list
	 * @param groupSize	number of MPI ranks
	 */

	public Group(Device device, RankTable rankTable, 
			int myRank, int myRankInList, int groupSize,
			MapRankTable mapRankTable) 
	{
		this.myDevice	= device;
		this.rankTable  = rankTable;
		this.myRank     = myRank;
		this.myRankInList = myRankInList;
		this.groupSize  = groupSize;
		this.mapRankTable  = mapRankTable;
	}

	/**
	 * Internal use
	 */
	/*
	public Group(	MessageHandler msgHandle, RankTable rankTable, 
			int myRank, int myRankInList, int groupSize, boolean[] mask,
			Vector<SendBufferInformation> backupMessage, MessageIDLog log) 
	{
		this.msgHandle	= msgHandle;
		this.rankTable  = rankTable;
		this.myRank     = myRank;
		this.myRankInList  = myRankInList;
		this.groupSize  = groupSize;
		this.backupMessage = backupMessage;
		this.log	   = log;

		int numProcess	= __getNumPeers();
		maskVisible 	= new boolean[numProcess];
		for(int i = 0; i < numProcess; i++) {
			maskVisible[i] = mask[i];
		}
	}
	*/

	// Create by Group operation (Still need ?)
	/*
	public Group(Group groupOrigin) {
		this.msgHandle	  = groupOrigin.getMessageHandler();
		this.rankTable	  = groupOrigin.getCommTable();
		this.myRank       = groupOrigin.Rank();
		this.groupSize	  = groupOrigin.Size();

		boolean[] originMask = groupOrigin.getMaskVisible();
		int numProcess	= getNumPeers();
		maskVisible 	= new boolean[numProcess];
		for(int i = 0; i < numProcess; i++) {
			maskVisible[i] = originMask[i];
		}


		//int numPeers = groupOrigin.getNumPeers();
		//RankTable tmp = groupOrigin.getCommTable();
		//rankTable = new RankTable();
		//for(int i = 0; i < numPeers; i++) {
			//rankTable.addProcess(tmp.getRank(i), tmp.getHost(i), tmp.getPort(i));
		//}
	}
	*/


	////////////////////
	// Public call
	/////////////////////
	/**
	 * Returns rank of process in group
	 *
	 * @return process rank in group
	 */
	public int Rank() {
		return myRank;
	}

	/**
	 * Returns rank of process in list table (Internal used)
	 *
	 * @return process rank in rank table
	 */
	public int RankInList() {
		return myRankInList;
	}

	// Group size
	/**
	 * Returns size of group 
	 *
	 * @return group size
	 */
	public int Size() {
		return groupSize;
	}

	/**
	 * Internal use
	 */
	public int __sizetotal() {
		int size = 0;
		int numPeer = __getNumPeers();
		synchronized(mapRankTable)  {
			for(int i = 0; i < numPeer; i++) {
				if(rankTable.isAlive(mapRankTable.getCurrentRank(i))) 
					size++;
			}
		}
		return size;
	}

	// Create a new group which exclude some ranks from original group
	/**
	 * Create a new group which exclude some ranks from original group
	 *
	 * @param rank list of excluded rank
	 * @return a new group
	 */
	public Group Excl(int[] rank) {
		int newGroupSize = groupSize;
		int numPeers = __getNumPeers();
		MapRankTable newMapRankTable = new MapRankTable();

		int counter;
		boolean isExclude;
		int myNewRank = MPI.UNDEFINED;
		int myNewRankInList = MPI.UNDEFINED;
		int numElement = 0;
		for(int i = 0; i < numPeers; i++) {
			int r = mapRankTable.getCurrentRank(i);
			counter = 0;
			isExclude = false;
			for(int j = 0; j < rank.length; j++) {
				if(rank[j] < r) {
					//Counter for assigning a new rank
					counter++;
				} else if(rank[j] == r) {
					//This rank is excluded
					isExclude = true;
					break;
				}
			}
			if(!isExclude) {
				//Create new rank mapping but rank in list is still the same
				newMapRankTable.addMap(r-counter, mapRankTable.getWorldRank(i), mapRankTable.getRankInList(i));
				//Calcalate new rank and rankInList value
				if(i == myRankInList) {
					myNewRank = r-counter;
					myNewRankInList = numElement;
				}
				numElement++;
			} 
		}
		newGroupSize -= rank.length;
		Group newGroup = new Group(myDevice, rankTable, myNewRank, myNewRankInList,
					   newGroupSize, 
					   newMapRankTable);
		return newGroup;
	}

	/**
	 * Create a new group which include some ranks from original group
	 *
	 * @param rank list of included rank
	 * @return a new group
	 */
	public Group Incl(int[] rank) {
		int counter = 0;
		int listcounter = 0;
		//int numPeers = __getNumPeers();
		MapRankTable newMapRankTable = new MapRankTable();
		int myNewRank = MPI.UNDEFINED;
		int myNewRankInList = MPI.UNDEFINED;

		int numPeers = mapRankTable.size();
		boolean rankAdded;
		for(int i = 0; i < rank.length; i++) {
			rankAdded = false;
			for(int j = 0; j < numPeers; j++) {
				if(mapRankTable.getCurrentRank(j) == rank[i]) {
					newMapRankTable.addMap(counter, 
						mapRankTable.getWorldRank(j),
						mapRankTable.getRankInList(j));

					if(j == myRankInList) {
						myNewRank = counter;
						myNewRankInList = listcounter;
					}
					rankAdded = true;
					listcounter++;
				}
			}
			if(rankAdded) {
				counter++;
			}
		}
		int newGroupSize = counter;
		Group newGroup = new Group(myDevice, rankTable, myNewRank, myNewRankInList, 
					   newGroupSize, newMapRankTable);
		return newGroup;
	
	}
	/**
	 * Create a new group which include some ranks from original group
	 *
	 * @param group1 group1
	 * @param group2 group2
	 * @return MPI.IDENT, MPI.SIMILAR, MPI.UNEQUAL
	 */
	public static int Compare(Group group1, Group group2) 
	{
		MapRankTable rank1 = group1.__getMapCommTable();
		MapRankTable rank2 = group2.__getMapCommTable();

		if(rank1.size() != rank2.size()) {
			return MPI.UNEQUAL;
		}
	
		int numMap = rank1.size();	

		//Search if groups are identique
		boolean ident = true;
		for(int i = 0; i < numMap; i++) {
			if((rank1.getCurrentRank(i) != rank2.getCurrentRank(i)) ||
			   (rank1.getRankInList(i) != rank2.getRankInList(i))) {
			   	ident = false;
				break;	
			}
		}
		//Search if group are similar
		if(!ident) {
			//Assign rank in list
			boolean pass = false;
			for(int i = 0; i < numMap; i++) {
				for(int j = 0; j < numMap; j++) {
					if(rank1.getRankInList(i) == rank2.getRankInList(j)) {
						pass = true;
						break;
					}
				}
				if(!pass) {
					return MPI.UNEQUAL;
				}
			}
			return MPI.SIMILAR;
		}

		return MPI.IDENT;
	}

	/**
	 * Create a new group which is the union of 2 groups
	 *
	 * @param group1 group1
	 * @param group2 group2
	 * @return Union of 2 groups
	 */
	public static Group Union(Group group1, Group group2)
	{
		MapRankTable rank1 = group1.__getMapCommTable();
		MapRankTable rank2 = group2.__getMapCommTable();

		MapRankTable newMapRankTable = new MapRankTable();
		int newGroupSize = 0;

		//Add all ranks of group1
		int numMap1 = rank1.size();
		int numMember1 = group1.Size();

		for(int i = 0; i < numMap1; i++) {
			newMapRankTable.addMap(rank1.getCurrentRank(i), 
					       rank1.getWorldRank(i),
					       rank1.getRankInList(i));
		}
		int myNewRank = group1.Rank();
		int myNewRankInList = group1.RankInList();

		//Add all ranks of group2 that don't exist in group2
		int numMap2 = rank2.size();	
		int numMember2 = group2.Size();
		boolean alreadyAdded;	
		boolean rankAdded;
		int numAdded = 0;
		int counter = 0;

		for(int i = 0; i < numMember2; i++) { //loop for all ranks
			rankAdded = false;
			for(int j = 0; j < numMap2; j++) { //loop for all tables
				if(rank2.getCurrentRank(j) == i) { //operation by rank 0 to n-1
					alreadyAdded = false;
					for(int k = 0; k < numMap1; k++) {
						if(rank2.getRankInList(j) == rank1.getRankInList(k)) {
							//already add this process in a new group
							alreadyAdded = true;
							break;
						}
					}
					if(!alreadyAdded) {
						newMapRankTable.addMap(numAdded+numMember1, rank2.getWorldRank(j), rank2.getRankInList(j));
						if(j == group2.RankInList()) {
							myNewRank = numAdded+numMember1;
							myNewRankInList = numMap1 + counter;
						}
						counter++;
						rankAdded = true;
					}
				}
			}
			if(rankAdded) {
				numAdded++;
			}
		}	

		newGroupSize = numAdded + numMember1;
		Group newGroup = new Group(group1.__getDevice(), group1.__getRankTable(), 
					   myNewRank, myNewRankInList, newGroupSize, 
					   //group1.__getBackupMessage(), group1.__getLog(), 
					   newMapRankTable);
		return newGroup;
	}

	/**
	 * Create a new group which is the intersection of 2 groups
	 *
	 * @param group1 group1
	 * @param group2 group2
	 * @return Union of 2 groups
	 */
	public static Group Intersection(Group group1, Group group2)
	{
		MapRankTable newMapRankTable = new MapRankTable();
		MapRankTable rank1 = group1.__getMapCommTable();
		MapRankTable rank2 = group2.__getMapCommTable();

		int numMap1 = rank1.size();
		int numMap2 = rank2.size();

		int[] tmpRanks = new int[numMap1];
		int counter = 0;
		boolean rankDup;
		for(int i = 0; i < numMap1; i++) {
			for(int j = 0; j < numMap2; j++) {
				if(rank1.getRankInList(i) == rank2.getRankInList(j)) {
					//Check if it's exist in ranks
					rankDup = false;
					for(int k = 0; k < counter; k++) {
						if(tmpRanks[k] == rank1.getCurrentRank(i)) {
							rankDup = true;
							break;	
						}
					}
					if(!rankDup) {
						tmpRanks[counter] = rank1.getCurrentRank(i);
						counter++;
					}
					break;	
				}
			}
		}

		int[] ranks = new int[counter];
		for(int i = 0; i < counter; i++) {
			ranks[i] = tmpRanks[i];
		}

		return group1.Incl(ranks);
	}

	public static Group Difference(Group group1, Group group2)
	{
		MapRankTable newMapRankTable = new MapRankTable();
		MapRankTable rank1 = group1.__getMapCommTable();
		MapRankTable rank2 = group2.__getMapCommTable();

		int numMap1 = rank1.size();
		int numMap2 = rank2.size();

		int[] tmpRanks = new int[numMap1];
		int counter = 0;
		boolean rankDup;
		for(int i = 0; i < numMap1; i++) {
			for(int j = 0; j < numMap2; j++) {
				if(rank1.getRankInList(i) == rank2.getRankInList(j)) {
					//Check if it's exist in ranks
					rankDup = false;
					for(int k = 0; k < counter; k++) {
						if(tmpRanks[k] == rank1.getCurrentRank(i)) {
							rankDup = true;
							break;	
						}
					}
					if(!rankDup) {
						tmpRanks[counter] = rank1.getCurrentRank(i);
						counter++;
					}
					break;	
				}
			}
		}

		int[] ranks = new int[counter];
		for(int i = 0; i < counter; i++) {
			ranks[i] = tmpRanks[i];
		}

		return group1.Excl(ranks);
	}

	/**
	 * Translation of rank in group
	 * @param group1 first group
	 * @param ranks1 array of valid ranks in group1
	 * @param group2 second group
	 *
	 * @return array of corresponding ranks in group2
	 */
	/*
	static int[] Translate_ranks(Group group1, int[] ranks1, Group group2) 
	{
		MapRankTable rank1 = group1.__getMapCommTable();
		MapRankTable rank2 = group2.__getMapCommTable();

		int numMap1 = rank1.size();
		int numMap2 = rank2.size();

		for(int i = 0; i < ranks1.length; i++) {
			for(int j = 0; j < numMap1; j++) {
			}
		}	
	}*/
	
	//////////////////////////////////
	// Internal use
	//////////////////////////////////
	/**
	 * Internal use
	 */
	/*
	public Vector<SendBufferInformation> __getBackupMessage() {
		return backupMessage;
	}

	public MessageIDLog __getLog() {
		return log;
	}
	*/

	public Device __getDevice() {
		return myDevice;
	}

	public int __getNumPeers() {
		return mapRankTable.size();
	}

	public RankTable __getCommTable() {
		return rankTable;
	}

	public MapRankTable __getMapCommTable() {
		return mapRankTable;
	}

	public RankTable __getRankTable() {
		return rankTable;
	}

}
