/**
 * @author choopan
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */


package p2pmpi.mpd;

import p2pmpi.common.*;
import p2pmpi.common.ProcessTable;
import p2pmpi.common.ProcessInfo;
import p2pmpi.message.*;
import p2pmpi.message.StatQueryMessage;

import java.net.*;
import java.util.*;
import java.io.*;
import p2pmpi.p2p.*;
import p2pmpi.p2p.message.*;

import org.apache.log4j.*;


public class P2PMPI_MPD extends P2PMPI_MPDPeer {
	  int jxtaMinPort;
	  int jxtaMaxPort;
	  int jxtaCurrentPort;

	  int numCPU;

	  Properties confProps;

	  long startBOOT, stopBOOT;
	  protected ProcessTable procTab = null;
	  URI superNode;
	  URI myURI;

	  /**
	   * return an array of strings from a string
	   *
	   * @param s string of coma separated IP or networks 
	   * @return an array of the valid IP or networks	
	   **/
	  /*
	     private String [] parseHostDenyList( String s ) {

	     if (s==null)
	     return (null);
	     else {
	     String [] atoms = s.split(",");
	     String [] ipArray = new String [atoms.length];
	     int idx=0;
	     URI tmp;
	     log.info("Deny List specified in config. file:" + s);
	     for (int i=0;i<atoms.length;i++) {
	     try {
	     String atom = atoms[i].trim();
	     tmp = new URI(atom);  // in fact, this does not make a strict check of a valid IP
	     ipArray[idx] = new String( atom );
	     log.info("- Requests from "+ipArray[idx]+" will be ignored."); 
	     idx++;
	     } catch (URISyntaxException e) {
	     log.info(" [Error] " + atoms[i] + " is not a valid URI in configuration file.");
	     }
	     }
	     log.info("Deny List parsed: " + ipArray.length + " hosts or networks.");
	     return (ipArray);
	     }
	     }
	   */

	  // Constructor of P2P_MPD
	  public P2PMPI_MPD(int mpdPort, int fdPort, int ftPort, int jxtaMinPort, 
				int jxtaMaxPort, String tmpDir, Properties confProps,
				String hostDenyList, String hostAllow,
				int numProcPerJob , int rsPort, int numCPU, URI superNode,
				String peerCacheFile) {

		    startBOOT		= System.currentTimeMillis();
		    log = Logger.getLogger("MPD");
		    this.mpdPort    	= mpdPort;
		    this.fdPort		= fdPort;
		    this.ftPort		= ftPort;
		    this.rsPort         = rsPort;
		    this.runPath 	= new File(tmpDir, getUniqueDirName());
		    this.jxtaMinPort	= jxtaMinPort;
		    this.jxtaMaxPort	= jxtaMaxPort;
		    this.confProps	= confProps;
		    this.numCPU		= numCPU;
		    this.superNode	= superNode;

		    log.info("[MPD] ** Starting MPD "+ Version.MAINVERSION + "." + Version.SUBVERSION + " **");
		    // set peer cache file as specified in config., default otherwise.
		    if ( peerCacheFile != null )
				this.peerCacheFile = peerCacheFile;
		    else
				this.peerCacheFile = new String(this.tmpDir + System.getProperty("path.separator") + "cache.xml");

		    // set our IP, but mind NAT configurations. In that case, use 'externalIP' specified in conf.
		    NetIface extIf = new NetIface();
		    this.usingIP = extIf.getExternalIfIpv4( );
		    if (usingIP == null ) {
				log.error("Could not determine a working network interface. Exiting."); 
				System.exit(1); 
		    }
		    log.info("[MPD] Network status: using "+extIf.getIfName( )+" ip="+ this.usingIP);
		    try {
				myURI = new URI("tcp://" + usingIP + ":" + mpdPort);
		    } catch(Exception e) {}
		    this.numProcPerJob	= numProcPerJob;

		    jxtaCurrentPort = jxtaMinPort;
		    this.tmpDir     = new String(tmpDir);
		    procTab = new ProcessTable();
		    myHost = new HostEntry(usingIP, mpdPort, fdPort, ftPort, rsPort, numProcPerJob);

		    createCacheEntry( this.usingIP );
	  }

	  /**
	   * initialize the PeerCache system. Renew our own Peer entry at each startup.
	   * @param myIp a String serving as id for cache entry.
	   * @author genaud
	   *
	   * This is a complete rewrite of createMPDAdv() created by GHaZI, which originally used JXTA Advertisments. 
	   */
	  protected void createCacheEntry( String myIP ) {

		    PeerCache cache = new PeerCache( this.peerCacheFile ); 

		    // first remove my entry from the cache. Let us regenerate
		    String id = new String( myIP + ":" + this.mpdPort );
		    cache.remove( id );

		    cache.setMpdVer ( id, Version.MAINVERSION + "." + Version.SUBVERSION ); 
		    cache.setOsName ( id, System.getProperty("os.name") );
		    cache.setArch   ( id, System.getProperty("os.arch") );
		    cache.setMpdPort( id, Integer.toString( this.mpdPort ) );
		    cache.setFdPort ( id, Integer.toString( this.fdPort ) );
		    cache.setFtPort ( id, Integer.toString( this.ftPort ) );

		    // Put in the add as much system information as we can
		    String cpuinfo [] = OsInfo.cpuInfo();
		    String meminfo [] = OsInfo.memInfo();
		    if (cpuinfo == null) {
				cache.setCpuName( id, "N/A" );
				cache.setCpuFreq( id, "N/A" );
		    }
		    else {
				cache.setCpuName( id, cpuinfo[0] );
				cache.setCpuFreq( id, cpuinfo[1] );
		    }
		    if (meminfo == null)
				cache.setMem( id, "N/A");
		    else
				cache.setMem( id, meminfo[0] );

		    if ( cache.saveDocument( this.peerCacheFile ) ) {
		    		log.info("[MPD] Entry created in cache " + this.peerCacheFile + " with id=" + id );
		    }
		    else {
		    		log.info("[MPD] Cache entry not created. Reason: "+ cache.getErrorStatus());
		    }
	  }


	  // Return a unique name used as a temp dir
	  protected synchronized String getUniqueDirName() {
		    return new String(NameGenerator.getUniqueName());
	  }

	  // Return available jxtaport
	  protected synchronized int getJxtaPort() {
		  ServerSocket s = null;
		  int i, numtry;
		  for(numtry = 0; numtry < 2; numtry++) {
			  for(i = jxtaCurrentPort; i <= jxtaMaxPort; i++) {
				  try {
					  s = new ServerSocket(i);
					  s.close();
					  jxtaCurrentPort = i+1;
					  return i;
				  } catch (Exception e) {
					  continue;
				  }
			  }
			  jxtaCurrentPort = jxtaMinPort;
		  }
		  return -1;      // No port available
	  }


	  protected synchronized void requestPeer(String IP, int mpdPort, MPDMessage msg) {
		    OutputStream os;
		    ObjectOutputStream oos;
		    try {
				Socket s = new Socket(IP, mpdPort);
				log.info("Assign Rank " + msg.getRank() + ": to IP:" + IP);
				os = s.getOutputStream();
				oos = new ObjectOutputStream(os);
				oos.writeObject(msg);
				oos.flush();
				oos.close();
				os.close();
				s.close();
		    } catch (Exception e) {
				log.info("Reqpeer: Fail " + e.toString());
		    }
	  }

	  /**
	   * Cancel a reservation previously posed on some remote Peers through RS servers
	   * @author choopan
	   **/
	  protected void cancelReservation(String hashID, Vector<HostEntry> list) {
		    if(list.size() == 0) 
				return;
		    try {
				RSMessage rsMsg = new RSMessage(RSMessage.MPD_CANCEL_RESERVATION_TO_RS, hashID, usingIP,
						 Version.MAINVERSION + "." + Version.SUBVERSION);
				rsMsg.setList(list);

				Socket socket = new Socket("127.0.0.1", rsPort);
				OutputStream out = socket.getOutputStream();
				ObjectOutputStream oos = new ObjectOutputStream(out);
				oos.writeObject(rsMsg);
				oos.flush();
				oos.close();
				out.close();
				socket.close();
		    } catch(Exception e) {
				log.info("[MPD] Error: could not contact RS to cancel reservation "+ hashID);
		    }
	  }

	  protected boolean isMyHost(HostEntry host) {
		    return host.getIp().equals(myHost.getIp());
	  }

	  protected ReservationResult searchMPD(String hashID, int optionN, int optionR, 
			  			int maxWaitTime, String allocationMode)  {
		    //allocationMode -> spread: distribute process on as many machines as possible (default)
		    //                  gather : use less machines but maximum provide slots
		    ReservationResult rsResult;

		    //get number of reservation 
		    int maxRequire = optionN * optionR;	//remove rank 0
		    int minRequire = optionR;
		    int numReserve = maxRequire + (int)(3 * (Math.log(maxRequire)/Math.log(2)));
		    Vector<HostEntry> v = new Vector<HostEntry>();
		    int counter;

		    log.info( "[MPD] entering searchMPD (n="+optionN+",r="+optionR+")");
		    long  startTime = System.currentTimeMillis();
		    //Sort HostCache by RTT
		    while(true) {
			    ArrayList as = new ArrayList(hostCache.entrySet());
			    Collections.sort(as, new Comparator() {
				    public int compare(Object o1, Object o2) {
					    Map.Entry e1 = (Map.Entry)o1;
					    Map.Entry e2 = (Map.Entry)o2;
					    int first  = ((HostEntry)e1.getValue()).getRtt();
					    int second = ((HostEntry)e2.getValue()).getRtt();
					    return first - second;
				    }
			    });

			    //form a message to RS
			    counter = 0;
			    Iterator iter = as.iterator();
			    while(iter.hasNext()) {
				    HostEntry host = (HostEntry)((Map.Entry)iter.next()).getValue();
				    if(host.isAlive()) {
					    v.add(host);
					    counter++;
					    if(counter >= numReserve)
						    break;
				    }
			    }	

			    if(counter < maxRequire) {
				    //If the present peer is not enough, try to discovery for more
				    int deadlineTime = (int)(System.currentTimeMillis() - startTime);
				    if(deadlineTime < (maxWaitTime*1000)) {
					    v.clear();
					    updateHostCache(superNode);
				    } else {
					    break;
				    }
			    } else {
				    break;
			    }
			    try {
				    Thread.sleep(1000);
			    } catch(Exception e) {}
		    }
		    log.info("[MPD] number of hosts required: min=" + minRequire + ",max=" + maxRequire + ",found =" + counter);

		    //////////////////////////////////////////////////////////////
		    //Constraint : number of nodes is less than minimum required
		    //////////////////////////////////////////////////////////////
		    if(counter < minRequire - 1) {
			    rsResult = new ReservationResult(null, ReservationResult.NOT_ENOUGH_NODE, counter+1, 0);
			    rsResult.setMyHost(myHost);
			    return rsResult;
		    }

		    RSMessage rsMsg = new RSMessage(RSMessage.MPD_REQUEST_RESERVATION_TO_RS, hashID, usingIP, Version.MAINVERSION + "." + Version.SUBVERSION);
		    rsMsg.setReservePeriod(30000 + (optionN*optionR*1000)); //30s + 1s per node
		    rsMsg.setList(v);
		    Vector<HostEntry> reservedList = null;
		    Vector<HostEntry> deadList = null;

		    //Send message to RS to reserve node
		    try {
			    Socket socket = new Socket("127.0.0.1", rsPort);
			    InputStream in = socket.getInputStream();
			    OutputStream out = socket.getOutputStream();
			    ObjectOutputStream oos = new ObjectOutputStream(out);
			    oos.writeObject(rsMsg);
			    oos.flush();

			    ObjectInputStream ois = new ObjectInputStream(in);
			    Object oMsg = ois.readObject();
			    RSMessage replyMsg = (RSMessage)oMsg;

			    reservedList = replyMsg.getList();
			    deadList     = replyMsg.getDeadList();

			    ois.close();
			    oos.close();
			    in.close();
			    out.close();
			    socket.close();
		    } catch(Exception e) {
			    log.error("[MPD] Error connecting to local RS (127.0.0.1:"+rsPort+") : " + e.toString());
			    //RS dead.. must do something
		    }

		    //Update status of dead node
		    int deadNodeSize = deadList.size();
		    String dhl="";
		    for(int i = 0; i < deadNodeSize; i++) {
			    HostEntry host = deadList.elementAt(i);
			    String key = host.toString();
			    dhl += host.getIp() + " ";
			    (hostCache.get(key)).setAlive(false);
		    }
		    log.info("[MPD] result from RS reservation request: "+ reservedList.size() +
				    " reserved hosts , "+ deadList.size() +" unreachable RS.");
		    for(int i = 0; i < reservedList.size(); i++) {
			    HostEntry host = reservedList.elementAt(i);
			    log.info("[MPD] reserved : " + host.getIp());
		    }

		    if (deadList.size() > 0) 
			    log.info("[MPD] unreachable RS: " + dhl);

		    int reservedSize = reservedList.size();
		    boolean addLocalHost = false;

		    //If number of found node is not sufficient 
		    //to execute 1 process per node, we add rank 0 node to list
		    //if(reservedSize < maxRequire) {
		    //Add local host into reservedList
		    reservedList.add(0, myHost);
		    reservedSize++; 
		    addLocalHost = true;
		    //}


		    //Check if we can reserve more than minimum require
		    log.debug("[MPD] Total of " + reservedSize + " reserved nodes");
		    //////////////////////////////////////////////////////////////
		    //Constraint : number of nodes is less than minimum required
		    //////////////////////////////////////////////////////////////
		    if(reservedSize < minRequire) {
			    //Cancel the reservation
			    reservedList.remove(0);
			    cancelReservation(hashID, reservedList);
			    rsResult = new ReservationResult(null, ReservationResult.NOT_ENOUGH_NODE, reservedSize, 0);
			    rsResult.setMyHost(myHost);
			    return rsResult;
		    }


		    //Check if summation of available slot is more than max require (new term : capacity)
		    int processAvailable = 0;
		    for(int i = 0; i < reservedSize; i++) {
			    HostEntry host = reservedList.elementAt(i);
			    int numProcProvide = host.getNumProcPerJob();
			    if(isMyHost(host)) {
				    //myHost already consume 1 slot because of rank 0
				    numProcProvide--;
			    }
			    if(numProcProvide > optionN) {
				    processAvailable += optionN;
			    } else {
				    processAvailable += numProcProvide;
			    }
		    }
		    if(processAvailable < maxRequire) {
			    //Cancel Previous Reservation
			    reservedList.remove(0);
			    cancelReservation(hashID, reservedList);
			    rsResult = new ReservationResult(null, ReservationResult.NOT_ENOUGH_SLOT, reservedSize, processAvailable);
			    rsResult.setMyHost(myHost);
			    return rsResult;
		    }



		    /////////////////////////////////////////////////////////
		    // Calculate process on each machine
		    // pick allocation policy mode :
		    // Scatter or Gather
		    /////////////////////////////////////////////////////////

		    if(addLocalHost) {
			    maxRequire++;
			    optionN++;
		    }

		    if(allocationMode.equalsIgnoreCase("spread")) {
			    ///////////////////////////////////////////////
			    // Scatter mode
			    ///////////////////////////////////////////////
			    Vector<ReservedHost> usedHost = new Vector<ReservedHost>();
			    Vector<HostEntry> cancelList = new Vector<HostEntry>();
			    ReservedHost rh;

			    int used = 0;
			    int staticReservedSize = reservedSize;
			    int reserveSlot;
			    int numProcPerJob;

			    int[] reservedSlotTable = new int[reservedSize];

			    boolean fillRankDone = false;
			    while(true) {
				    for(int i = 0; i < staticReservedSize; i++) {
					    HostEntry host = reservedList.elementAt(i);
					    if(used >= maxRequire){
						    fillRankDone = true;
						    break;
					    } else {
						    numProcPerJob = host.getNumProcPerJob();
						    if((reservedSlotTable[i] < numProcPerJob) &&
						       (reservedSlotTable[i] < optionN)) {
							    used++;
							    reservedSlotTable[i]++;
						    }
					    }
				    }
				    if(fillRankDone)
					    break;
			    }

			    for(int i = 0; i < staticReservedSize; i++) {
				    HostEntry host = reservedList.elementAt(i);
				    if(reservedSlotTable[i] == 0) {
					    cancelList.add(host);
					    log.info("[Scatter]->" + host.getIp() + " (not used)");
				    } else {
					    log.info("[Scatter]->" + host.getIp());
					    rh = new ReservedHost(host, reservedSlotTable[i]);
					    usedHost.add(rh);
				    }
			    }
			    //Cancel the rest of node that we don't use
			    cancelReservation(hashID, cancelList);
			    int usedHostSize = usedHost.size();
			    log.info("usedHostSize = " + usedHostSize);
			    if(!addLocalHost)
				    usedHostSize++;
			    rsResult = new ReservationResult(usedHost, ReservationResult.SUCCESS, usedHostSize, 0);
			    rsResult.setMyHost(myHost);
			    return rsResult;	


		    } else {
			    /////////////////////////////////////////////////////////////////////
			    // Concentrate Mode
			    /////////////////////////////////////////////////////////////////////
			    //comment here : change to sort by RTT instead of MAX_PROCESS_PER_JOB
			    Vector<ReservedHost> usedHost = new Vector<ReservedHost>();
			    Vector<HostEntry> cancelList = new Vector<HostEntry>();
			    ReservedHost rh;

			    int used = 0;
			    int staticReservedSize = reservedSize;
			    int reserveSlot;
			    int numProcPerJob;

			    //Assign to machine that execute rank 0 first
			    numProcPerJob = myHost.getNumProcPerJob();
			    if(numProcPerJob < optionN) {
				    if(numProcPerJob > maxRequire) {
					    reserveSlot = maxRequire;
				    } else {
					    reserveSlot = numProcPerJob;
				    }
			    } else {
				    reserveSlot = optionN;
			    }
			    rh = new ReservedHost(myHost, reserveSlot);
			    usedHost.add(rh);
			    used += reserveSlot;

			    //Assign to the rest of machines
			    for(int i = 0; i < staticReservedSize; i++) {
				    HostEntry host = reservedList.elementAt(i);
				    log.info("[Gather]->" + host.getIp());

				    if(isMyHost(host)) {
					    continue;
				    }
				    if(used >= maxRequire) {
					    cancelList.add(host);
				    } else {
					    numProcPerJob = host.getNumProcPerJob();
					    if(numProcPerJob < optionN) {
						    if(used + numProcPerJob > maxRequire) {
							    reserveSlot = maxRequire - used;
						    } else {
							    reserveSlot = numProcPerJob;
						    }
					    } else {
						    if(used + optionN  > maxRequire) {
							    reserveSlot = maxRequire - used;
						    } else {
							    reserveSlot = optionN;
						    }
					    }
					    rh = new ReservedHost(host, reserveSlot);
					    usedHost.add(rh);
					    used += reserveSlot;
				    }
			    }	

			    //Cancel the rest of node that we don't use
			    cancelReservation(hashID, cancelList);
			    int usedHostSize = usedHost.size();
			    if(!addLocalHost)
				    usedHostSize++;
			    rsResult = new ReservationResult(usedHost, ReservationResult.SUCCESS, usedHostSize, 0);
			    rsResult.setMyHost(myHost);
			    return rsResult;	
		    }
	  }


	  public void run() {
		    if(!joinMpiGroup(superNode)) {
				System.err.println("** [MPD Error] : could not contact SuperNode at " +superNode.toString() + ". Exiting." );
				log.info("[MPD Error]: could not contact SuperNode at " +superNode.toString() + ". Exiting." );
				System.exit(1);
		    }
		    MPD_Interface myInterface = new MPD_Interface(this);
		    myInterface.start();

		    updateHostCache(superNode);

		    Timer peerKeepAlive =  new Timer();
		    peerKeepAlive.schedule(new PeerKeepAlive(superNode,myHost), 0, 180000);
		    Timer peerUpdateList =  new Timer();
		    peerUpdateList.schedule(new PeerUpdateList(superNode,myHost,hostCache), 0, 300000);

	  }

	  public static void main(String[] args) {

		    File tempDir = new File(System.getProperty("P2PMPI_HOME"), "tmp");

		    P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( log );
		    P2PMPI_MPD mpiDaemon = new P2PMPI_MPD(
					  ppConf.getMPDPort(),  //MPD Port number
					  ppConf.getFDPort(),
					  ppConf.getFTPort(),
					  ppConf.getMinPort(),        // Jxta MinPort number
					  ppConf.getMaxPort(),        // Jxta MaxPort number
					  tempDir.toString(),
					  ppConf.getProperties(),
					  ppConf.getHostDeny(),
					  ppConf.getHostAllow(),
					  ppConf.getNumProcPerJob(),
					  ppConf.getRSPort(),
					  ppConf.getNumCPU(),
					  ppConf.getSuperNode(),
					  ppConf.getPeerCacheFile()
					  );

		    mpiDaemon.start();
	  }
}
