package p2pmpi.ft;

import java.awt.*;
import java.io.*;
import java.net.*;

//---- for MD5sum
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.math.BigInteger;


/**
   * @author genaud
   *
   * This class aims to implement 'wget'-like functionnalities.   
   *
   * Warning : the setContent() method will fill a buffer in memory of 
   * the entire data file downloaded. Future work will deal with partial
   * loading. 
   *
   * Usage : see main() method for a test-case.
*/
public class RemoteData {


     private URL url;
     private byte [] data = null;
     private String mimeType=null;
     
     
     RemoteData (String address) 
      throws MalformedURLException, IOException
     {
		url = new URL(address);
     }
     		 
    /**
	* Lookup the mimetype returned for the given URL and store it.
	*
	* @param address URL where to find data.
	**/
    public void setMimeType(String address) 
       throws MalformedURLException, IOException 
    {
	  URLConnection conn =  url.openConnection();
        mimeType =  conn.getContentType();
    }
    /**
	* Get the mimetype of the file pointed by address, or null
	* if setMimeType has not been called yet.
	*
	* @param address URL where to find data.
	**/
    public String getMimeType() {
	     return (mimeType);
    }	     

    /**
	* Fetch the contents of a URL and stores it as a bytes array
      *	
      * @param address the URL to fetch data from.
	* @return true if contents has been set, false if failed because length is not known.
	**/
    public boolean  setContent() 
       throws MalformedURLException, IOException 
    {
	  URLConnection conn =  url.openConnection();
	  int len = conn.getContentLength();
	  boolean documentSet;

	  System.err.println(len);
	  if (len >=0 ) {
	  	data = new byte [len];
	  	InputStream input = conn.getInputStream();
	  	input.read ( data , 0 , len );
		documentSet = true;
	  }
	  else { // webserver does not return document length 
		documentSet = false;
	  }
	  return ( documentSet );
	}
    
    /**
	* Get the data fetched or null if setContent() has not been called yet. 
	**/
    public byte []  getContent() {
		return ( data );
    }
    
    /**
	* Get the contents of a URL and writes it as a file.
	*
	* @param address the URL to fetch data from.
	**/
    public void writeToFile(String filename) {
   
        //File fh = new File(leadingPath + (url.getFile()).basename());
        File fh = new File( filename );
        try {
	      FileOutputStream outfile = new FileOutputStream(fh);
		outfile.write( this.data);
		outfile.flush();
		outfile.close();
	  } catch (Exception e) {
		e.printStackTrace();
	  }
    }

	/**
	  * Return a hash (md5sum) of the file contents stored in memory 
	  * in the "data" variable, or null if "data" is empty.
	  *
	  **/
	public String getMD5Sum () {
		if (data == null)
			  return (null);

		MessageDigest md=null;
		try {
			md = MessageDigest.getInstance( "MD5" );
			md.update( data );
		} catch (java.security.NoSuchAlgorithmException e)
		{
			  System.err.println("** [Error] MD5sum is not implemented by the JVM.");
		}
		BigInteger  md5sum  = new BigInteger( 1 , md.digest()); 
		return (md5sum.toString(16));
	}


    // Test out the class.
    public static void main(String[] args) 
        throws MalformedURLException, IOException 
    {
	  // set URL of remote data
        RemoteData myinput = new RemoteData(args[0]);
	  // setContent() is the real trigger for the data copy
	  if (myinput.setContent()) {
		// we can call getContent() when we want the piece of data
		// or call directly writeToFile() which call getcontent()
	  	myinput.writeToFile("./fetched_data");
	  }
	  else {
		System.err.println("** [Error] could not fetch contents hosted at "+args[0]);
	  }
    }
}
