package p2pmpi.common;

import java.io.*;
import java.util.*;

public class ProcessTable {
	private Hashtable<String, ProcessInfo> procTable;

	public ProcessTable() {
		procTable = new Hashtable<String, ProcessInfo>();
	}

	public void addProcess(ProcessInfo procInfo) {
		procTable.put(procInfo.getID(), procInfo);
	}

	public void removeProcess(String id) {
		procTable.remove(id);
	}

	public ProcessInfo getInfo(String id) {
		return procTable.get(id);
	}

	public String getRunDir(String id) {
		return ((procTable.get(id))).getRunDir();
	}
	public int getRank(String id) {
		return ((procTable.get(id))).getRank();
	}

	public Enumeration elements() {
		return procTable.elements();
	}
	public int size() {
		return procTable.size();
	}
}
