package p2pmpi.common;
import java.net.*;
import java.io.*;
import org.apache.log4j.*;

public class P2PMPI_ConfigFile extends GenericConfigFile {
	  //static String nameServicePort = "NAMESERVICE_PORT";
	  static String numCPU		= "NUM_CPU";
	  static String mpdPort           = "MPD_PORT";
	  static String ftPort            = "FT_PORT";
	  static String fdPort            = "FD_PORT";
	  static String jxtaMinPort       = "MIN_PORT";
	  static String jxtaMaxPort       = "MAX_PORT";
	  static String tmpDir            = "TMP_DIR";
	  static String externalIP        = "EXTERNAL_IP";
	  //static String rdvPort           = "RDV_PORT";
	  static String hostDeny          = "HOST_DENY";
	  static String hostAllow         = "HOST_ALLOW";
	  static String t_gossip		= "T_GOSSIP";
	  static String t_margin		= "T_MAX_STARTUP";
	  static String gossipProtocol    = "GOSSIP_PROTOCOL";
	  static String t_hang		= "T_MAX_HANG";
	  static String numProcPerJob	= "MAX_PROCESSES_PER_JOB";
	  static String maxJob		= "MAX_JOBS";
	  static String rsPort		= "RS_PORT";
	  static String peerCache	= "PEER_CACHE";
	  static int t_gossip_default	= 500;
	  static int t_hang_default	= 0;
	  static String supernode	= "SUPERNODE";
	  static String visuproxy	= "VISU_PROXY";
	  Logger logger = null;

	  /**
	   * Constructor 1 : filename must be specified 
	   **/
	  public P2PMPI_ConfigFile(String fileName) {
		    super(fileName);
	  }

	  /**
	   * Constructor 2 : filename must be specified, and a logger is assigned for traces 
	   **/
	  public P2PMPI_ConfigFile(String fileName, Logger logger) {
		    super(fileName);
		    this.logger = logger;
	  }
	  /**
	   * Constructor 3 : tries to find conf file in a specific dir, then in $P2PMPI_HOME.
	   **/
	  public P2PMPI_ConfigFile() {
		    super( );
		    // give an absolute pathname for configuration file
		    String conffilename = System.getProperty("P2PMPI_CONF_FILE");
		    String envPath = System.getProperty("P2PMPI_HOME");
		    if(envPath == null || envPath.equals("")) {
				System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
				System.exit(1);
		    }
		    File configFile=null;
		    if (conffilename==null || conffilename.equals("")) {
				conffilename = "P2P-MPI.conf";
				configFile = new File( envPath, conffilename );
		    }
		    else {
				configFile = new File( conffilename );
		    }
		    try {
				if ( configFile.isFile( )) {
					  super.setFileName( configFile.toString() );
				}
				else {
					  System.err.println( "[Error] cannot access configuration file:"+conffilename+". Exiting.");
					  System.exit(1);
				}

		    } 
		    catch (Exception e) { } 
	  }
	  /**
	   * Constructor 4 : tries to find conf file in a specific dir, then in $P2PMPI_HOME and initializes a logger.
	   **/
	  public P2PMPI_ConfigFile( Logger logger ) {
		    super( );
		    this.logger = logger;
		    // give an absolute pathname for configuration file
		    String conffilename = System.getProperty("P2PMPI_CONF_FILE");
		    String envPath = System.getProperty("P2PMPI_HOME");
		    if(envPath == null || envPath.equals("")) {
				System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
				System.exit(1);
		    }
		    File configFile=null;
		    if (conffilename==null || conffilename.equals("")) {
				conffilename = "P2P-MPI.conf";
				configFile = new File( envPath, conffilename );
		    }
		    else {
				configFile = new File( conffilename );
		    }
		    try {
				if ( configFile.isFile( )) {
					  super.setFileName( configFile.toString() );
				}
				else {
					  System.err.println( "[Error] cannot access configuration file:"+conffilename+". Exiting.");
					  System.exit(1);
				}

		    } 
		    catch (Exception e) { } 
	  }


	  public URI getSuperNode() {
		    try {
				return new URI(getProperty(supernode));
		    } catch(Exception e) {
				return null;
		    }
	  }
	  public URI getVisuProxy() {
		    try {
				return new URI(getProperty(visuproxy));
		    } catch(Exception e) {
				return null;
		    }
	  }

	  public String getGossipProtocol(){
		    String protocol = getProperty(gossipProtocol);
		    if(protocol == null) {
				return "DBRR";
		    }
		    if(!protocol.equalsIgnoreCase("DBRR") && 
					  !protocol.equalsIgnoreCase("BRR")) {
				return "DBRR";
		    }
		    return protocol;
	  }

	  public int getNumCPU() {
		    int nCPU;
		    try {
				nCPU = Integer.parseInt(getProperty(numCPU));
		    } catch (Exception e) {
				return 1;
		    }
		    if(nCPU <= 1) 
				return 1;
		    else
				return nCPU;
	  }
	  public int getTGossip() {
		    try {
				int t = Integer.parseInt(getProperty(t_gossip));
				if(t < t_gossip_default)
					  return t_gossip_default;
				else
					  return Integer.parseInt(getProperty(t_gossip));
		    } catch (Exception e) {
				return t_gossip_default;
		    }
	  }

	  /*
	     public int getTMargin() {
	     try {
	     int t = Integer.parseInt(getProperty(t_margin));
	     if ( t < 120000) 
	     return 120000;
	     else 
	     return Integer.parseInt(getProperty(t_margin));
	     } catch (Exception e) {
	     return 120000;
	     }
	     }
	   */

	  public int getTHang() {
		    try {
				return Integer.parseInt(getProperty(t_hang));
		    } catch (Exception e) {
				return t_hang_default;
		    }
	  }

	  public int getFTPort() {
		    return Integer.parseInt(getProperty(ftPort));
	  }

	  public int getFDPort() {
		    return Integer.parseInt(getProperty(fdPort));
	  }

	  public int getMPDPort() {
		    return Integer.parseInt(getProperty(mpdPort));
	  }

	  public int getMinPort() {
		    return Integer.parseInt(getProperty(jxtaMinPort));
	  }

	  public int getMaxPort() {
		    return Integer.parseInt(getProperty(jxtaMaxPort));
	  }

	  public int getMaxJob() {
		    return Integer.parseInt(getProperty(maxJob, logger));
	  }

	  public int getNumProcPerJob() {
		    String nppj =  getProperty( numProcPerJob, logger );
		    if ( nppj == null )
			return( 1 );
		    else
			return Integer.parseInt( nppj );
	  }

	  public String getTempDirectory() {
		    return getProperty(tmpDir);
	  }

	  public String getExternalIP() {
		    return getProperty(externalIP);
	  }

	  public String getHostDeny() {
		    return getProperty(hostDeny);
	  }

	  public String getHostAllow() {
		    return getProperty(hostAllow);
	  }

	  public int getRSPort() {
		    return Integer.parseInt(getProperty(rsPort));
	  }
	  
	  public String getPeerCacheFile() {
		    return getProperty( peerCache );
	  }
}
