package p2pmpi.common;

import java.io.*;
import java.net.*;
import java.util.*;

public class MapRankTable implements Serializable {
	private static final long serialVersionUID = 1000000L;
	Vector<MapTableInfo> mapTable;

	public MapRankTable() {
		mapTable = new Vector<MapTableInfo>();
	}

	public void addMap(int currentRank, int worldRank, int rankInList) {
		MapTableInfo tableInfo = new MapTableInfo(currentRank, worldRank, rankInList);
		mapTable.addElement(tableInfo);
	}

	public int size() {
		return mapTable.size();
	}

	public int getCurrentRank(int index) {
		MapTableInfo tmp = mapTable.elementAt(index);
		return tmp.getCurrentRank();
	}

	public int getWorldRank(int index) {
		MapTableInfo tmp = mapTable.elementAt(index);
		return tmp.getWorldRank();
	}

	public int getRankInList(int index) {
		MapTableInfo tmp = mapTable.elementAt(index);
		return tmp.getRankInList();
	}

	public Vector<Integer> getRankInListByWorldRank(int worldRank) {
		Vector<Integer> result = new Vector<Integer>();
		MapTableInfo tmp;
		int size = size();

		for(int i = 0; i < size; i++) {
			tmp = mapTable.elementAt(i);
			if(tmp.getWorldRank() == worldRank) {
				Integer element = new Integer(tmp.getRankInList());
				result.addElement(element);
			}
		}

		return result;
	}


	public Vector<Integer> getRankInListByCurrentRank(int currentRank) {
		Vector<Integer> result = new Vector<Integer>();
		MapTableInfo tmp;
		int size = size();

		for(int i = 0; i < size; i++) {
			tmp = mapTable.elementAt(i);
			if(tmp.getCurrentRank() == currentRank) {
				Integer element = new Integer(tmp.getRankInList());
				result.addElement(element);
			}
		}

		return result;
	}

	public class MapTableInfo implements Serializable {
		private static final long serialVersionUID = 1000001L;
		int currentRank;	//Rank in current Communicator
		int worldRank;		//Rank in COMM_WORLD
		int rankInList;		//Rank in List of COMM_WORLD

		public MapTableInfo(int currentRank, int worldRank, int rankInList) {
			this.currentRank = currentRank;
			this.worldRank   = worldRank;
			this.rankInList	 = rankInList;
		}

		public int getCurrentRank() {
			return currentRank;
		}

		public int getWorldRank() {
			return worldRank;
		}

		public int getRankInList() {
			return rankInList;
		}
	}
	
}
