/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import p2pmpi.common.RankTable;
import p2pmpi.message.DatMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.MessageHandler;
import p2pmpi.mpi.dev.NIORequest;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.RDVHeaderInformation;
import p2pmpi.mpi.dev.RecvBufferInformation;
import p2pmpi.mpi.dev.SendBufferInformation;
import p2pmpi.mpi.dev.SmallRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIODevice
extends Device
implements Runnable {
    int numReadTotal = 0;
    SocketChannel[][] outputChannels;
    SocketChannel[][] inputChannels;
    Selector selector;
    Selector selectorTmp;
    static final int INIT_BUFSIZE = 0x200000;
    ByteBuffer recvBuffer;
    ByteBuffer sendBuffer = ByteBuffer.allocateDirect(0x200000);
    ByteBuffer finalizeBuffer;
    ByteBuffer commitBuffer;
    ByteBuffer readyToSendBuffer;
    ByteBuffer readyToRecvBuffer;
    int totalConnect;
    volatile boolean doneSend;
    byte[] bMID;
    protected Map semaphoreSet;
    protected Map<String, LargeMessageSender> largeMessagePending;
    protected Map<String, RDVHeaderInformation> waitForRecvReady;

    @Override
    public boolean isDone() {
        return this.totalConnect == (this.rankTable.size() - 1) * 2;
    }

    public NIODevice() {
        this.recvBuffer = ByteBuffer.allocateDirect(0x200000);
        this.bMID = new byte[64];
        this.semaphoreSet = new HashMap();
        this.largeMessagePending = new HashMap<String, LargeMessageSender>();
        this.waitForRecvReady = new HashMap<String, RDVHeaderInformation>();
        this.finalizeBuffer = ByteBuffer.allocateDirect(6);
        this.commitBuffer = ByteBuffer.allocateDirect(20);
        this.readyToSendBuffer = ByteBuffer.allocateDirect(32);
        this.readyToRecvBuffer = ByteBuffer.allocateDirect(24);
        this.tpes = Executors.newCachedThreadPool();
    }

    @Override
    public boolean init() {
        try {
            this.selector = Selector.open();
            this.selectorTmp = Selector.open();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public int initPort(int n, int n2, String string) {
        Random random = new Random();
        int n3 = random.nextInt(n2 - n) + n;
        int n4 = 2;
        while (n4-- > 0) {
            for (int i = n3; i <= n2; ++i) {
                try {
                    ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                    serverSocketChannel.configureBlocking(false);
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, i);
                    serverSocketChannel.socket().bind(inetSocketAddress);
                    serverSocketChannel.register(this.selector, 16);
                    return i;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            n3 = n;
        }
        return -1;
    }

    public void sendReadyToRecv(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DatMessage datMessage = new DatMessage(this.readyToRecvBuffer, 7);
        datMessage.pack(s);
        datMessage.pack(n);
        datMessage.pack(n2);
        datMessage.pack(n3);
        datMessage.pack(n4);
        datMessage.pack(this.myRankInList);
        datMessage.done();
        if (this.commWorld.isAlive(n5)) {
            SocketChannel socketChannel = this.outputChannels[n7][n6];
            Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
            try {
                semaphore.acquire();
                this.toleranceWrite(this.readyToRecvBuffer, socketChannel, n5);
                semaphore.release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int readUntilSize(SocketChannel socketChannel) {
        int n = 0;
        try {
            int n2;
            do {
                n2 = socketChannel.read(this.recvBuffer);
                n += n2;
            } while (n2 > 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
        return n;
    }

    public void readWithTmpSelector(SocketChannel socketChannel, int n, int n2) {
        int n3 = n;
        try {
            int n4 = this.recvBuffer.position();
            int n5 = this.recvBuffer.limit();
            this.recvBuffer.limit(this.recvBuffer.capacity());
            this.recvBuffer.position(n5);
            SelectionKey selectionKey = socketChannel.register(this.selectorTmp, 1);
            while (this.selectorTmp.select(20000L) > 0) {
                Set<SelectionKey> set = this.selectorTmp.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey2 = iterator.next();
                    iterator.remove();
                    if (!selectionKey2.isReadable() || (n3 += this.readUntilSize(socketChannel)) < n2) continue;
                    this.recvBuffer.limit(this.recvBuffer.position());
                    this.recvBuffer.position(n4);
                    selectionKey.cancel();
                    this.selectorTmp.selectNow();
                    return;
                }
            }
            this.recvBuffer.limit(this.recvBuffer.position());
            this.recvBuffer.position(n4);
            selectionKey.cancel();
            this.selectorTmp.selectNow();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean init(ServerSocket serverSocket, String string, int n, int n2) {
        this.myHash = string;
        this.fdPort = n2;
        this.mpdPort = n;
        this.msgHandle = new MessageHandler(this, serverSocket, string, n, n2);
        Thread thread = new Thread(this.msgHandle);
        thread.setDaemon(true);
        thread.start();
        try {
            this.selector = Selector.open();
            this.selectorTmp = Selector.open();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void spawnMessageHandler(ServerSocket serverSocket, int n, RankTable rankTable, String string, int n2, int n3, int n4, int n5, int n6, String string2) {
        this.myHash = string;
        this.fdPort = n3;
        this.mpdPort = n2;
        this.msgHandle = new MessageHandler(this, serverSocket, n, rankTable, string, n2, n3);
        this.msgHandle.setTGossip(n4);
        this.msgHandle.setTMargin(n5);
        this.msgHandle.setTHang(n6);
        this.msgHandle.setGossipProtocol(string2);
        Thread thread = new Thread(this.msgHandle);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void connect(int n, int n2, int n3, RankTable rankTable, int n4, int n5) {
        this.myRank = n;
        this.myRankInRep = n2;
        this.myRankInList = n3;
        this.rankTable = rankTable;
        this.numReplica = n5;
        this.numProc = n4;
        for (int i = 2; i <= n4; i *= 2) {
            if (i != n4) continue;
            this.N_POWER2 = true;
        }
        this.inputChannels = new SocketChannel[n5][n4];
        this.outputChannels = new SocketChannel[n5][n4];
    }

    @Override
    public boolean connectToNode(URI uRI, int n, int n2, SocketChannel[][] socketChannelArray, byte by) {
        this.sendBuffer.clear();
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(InetAddress.getByName(uRI.getHost()), uRI.getPort());
        }
        catch (Exception exception) {
            return false;
        }
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.socket().setSendBufferSize(524288);
            socketChannel.socket().setReceiveBufferSize(524288);
            socketChannel.socket().setTcpNoDelay(true);
            boolean bl = socketChannel.connect(inetSocketAddress);
            while (!socketChannel.finishConnect()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            boolean bl2 = false;
            while (!bl2) {
                try {
                    DatMessage datMessage = new DatMessage(this.sendBuffer, 1);
                    datMessage.pack(this.myRank);
                    datMessage.pack(this.myRankInRep);
                    datMessage.pack(by);
                    datMessage.done();
                    bl2 = true;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    this.sendBuffer = ByteBuffer.allocateDirect(this.sendBuffer.capacity() * 2);
                }
            }
            if (socketChannel.write(this.sendBuffer) > 0) {
                socketChannel.register(this.selector, 1);
                socketChannelArray[n2][n] = socketChannel;
                ++this.totalConnect;
                if (by == 0) {
                    socketChannel.keyFor(this.selector).cancel();
                    socketChannel.configureBlocking(true);
                    socketChannel.socket().setTcpNoDelay(true);
                    this.semaphoreSet.put(socketChannel, new Semaphore(1, true));
                }
            }
        }
        catch (ConnectException connectException) {
            System.out.println("[Error] : connect to address : " + connectException.getMessage());
            return false;
        }
        catch (Exception exception) {
            System.out.println("[Error] : connect to address : " + exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        int n = this.rankTable.size();
        int n2 = n - this.myRankInList - 1;
        int n3 = n - n2 - 1;
        try {
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                URI uRI = this.rankTable.getDataURI(i);
                if (!this.connectToNode(uRI, n5 = this.rankTable.getRank(i), n4 = this.rankTable.getRankInReplica(uRI, i), this.outputChannels, (byte)0)) {
                    System.out.println("[Error] : Failed to create MPI communicator");
                    System.exit(1);
                }
                if (this.connectToNode(uRI = this.rankTable.getCtrlURI(i), n5, n4, this.inputChannels, (byte)1)) continue;
                System.out.println("[Error] : Failed to create MPI communicator");
                System.exit(1);
            }
            block3: while (true) {
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    this.processSelectionKey(selectionKey);
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean encodeMessage(SocketChannel var1_1, SelectionKey var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processSelectionKey(SelectionKey selectionKey) {
        String string = null;
        try {
            AbstractSelectableChannel abstractSelectableChannel;
            boolean bl;
            if (selectionKey.isValid() && selectionKey.isConnectable() && !(bl = ((SocketChannel)(abstractSelectableChannel = (SocketChannel)selectionKey.channel())).finishConnect())) {
                selectionKey.cancel();
            }
            if (selectionKey.isValid() && selectionKey.isReadable()) {
                ByteBuffer byteBuffer;
                int n;
                bl = false;
                SocketAttachment socketAttachment = null;
                int n2 = 0;
                ByteBuffer byteBuffer2 = null;
                this.recvBuffer.clear();
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                string = "[isReadable]: from " + socketChannel.toString();
                socketAttachment = (SocketAttachment)selectionKey.attachment();
                if (socketAttachment != null) {
                    byteBuffer2 = this.recvBuffer;
                    this.recvBuffer = socketAttachment.getBuffer();
                    n2 = socketAttachment.getPosition();
                }
                int n3 = 0;
                do {
                    n = socketChannel.read(this.recvBuffer);
                    n3 += n;
                    if (this.recvBuffer.hasRemaining()) continue;
                    byteBuffer = ByteBuffer.allocateDirect(this.recvBuffer.capacity() * 2);
                    if (socketAttachment != null) {
                        byteBuffer2 = ByteBuffer.allocateDirect(this.recvBuffer.capacity() * 2);
                    }
                    int n4 = this.recvBuffer.position();
                    this.recvBuffer.position(0);
                    this.recvBuffer.limit(this.recvBuffer.capacity());
                    byteBuffer.put(this.recvBuffer);
                    byteBuffer.position(n4);
                    this.recvBuffer = byteBuffer;
                } while (n > 0);
                if (n3 < 0) {
                    try {
                        selectionKey.cancel();
                        socketChannel.close();
                    }
                    catch (Exception exception) {
                        return;
                    }
                } else if (n3 == 0) {
                    return;
                }
                this.recvBuffer.flip();
                this.recvBuffer.position(n2);
                if (!this.encodeMessage(socketChannel, selectionKey)) {
                    if (this.recvBuffer.hasRemaining()) {
                        if (socketAttachment != null) {
                            socketAttachment.setPosition(this.recvBuffer.position());
                            this.recvBuffer.position(this.recvBuffer.limit());
                            this.recvBuffer.limit(this.recvBuffer.capacity());
                            socketAttachment.setBuffer(this.recvBuffer);
                            this.recvBuffer = byteBuffer2;
                        } else {
                            byteBuffer = ByteBuffer.allocateDirect(this.recvBuffer.capacity());
                            byteBuffer.put(this.recvBuffer);
                            byteBuffer.limit(this.recvBuffer.capacity());
                            socketAttachment = new SocketAttachment(byteBuffer, 0);
                            selectionKey.attach(socketAttachment);
                        }
                    }
                } else if (socketAttachment != null) {
                    this.recvBuffer.clear();
                    socketAttachment.setBuffer(this.recvBuffer);
                    socketAttachment.setPosition(0);
                    this.recvBuffer = byteBuffer2;
                }
            }
            if (selectionKey.isValid() && selectionKey.isAcceptable()) {
                abstractSelectableChannel = (ServerSocketChannel)selectionKey.channel();
                SocketChannel socketChannel = ((ServerSocketChannel)abstractSelectableChannel).accept();
                socketChannel.configureBlocking(false);
                socketChannel.socket().setSendBufferSize(524288);
                socketChannel.socket().setReceiveBufferSize(524288);
                socketChannel.socket().setTcpNoDelay(true);
                socketChannel.register(this.selector, 1);
            }
        }
        catch (Exception exception) {
            System.out.println("Error : -> " + string);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFailureRepair(int n) {
        Object object;
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            this.rankTable.setAlive(n, false);
            this.rankTable.setTerminated(n, true);
        }
        int n2 = this.rankTable.size();
        if (n == 0) {
            this.cleanupProcess();
            System.exit(1);
        }
        int n3 = this.msgHandle.getCommSize();
        boolean[] blArray = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            blArray[i] = false;
        }
        RankTable rankTable2 = this.rankTable;
        synchronized (rankTable2) {
            for (int i = 0; i < n2; ++i) {
                if (!this.rankTable.isAlive(i)) continue;
                blArray[this.rankTable.getRank((int)i)] = true;
            }
        }
        for (int i = 0; i < n3; ++i) {
            if (blArray[i]) continue;
            System.err.println("** [Error] rank " + i + " process failed (i.e. all replicas for that rank failed). Application did not completed. <<detected by rank in list: " + this.myRankInList + ">>");
            this.cleanupProcess();
            System.exit(1);
        }
        NotifyMessage notifyMessage = new NotifyMessage(this.myHash + "--" + this.myRank, n);
        try {
            Socket socket = new Socket("127.0.0.1", this.mpdPort);
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(notifyMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == this.myMaster) {
            int n4 = this.myRankInList;
            int n5 = this.rankTable.size();
            for (int i = 0; i < n5; ++i) {
                if (this.myRank != this.rankTable.getRank(i) || !this.rankTable.isAlive(i)) continue;
                if (n4 <= i) {
                    this.myMaster = i;
                    this.master = true;
                    break;
                }
                this.master = false;
                this.myMaster = i;
                break;
            }
            if (this.master) {
                Vector vector = this.backupBuffer;
                synchronized (vector) {
                    while (this.backupBuffer.size() != 0) {
                        object = (SendBufferInformation)this.backupBuffer.elementAt(0);
                        String string = this.getMessageID(((SendBufferInformation)object).getCommID(), ((SendBufferInformation)object).getSrc(), ((SendBufferInformation)object).getDst(), ((SendBufferInformation)object).getTag(), ((SendBufferInformation)object).getNumSend());
                        this.send(((SendBufferInformation)object).getRankTable(), ((SendBufferInformation)object).getData(), ((SendBufferInformation)object).getDestinations(), ((SendBufferInformation)object).getCommID(), ((SendBufferInformation)object).getSrc(), ((SendBufferInformation)object).getDst(), ((SendBufferInformation)object).getTag(), ((SendBufferInformation)object).getNumSend(), ((SendBufferInformation)object).getReplicaRankInList());
                        this.backupBuffer.removeElementAt(0);
                        this.sendLog.remove(string);
                    }
                }
            }
        }
        for (String string : this.largeMessagePending.keySet()) {
            LargeMessageSender largeMessageSender = this.largeMessagePending.get(string);
            largeMessageSender.setReady(n);
            if (!largeMessageSender.isReady()) continue;
            object = new Thread(largeMessageSender);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            this.largeMessagePending.remove(string);
        }
    }

    @Override
    public int send(RankTable rankTable, ByteBuffer byteBuffer, Vector<Integer> vector, short s, int n, int n2, int n3, int n4, int[] nArray) {
        NIORequest nIORequest = this.isend(rankTable, byteBuffer, vector, s, n, n2, n3, n4, nArray);
        IStatus iStatus = nIORequest.Wait();
        return 0;
    }

    @Override
    public int ssend(RankTable rankTable, ByteBuffer byteBuffer, Vector<Integer> vector, short s, int n, int n2, int n3, int n4, int[] nArray) {
        NIORequest nIORequest = this.issend(rankTable, byteBuffer, vector, s, n, n2, n3, n4, nArray);
        IStatus iStatus = nIORequest.Wait();
        return 0;
    }

    @Override
    public NIORequest issend(RankTable rankTable, ByteBuffer byteBuffer, Vector<Integer> vector, short s, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = vector.size();
        LargeMessageSender largeMessageSender = null;
        NIORequest nIORequest = new NIORequest();
        DatMessage datMessage = new DatMessage(this.readyToSendBuffer, 6);
        datMessage.pack(s);
        datMessage.pack(n);
        datMessage.pack(n2);
        datMessage.pack(n3);
        datMessage.pack(n4);
        datMessage.pack(this.myRankInList);
        datMessage.pack(this.myRank);
        datMessage.pack(this.myRankInRep);
        datMessage.done();
        largeMessageSender = new LargeMessageSender(rankTable, nArray, s, n, n2, n3, n4, this.readyToSendBuffer, byteBuffer);
        for (int i = 0; i < n5; ++i) {
            int n6 = vector.elementAt(i);
            if (!this.commWorld.isAlive(n6)) continue;
            SocketChannel socketChannel = this.outputChannels[i][this.getMapRankTable(s).getWorldRank(n6)];
            SmallRequest smallRequest = new SmallRequest(n6);
            nIORequest.add(smallRequest);
            Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
            try {
                semaphore.acquire();
                largeMessageSender.addDestination(socketChannel, smallRequest, n6);
                semaphore.release();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
        largeMessageSender.sendReadyToSend();
        nIORequest.fillStatus(n, n3, 0);
        return nIORequest;
    }

    @Override
    public NIORequest isend(RankTable rankTable, ByteBuffer byteBuffer, Vector<Integer> vector, short s, int n, int n2, int n3, int n4, int[] nArray) {
        boolean bl;
        int n5 = vector.size();
        int n6 = byteBuffer.limit();
        LargeMessageSender largeMessageSender = null;
        NIORequest nIORequest = new NIORequest();
        if (n6 <= EAGER_SIZE) {
            bl = true;
        } else {
            bl = false;
            DatMessage datMessage = new DatMessage(this.readyToSendBuffer, 6);
            datMessage.pack(s);
            datMessage.pack(n);
            datMessage.pack(n2);
            datMessage.pack(n3);
            datMessage.pack(n4);
            datMessage.pack(this.myRankInList);
            datMessage.pack(this.myRank);
            datMessage.pack(this.myRankInRep);
            datMessage.done();
            largeMessageSender = new LargeMessageSender(rankTable, nArray, s, n, n2, n3, n4, this.readyToSendBuffer, byteBuffer);
        }
        for (int i = 0; i < n5; ++i) {
            int n7 = vector.elementAt(i);
            if (!this.commWorld.isAlive(n7)) continue;
            SocketChannel socketChannel = this.outputChannels[i][this.getMapRankTable(s).getWorldRank(n7)];
            SmallRequest smallRequest = new SmallRequest(n7);
            nIORequest.add(smallRequest);
            Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
            try {
                semaphore.acquire();
                if (bl) {
                    this.toleranceWrite(byteBuffer, socketChannel, n7);
                    smallRequest.complete();
                    byteBuffer.rewind();
                } else {
                    largeMessageSender.addDestination(socketChannel, smallRequest, n7);
                }
                semaphore.release();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            this.commit(rankTable, nArray, s, n, n2, n3, n4);
        } else {
            this.largeMessagePending.put(largeMessageSender.getKey(), largeMessageSender);
            largeMessageSender.sendReadyToSend();
        }
        nIORequest.fillStatus(n, n3, 0);
        return nIORequest;
    }

    @Override
    public synchronized void commit(RankTable rankTable, int[] nArray, short s, int n, int n2, int n3, int n4) {
        DatMessage datMessage = new DatMessage(this.commitBuffer, 3);
        datMessage.pack(s);
        datMessage.pack(n);
        datMessage.pack(n2);
        datMessage.pack(n3);
        datMessage.pack(n4);
        datMessage.done();
        for (int i = 0; i < this.numReplica; ++i) {
            if (nArray[i] == this.myRankInList || !this.commWorld.isAlive(nArray[i])) continue;
            SocketChannel socketChannel = this.outputChannels[i][this.getMapRankTable(s).getWorldRank(this.myRankInList)];
            Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
            try {
                semaphore.acquire();
                this.toleranceWrite(this.commitBuffer, socketChannel, nArray[i]);
                semaphore.release();
                this.commitBuffer.rewind();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void finalize(int n) {
        DatMessage datMessage = new DatMessage(this.finalizeBuffer, 4);
        datMessage.pack(n);
        datMessage.done();
        SocketChannel socketChannel = this.outputChannels[0][0];
        Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
        try {
            semaphore.acquire();
            this.toleranceWrite(this.finalizeBuffer, socketChannel, 0);
            semaphore.release();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void finalizeConfirm() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(3);
        byteBuffer.putShort((short)13);
        byteBuffer.put((byte)5);
        byteBuffer.flip();
        int n = this.rankTable.size();
        for (int i = 1; i < n; ++i) {
            URI uRI = this.rankTable.getDataURI(i);
            int n2 = this.rankTable.getRank(i);
            int n3 = this.rankTable.getRankInReplica(uRI, i);
            SocketChannel socketChannel = this.outputChannels[n3][n2];
            Semaphore semaphore = (Semaphore)this.semaphoreSet.get(socketChannel);
            try {
                semaphore.acquire();
                this.toleranceWrite(byteBuffer, socketChannel, i);
                semaphore.release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            byteBuffer.position(0);
        }
    }

    private boolean reconnect(int n) {
        URI uRI = this.rankTable.getDataURI(n);
        int n2 = this.rankTable.getRank(n);
        int n3 = this.rankTable.getRankInReplica(uRI, n);
        while (this.rankTable.isAlive(n)) {
            if (!this.connectToNode(uRI, n2, n3, this.outputChannels, (byte)0)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            return true;
        }
        return false;
    }

    public void toleranceWrite(ByteBuffer byteBuffer, SocketChannel socketChannel, int n) {
        while (byteBuffer.hasRemaining()) {
            try {
                int n2 = socketChannel.write(byteBuffer);
                if (n2 >= 0 || this.reconnect(n)) continue;
                return;
            }
            catch (Exception exception) {
                if (this.reconnect(n)) continue;
                return;
            }
        }
    }

    @Override
    public IStatus recv(Object object, int n, int n2, short s, int n3, int n4, int n5, int n6, P2PMPI_Buffer p2PMPI_Buffer) {
        NIORequest nIORequest = this.irecv(object, n, n2, s, n3, n4, n5, n6, p2PMPI_Buffer);
        IStatus iStatus = nIORequest.Wait();
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NIORequest irecv(Object object, int n, int n2, short s, int n3, int n4, int n5, int n6, P2PMPI_Buffer p2PMPI_Buffer) {
        NIORequest nIORequest = new NIORequest(object, n, n2, n3, n4, n5, p2PMPI_Buffer);
        Vector vector = this.unexpectedQueue;
        synchronized (vector) {
            Vector vector2 = this.expectedQueue;
            synchronized (vector2) {
                Map<String, RDVHeaderInformation> map = this.waitForRecvReady;
                synchronized (map) {
                    IStatus iStatus = new IStatus();
                    ByteBuffer byteBuffer = this.getDataFromUnexpectedQueue(s, n3, n4, n5, n6, iStatus);
                    if (byteBuffer != null) {
                        int n7 = nIORequest.addData(byteBuffer, byteBuffer.remaining());
                        nIORequest.fillStatus(iStatus, n7);
                        nIORequest.complete();
                        return nIORequest;
                    }
                    RDVHeaderInformation rDVHeaderInformation = this.waitForRecvReady.remove(this.getHashKey(s, n3, n4, n5, n6));
                    if (rDVHeaderInformation != null) {
                        this.sendReadyToRecv(rDVHeaderInformation.getCommID(), rDVHeaderInformation.getSrc(), rDVHeaderInformation.getDst(), rDVHeaderInformation.getTag(), rDVHeaderInformation.getNumSend(), rDVHeaderInformation.getSenderRIL(), rDVHeaderInformation.getSenderRank(), rDVHeaderInformation.getSenderRIR());
                    }
                    RecvBufferInformation recvBufferInformation = new RecvBufferInformation(s, n3, n4, null, n5, n6, nIORequest);
                    this.expectedQueue.addElement(recvBufferInformation);
                }
            }
        }
        return nIORequest;
    }

    public class SocketAttachment {
        ByteBuffer buffer;
        int position;

        public SocketAttachment(ByteBuffer byteBuffer, int n) {
            this.buffer = byteBuffer;
            this.position = n;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getPosition() {
            return this.position;
        }

        public void setBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        public void setPosition(int n) {
            this.position = n;
        }
    }

    public class MessageSender {
        SocketChannel socket;
        SmallRequest smallRequest;
        int rankInList;
        boolean readyToSend;

        public MessageSender(SocketChannel socketChannel, SmallRequest smallRequest, int n) {
            this.socket = socketChannel;
            this.smallRequest = smallRequest;
            this.rankInList = n;
            this.readyToSend = false;
        }

        public void setReady() {
            this.readyToSend = true;
        }

        public boolean isReady() {
            return this.readyToSend;
        }

        public SocketChannel getSocket() {
            return this.socket;
        }

        public int getDestination() {
            return this.rankInList;
        }

        public SmallRequest getSmallRequest() {
            return this.smallRequest;
        }
    }

    public class LargeMessageSender
    implements Runnable {
        Vector<MessageSender> senderList = new Vector();
        RankTable commTable;
        int[] repRankInList;
        short commID;
        int src;
        int dst;
        int tag;
        int numsend;
        ByteBuffer dataBuffer;
        int numSender;
        ByteBuffer readyToSendBuffer;
        long t1;
        long t2;
        long t3;
        long t4;
        SocketChannel destinationSocket;
        SmallRequest destinationSmallRequest;
        int destinationRankInList;
        boolean readyToSend = false;

        public LargeMessageSender(RankTable rankTable, int[] nArray, short s, int n, int n2, int n3, int n4, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.commTable = rankTable;
            this.repRankInList = nArray;
            this.commID = s;
            this.src = n;
            this.dst = n2;
            this.tag = n3;
            this.numsend = n4;
            this.numSender = 0;
            this.readyToSendBuffer = byteBuffer;
            this.dataBuffer = byteBuffer2;
        }

        public String getKey() {
            return this.commID + "_" + this.src + "_" + this.dst + "_" + this.tag + "_" + this.numsend;
        }

        public void sendReadyToSend() {
            if (NIODevice.this.numReplica == 1) {
                Semaphore semaphore = (Semaphore)NIODevice.this.semaphoreSet.get(this.destinationSocket);
                try {
                    semaphore.acquire();
                    NIODevice.this.toleranceWrite(this.readyToSendBuffer, this.destinationSocket, this.destinationRankInList);
                    semaphore.release();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender messageSender = this.senderList.elementAt(i);
                    SocketChannel socketChannel = messageSender.getSocket();
                    int n = messageSender.getDestination();
                    Semaphore semaphore = (Semaphore)NIODevice.this.semaphoreSet.get(socketChannel);
                    try {
                        semaphore.acquire();
                        NIODevice.this.toleranceWrite(this.readyToSendBuffer, socketChannel, n);
                        this.readyToSendBuffer.rewind();
                        semaphore.release();
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        public void addDestination(SocketChannel socketChannel, SmallRequest smallRequest, int n) {
            if (NIODevice.this.numReplica == 1) {
                this.destinationSocket = socketChannel;
                this.destinationSmallRequest = smallRequest;
                this.destinationRankInList = n;
            } else {
                MessageSender messageSender = new MessageSender(socketChannel, smallRequest, n);
                this.senderList.add(messageSender);
                ++this.numSender;
            }
        }

        public void setReady(int n) {
            block2: {
                block1: {
                    if (NIODevice.this.numReplica != 1) break block1;
                    if (this.destinationRankInList != n) break block2;
                    this.readyToSend = true;
                    break block2;
                }
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender messageSender = this.senderList.elementAt(i);
                    if (messageSender.getDestination() != n) continue;
                    messageSender.setReady();
                    break;
                }
            }
        }

        public boolean isReady() {
            if (NIODevice.this.numReplica == 1) {
                return this.readyToSend;
            }
            for (int i = 0; i < this.numSender; ++i) {
                MessageSender messageSender = this.senderList.elementAt(i);
                if (messageSender.isReady()) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (NIODevice.this.numReplica == 1) {
                Semaphore semaphore = (Semaphore)NIODevice.this.semaphoreSet.get(this.destinationSocket);
                try {
                    semaphore.acquire();
                    NIODevice.this.toleranceWrite(this.dataBuffer, this.destinationSocket, this.destinationRankInList);
                    if (this.destinationSmallRequest != null) {
                        this.destinationSmallRequest.complete();
                    }
                    semaphore.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NIODevice.this.commit(this.commTable, this.repRankInList, this.commID, this.src, this.dst, this.tag, this.numsend);
            } else {
                for (int i = 0; i < this.numSender; ++i) {
                    MessageSender messageSender = this.senderList.elementAt(i);
                    SocketChannel socketChannel = messageSender.getSocket();
                    int n = messageSender.getDestination();
                    SmallRequest smallRequest = messageSender.getSmallRequest();
                    Semaphore semaphore = (Semaphore)NIODevice.this.semaphoreSet.get(socketChannel);
                    try {
                        semaphore.acquire();
                        NIODevice.this.toleranceWrite(this.dataBuffer, socketChannel, n);
                        if (smallRequest != null) {
                            smallRequest.complete();
                        }
                        this.dataBuffer.rewind();
                        semaphore.release();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NIODevice.this.commit(this.commTable, this.repRankInList, this.commID, this.src, this.dst, this.tag, this.numsend);
            }
        }
    }
}

