/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.RankTable;
import p2pmpi.message.AliveMessage;
import p2pmpi.message.IsAliveMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.NoAliveMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.mpi.dev.Device;

public class MessageHandler
implements Runnable {
    private String key;
    private boolean ready;
    private ServerSocket servSocket = null;
    private RankTable rankTable;
    private int myRank;
    private int myRankInList;
    private int commSize;
    private int t_gossip;
    private String gossipProtocol;
    private int t_margin;
    private int t_diff;
    private int t_hang;
    private volatile boolean shutdown = false;
    private boolean rankZero;
    private Device dev;

    public MessageHandler(Device device, ServerSocket serverSocket, int n, RankTable rankTable, String string, int n2, int n3) {
        this.dev = device;
        this.commSize = n;
        this.key = string;
        this.rankTable = rankTable;
        this.ready = false;
        this.rankZero = true;
        this.shutdown = false;
        this.servSocket = serverSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessageHandler(Device device, ServerSocket serverSocket, String string, int n, int n2) {
        this.dev = device;
        this.key = string;
        this.ready = false;
        this.shutdown = false;
        this.rankZero = false;
        this.servSocket = serverSocket;
        try {
            this.servSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.servSocket != null) {
                this.servSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRankTable(RankTable rankTable) {
        this.rankTable = rankTable;
    }

    public void setTHang(int n) {
        this.t_hang = n;
    }

    public int getTHang() {
        return this.t_hang;
    }

    public RankTable getRankTable() {
        return this.rankTable;
    }

    public void run() {
        Socket socket = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        Object var5_5 = null;
        if (!this.rankZero) {
            try {
                this.servSocket.setSoTimeout(600000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        while (!this.shutdown) {
            Serializable serializable;
            try {
                socket = this.servSocket.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.exit(1);
            }
            catch (IOException iOException) {
                continue;
            }
            try {
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                try {
                    objectInputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception2) {}
                continue;
            }
            if (object instanceof MPIMessage) {
                serializable = (MPIMessage)object;
                switch (((MPIMessage)serializable).getCmd()) {
                    case 12: {
                        this.ready = true;
                        this.myRank = ((MPIMessage)serializable).getRank();
                        this.myRankInList = ((MPIMessage)serializable).getRankInList();
                        this.commSize = ((MPIMessage)serializable).getSize();
                        this.setRankTable(((MPIMessage)serializable).getCommTable());
                        this.t_gossip = ((MPIMessage)serializable).getTGossip();
                        this.t_margin = ((MPIMessage)serializable).getTMargin();
                        this.t_hang = ((MPIMessage)serializable).getTHang();
                        this.t_diff = ((MPIMessage)serializable).getTDiff();
                        this.gossipProtocol = ((MPIMessage)serializable).getGossipProtocol();
                        try {
                            this.servSocket.setSoTimeout(0);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            } else if (object instanceof NotifyMessage) {
                serializable = (NotifyMessage)object;
                int n = ((NotifyMessage)serializable).getRankInList();
                this.dev.doFailureRepair(n);
            } else if (object instanceof IsAliveMessage) {
                Serializable serializable2;
                serializable = (IsAliveMessage)object;
                Object var8_16 = null;
                OutputStream outputStream = null;
                ObjectOutputStream objectOutputStream = null;
                if (this.key.equals(((IsAliveMessage)serializable).getKey())) {
                    serializable2 = new AliveMessage(this.key);
                    try {
                        outputStream = socket.getOutputStream();
                        objectOutputStream = new ObjectOutputStream(outputStream);
                        objectOutputStream.writeObject(serializable2);
                        objectOutputStream.close();
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                } else {
                    serializable2 = new NoAliveMessage();
                    try {
                        outputStream = socket.getOutputStream();
                        objectOutputStream = new ObjectOutputStream(outputStream);
                        objectOutputStream.writeObject(serializable2);
                        objectOutputStream.close();
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            } else if (object instanceof RequestQuitMessage) {
                System.exit(0);
            } else if (object instanceof OutputMessage) {
                serializable = (OutputMessage)object;
                System.out.println(((OutputMessage)serializable).getOutput());
            } else {
                System.err.println("** [Warning] received unknow type of message.");
            }
            try {
                objectInputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] cannot close communication, maybe a network problem.");
            }
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setTGossip(int n) {
        this.t_gossip = n;
    }

    public void setTMargin(int n) {
        this.t_margin = n;
    }

    public int getTDiff() {
        return this.t_diff;
    }

    public int getTGossip() {
        return this.t_gossip;
    }

    public void setGossipProtocol(String string) {
        this.gossipProtocol = new String(string);
    }

    public String getGossipProtocol() {
        return this.gossipProtocol;
    }

    public int getTMargin() {
        return this.t_margin;
    }

    public int getRank() {
        return this.myRank;
    }

    public int getRankInList() {
        return this.myRankInList;
    }

    public int getCommSize() {
        return this.commSize;
    }

    public void stop() {
        try {
            this.servSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

