/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Random;
import java.util.Vector;
import p2pmpi.common.Getopt;
import p2pmpi.common.HashGenerator;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FTMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPIClient;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.NIODevice;
import p2pmpi.mpi.dev.NormalDevice;

public class MPI {
    public static Datatype NULL;
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype STRING;
    public static Datatype OBJECT;
    public static Datatype BYTE2;
    public static Datatype CHAR2;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Datatype PACKED;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static int UNEQUAL;
    public static int SIMILAR;
    public static int IDENT;
    public static int UNDEFINED;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op BAND;
    public static Op MAXLOC;
    public static Op MINLOC;
    public static IntraComm COMM_WORLD;
    protected static RankTable rankTable;
    protected static MapRankTable mapRankTable;
    protected static String myHash;
    protected static int fdPort;
    protected static int mpdPort;
    protected static int rsPort;
    protected static int ftPort;
    protected static int myRank;
    protected static Device myDevice;
    protected static Random mpiRandom;
    protected static URI cmdURI;
    protected static URI ctrlURI;
    protected static URI dataURI;
    private static String hostIP;
    private static int t_sent;
    private static int dataPort;
    private static int ctrlPort;

    private static void setLocalhostIP() {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        String string = p2PMPI_ConfigFile.getExternalIP();
        if (string == null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                System.err.println("** [ Error] Could not figure out local hostname.");
                System.exit(-1);
            }
            hostIP = inetAddress.getHostAddress();
        } else {
            hostIP = string;
        }
    }

    protected static String getLocalhostIP() {
        return hostIP;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] Init(String[] stringArray) {
        int n;
        String[] stringArray2 = null;
        String string = null;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        MPIMessage mPIMessage = null;
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        mpdPort = p2PMPI_ConfigFile.getMPDPort();
        ftPort = p2PMPI_ConfigFile.getFTPort();
        rsPort = p2PMPI_ConfigFile.getRSPort();
        fdPort = p2PMPI_ConfigFile.getFDPort();
        int n2 = p2PMPI_ConfigFile.getTGossip();
        int n3 = p2PMPI_ConfigFile.getTHang();
        String string2 = p2PMPI_ConfigFile.getGossipProtocol();
        MPI.setLocalhostIP();
        int n4 = p2PMPI_ConfigFile.getMinPort();
        int n5 = p2PMPI_ConfigFile.getMaxPort();
        int n6 = 0;
        String string3 = System.getProperty("mode");
        ServerSocket serverSocket = null;
        if (string3.equals("server")) {
            Serializable serializable;
            int n7;
            Object iOException;
            String[] stringArray3;
            String[] stringArray4;
            Object object;
            void var40_58;
            Serializable serializable2;
            Serializable serializable3;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            n = -1;
            int n14 = -1;
            int n15 = 1;
            String string4 = null;
            String string5 = null;
            boolean bl = true;
            String string6 = "must be followed by a positive integer number";
            Getopt getopt = new Getopt("P2P-MPI", stringArray, "w:n:r:l:a:X:D:");
            getopt.setOpterr(false);
            String string7 = "";
            String string8 = "";
            while ((n13 = getopt.getopt()) != -1) {
                switch (n13) {
                    case 119: {
                        String string9 = getopt.getOptarg();
                        try {
                            n14 = Integer.parseInt(string9);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -w  " + string6);
                            System.exit(1);
                        }
                        if (n14 >= -1) break;
                        System.err.println("** [Error] -w  " + string6);
                        System.exit(1);
                        break;
                    }
                    case 110: {
                        String string9 = getopt.getOptarg();
                        try {
                            n = Integer.parseInt(string9);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -n  " + string6);
                            System.exit(1);
                        }
                        if (n >= 1) break;
                        System.err.println("** [Error] -n  " + string6);
                        System.exit(1);
                        break;
                    }
                    case 114: {
                        String string9 = getopt.getOptarg();
                        try {
                            n15 = Integer.parseInt(string9);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -r  " + string6);
                            System.exit(1);
                        }
                        if (n15 >= 1) break;
                        System.err.println("** [Error] -r  " + string6);
                        System.exit(1);
                        break;
                    }
                    case 108: {
                        String string9 = getopt.getOptarg();
                        string5 = new String(string9);
                        break;
                    }
                    case 97: {
                        String string9 = getopt.getOptarg();
                        string4 = new String(string9);
                        if (string4.equalsIgnoreCase("spread") || string4.equalsIgnoreCase("concentrate")) break;
                        System.err.println("** [Error] -a must be followed by \"spread\" or \"concentrate\"");
                        System.exit(1);
                        break;
                    }
                    case 88: {
                        String string9 = getopt.getOptarg();
                        string7 = "-X" + string9 + " ";
                        break;
                    }
                    case 68: {
                        String string9 = getopt.getOptarg();
                        string8 = "-D" + string9 + " ";
                    }
                }
            }
            Vector<String> vector = new Vector<String>();
            for (n12 = getopt.getOptind(); n12 < stringArray.length; ++n12) {
                vector.addElement(stringArray[n12]);
            }
            string = new String(string7 + string8 + (String)vector.elementAt(0));
            n12 = vector.size();
            stringArray2 = new String[n12 - 1];
            for (n11 = 0; n11 < n12 - 1; ++n11) {
                stringArray2[n11] = new String((String)vector.elementAt(n11 + 1));
                string = string + " " + stringArray2[n11];
            }
            n11 = n15;
            int n16 = (n - 1) * n15;
            Random random = new Random();
            for (n10 = n9 = random.nextInt(n5 - n4) + n4; n10 <= n5; ++n10) {
                try {
                    serverSocket = new ServerSocket(n10);
                    n6 = n10;
                    break;
                }
                catch (Exception exception) {
                    serverSocket = null;
                    continue;
                }
            }
            if (serverSocket == null) {
                for (n10 = n4; n10 <= n5; ++n10) {
                    try {
                        serverSocket = new ServerSocket(n10);
                        n6 = n10;
                        break;
                    }
                    catch (Exception exception) {
                        serverSocket = null;
                        continue;
                    }
                }
                if (serverSocket == null) {
                    System.err.println("No available ports in the range allowed [" + n4 + " - " + n5 + "] to run this application");
                    System.exit(1);
                }
            }
            myHash = HashGenerator.gen();
            mpiRandom = new Random(Long.parseLong(myHash));
            try {
                cmdURI = new URI("tcp://" + MPI.getLocalhostIP() + ":" + n6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string10 = System.getProperty("device");
            if (string10 == null) {
                System.err.println("[Error] : no proprty \"device\" defined. Use java -Ddevice. Exiting.");
                System.exit(1);
            }
            if (!(myDevice = string10.equals("niodevice") ? new NIODevice() : (string10.equals("normal") ? new NormalDevice() : new NIODevice())).init()) {
                System.err.println("[Error] : MPI NIO device init failed");
                System.exit(1);
            }
            if ((dataPort = myDevice.initPort(n4, n5, MPI.getLocalhostIP())) == -1) {
                System.err.println("No available ports in the range allowed [" + n4 + " - " + n5 + "] to run this application");
                System.exit(1);
            }
            try {
                dataURI = new URI("tcp://" + MPI.getLocalhostIP() + ":" + dataPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctrlPort = myDevice.initPort(n4, n5, MPI.getLocalhostIP());
            if (ctrlPort == -1) {
                System.err.println("No available ports in the range allowed [" + n4 + " - " + n5 + "] to run this application");
                System.exit(1);
            }
            try {
                ctrlURI = new URI("tcp://" + MPI.getLocalhostIP() + ":" + ctrlPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 1) {
                Object object3;
                rankTable = new RankTable();
                rankTable.addProcess(0, cmdURI, ctrlURI, dataURI, fdPort);
                rankTable.setNumProcess(1);
                rankTable.setNumReplica(1);
                mapRankTable = new MapRankTable();
                mapRankTable.addMap(0, 0, 0);
                serializable3 = new AppRegisterMessage();
                ((AppRegisterMessage)serializable3).setID(myHash + "--0");
                ((AppRegisterMessage)serializable3).setRunCmd(string);
                ((AppRegisterMessage)serializable3).setIPRank0(MPI.getLocalhostIP());
                ((AppRegisterMessage)serializable3).setRunDir("");
                ((AppRegisterMessage)serializable3).setRank(0);
                ((AppRegisterMessage)serializable3).setPort(n6);
                ((AppRegisterMessage)serializable3).setMPISize(n);
                ((AppRegisterMessage)serializable3).setRealSize(rankTable.size());
                ((AppRegisterMessage)serializable3).setRankTable(rankTable);
                try {
                    socket = new Socket("127.0.0.1", mpdPort);
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(serializable3);
                    objectOutputStream.flush();
                    inputStream = socket.getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    object3 = (PingReplyMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    objectOutputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Please make sure that MPD is running.");
                    System.exit(1);
                }
                myDevice.connect(0, 0, 0, rankTable, n, n15);
                myDevice.spawnMessageHandler(serverSocket, n, rankTable, myHash, mpdPort, fdPort, p2PMPI_ConfigFile.getTGossip(), t_sent * rankTable.size(), p2PMPI_ConfigFile.getTHang(), p2PMPI_ConfigFile.getGossipProtocol());
                object3 = new Thread(myDevice);
                ((Thread)object3).setDaemon(true);
                ((Thread)object3).start();
                COMM_WORLD = new IntraComm(myDevice, rankTable, 0, 0, n, mapRankTable);
                return stringArray2;
            }
            if (n14 < 0) {
                n14 = n16 * 3;
            }
            serializable3 = new MPDMessage(7, myHash);
            ((MPDMessage)serializable3).setOptionN(n - 1);
            ((MPDMessage)serializable3).setOptionR(n15);
            ((MPDMessage)serializable3).setMinPeers(n11);
            ((MPDMessage)serializable3).setMaxPeers(n16);
            ((MPDMessage)serializable3).setWaitTime(n14);
            ((MPDMessage)serializable3).setIP(MPI.getLocalhostIP(), n6);
            ((MPDMessage)serializable3).setRunCmd(string);
            ((MPDMessage)serializable3).setAllocationMode(string4);
            System.out.println("Searching nodes for a maximum of " + n14 + " seconds ...");
            Socket socket2 = null;
            try {
                socket2 = new Socket("127.0.0.1", mpdPort);
                outputStream = socket2.getOutputStream();
                inputStream = socket2.getInputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable3);
                objectOutputStream.flush();
                objectInputStream = new ObjectInputStream(inputStream);
                serializable2 = (FoundNodeMessage)objectInputStream.readObject();
                boolean n8 = ((FoundNodeMessage)serializable2).isEnough();
                int n17 = ((FoundNodeMessage)serializable2).getNumFoundNode();
                int n18 = ((FoundNodeMessage)serializable2).getNumSlotAvailable();
                objectInputStream.close();
                objectOutputStream.close();
                inputStream.close();
                outputStream.close();
                socket2.close();
                if (!n8) {
                    if (n18 == 0) {
                        System.err.println("** [Error] Not enough hosts (found only " + n17 + ").");
                    } else {
                        System.err.println("** [Error] Not enough hosts (found only " + n17 + " nodes that can provide only " + n18 + " slots).");
                    }
                    System.err.println("**         You may try to search longer with -w option.");
                    System.exit(1);
                }
                if (!string4.equalsIgnoreCase("gather") && n17 < n16 + 1) {
                    System.out.println("** [Warning] Found only " + n17 + " host(s).");
                    System.out.println("**           Several processes will be executed on a same host.");
                }
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot connect to local MPD (127.0.0.1:" + mpdPort + ").");
                System.err.println("**         Make sure you have run \"mpiboot\"");
                System.exit(1);
            }
            System.out.println("Waiting reply from other nodes..");
            socket = null;
            serializable2 = null;
            boolean bl2 = false;
            URI[] uRIArray = new URI[n16];
            int[] nArray = new int[n16];
            try {
                serverSocket.setSoTimeout(120000);
            }
            catch (Exception socketTimeoutException) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            while (true) {
                try {
                    socket = serverSocket.accept();
                    inputStream = socket.getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    serializable2 = (MPDMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (SocketTimeoutException classNotFoundException) {
                    System.err.println("** [Error] No reply from at least one of the hosts.");
                    System.err.println("**         Check no firewall blocks port " + serverSocket.getLocalPort());
                    System.exit(1);
                }
                catch (IOException exception) {
                    continue;
                }
                catch (ClassNotFoundException exception) {
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                switch (((MPDMessage)serializable2).getCmd()) {
                    case 9: {
                        System.out.println("* got ACCEPT (FT " + ((MPDMessage)serializable2).getHost() + ":" + ((MPDMessage)serializable2).getFTPort() + ",key=" + ((MPDMessage)serializable2).getRank() + ")");
                        try {
                            uRIArray[var40_58] = new URI("tcp://" + ((MPDMessage)serializable2).getHost() + ":" + ((MPDMessage)serializable2).getFTPort());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nArray[var40_58] = ((MPDMessage)serializable2).getRank();
                        ++var40_58;
                        break;
                    }
                    default: {
                        System.out.println("Unknown command");
                    }
                }
                if (var40_58 >= n16) break;
            }
            Vector<Object> iOException2 = new Vector<Object>();
            if (string5 == null) {
                object = new String((String)vector.elementAt(0));
                stringArray4 = new File(System.getProperty("user.dir"), (String)object);
                object = new String(stringArray4.toString() + ".class");
                iOException2.addElement(object);
            } else {
                object = new File(string5);
                try {
                    String fTMessage;
                    stringArray4 = new BufferedReader(new FileReader((File)object));
                    while ((fTMessage = stringArray4.readLine()) != null) {
                        stringArray3 = new File(fTMessage);
                        if (!stringArray3.exists()) {
                            System.err.println("** [Error] File : " + fTMessage + " in " + string5 + " does not exist");
                            System.exit(1);
                        }
                        iOException2.addElement(fTMessage);
                    }
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Could not read file " + string5);
                    System.exit(1);
                }
            }
            int n19 = iOException2.size();
            stringArray4 = new String[n19];
            for (int i = 0; i < n19; ++i) {
                stringArray4[i] = new String((String)iOException2.elementAt(i));
            }
            FTMessage fTMessage = new FTMessage(4, myHash);
            fTMessage.setKeys(nArray);
            fTMessage.setURIs(uRIArray);
            fTMessage.setFileNames(stringArray4);
            fTMessage.setSize((int)var40_58);
            System.out.print("* Transfering files ... [ ");
            stringArray3 = fTMessage.getOnlyFileNameList();
            for (int n20 = 0; n20 < stringArray3.length; ++n20) {
                System.out.print(stringArray3[n20] + " ");
            }
            System.out.println("]");
            try {
                socket2 = new Socket("127.0.0.1", ftPort);
                outputStream = socket2.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(fTMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("* Waiting for processes to acknowledge file transfer ...");
            rankTable = new RankTable();
            rankTable.addProcess(0, cmdURI, ctrlURI, dataURI, fdPort);
            mapRankTable = new MapRankTable();
            mapRankTable.addMap(0, 0, 0);
            int n20 = 0;
            try {
                serverSocket.setSoTimeout((int)(var40_58 * 5000));
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            boolean bl3 = false;
            while (true) {
                try {
                    while (true) {
                        System.out.println("* Wait for SYN message ...");
                        socket = serverSocket.accept();
                        inputStream = socket.getInputStream();
                        objectInputStream = new ObjectInputStream(inputStream);
                        iOException = objectInputStream.readObject();
                        if (iOException instanceof MPIMessage) {
                            mPIMessage = (MPIMessage)iOException;
                            objectInputStream.close();
                            inputStream.close();
                            socket.close();
                            break;
                        }
                        if (!(iOException instanceof OutputMessage)) continue;
                        OutputMessage blArray = (OutputMessage)iOException;
                        System.out.println(">>>>" + blArray.getOutput());
                        objectInputStream.close();
                        inputStream.close();
                        socket.close();
                    }
                }
                catch (SocketTimeoutException classNotFoundException) {
                    System.err.println("** [Error] Not enough peers to form an execution platform.");
                    System.err.println("**         At least one of the requested hosts is behind a firewall.");
                    System.exit(1);
                }
                catch (IOException n22) {
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                if (mPIMessage.getCmd() != 11) continue;
                System.out.println("SYN:" + mPIMessage.getRank() + ":" + mPIMessage.getURI());
                rankTable.addProcess(mPIMessage.getRank(), mPIMessage.getURI(), mPIMessage.getCtrlURI(), mPIMessage.getDataURI(), mPIMessage.getFDPort());
                mapRankTable.addMap(mPIMessage.getRank(), mPIMessage.getRank(), ++n20);
                if (n20 >= var40_58) break;
            }
            bl3 = true;
            rankTable.setNumProcess(n);
            rankTable.setNumReplica(n15);
            System.out.println("* Check Receive all peers");
            if (!bl3) {
                iOException = new boolean[n];
                int n21 = rankTable.size();
                for (n7 = 0; n7 < n; ++n7) {
                    iOException[n7] = false;
                }
                for (n7 = 0; n7 < n21; ++n7) {
                    iOException[MPI.rankTable.getRank((int)n7)] = true;
                }
                for (n7 = 0; n7 < n; ++n7) {
                    if (iOException[n7] != false) continue;
                    System.err.println("*** Not enough peer to form an execution platform. ***");
                    System.exit(1);
                }
            }
            int n22 = rankTable.size();
            boolean[] blArray = new boolean[n];
            for (n7 = 0; n7 < n; ++n7) {
                blArray[n7] = false;
            }
            System.out.println("============================================");
            for (n7 = 0; n7 < n22; ++n7) {
                int n23 = rankTable.getRank(n7);
                if (!blArray[n23]) {
                    System.out.println("[Master of Rank " + n23 + "]: IP = " + rankTable.getCmdHost(n7));
                    blArray[n23] = true;
                    continue;
                }
                System.out.println("Rank " + n23 + ": IP = " + rankTable.getCmdHost(n7));
            }
            System.out.println("============================================");
            long l = System.currentTimeMillis();
            System.out.println("* Using protocol = " + string2);
            for (int i = 1; i < n22; ++i) {
                mPIMessage = new MPIMessage(12);
                mPIMessage.setCommTable(rankTable);
                mPIMessage.setRank(rankTable.getRank(i));
                mPIMessage.setRankInList(i);
                mPIMessage.setSize(n);
                mPIMessage.setTGossip(n2);
                mPIMessage.setTHang(n3);
                mPIMessage.setTMargin(t_sent * rankTable.size());
                mPIMessage.setGossipProtocol(string2);
                mPIMessage.setTDiff((int)(System.currentTimeMillis() - l));
                try {
                    System.out.println("* send SYN2: " + rankTable.getCmdHost(i) + ":" + rankTable.getCmdPort(i));
                    socket = new Socket(rankTable.getCmdHost(i), rankTable.getCmdPort(i));
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(mPIMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            myDevice.connect(0, 0, 0, rankTable, n, n15);
            myDevice.spawnMessageHandler(serverSocket, n, rankTable, myHash, mpdPort, fdPort, p2PMPI_ConfigFile.getTGossip(), t_sent * rankTable.size(), p2PMPI_ConfigFile.getTHang(), p2PMPI_ConfigFile.getGossipProtocol());
            Thread thread = new Thread(myDevice);
            thread.setDaemon(true);
            thread.start();
            COMM_WORLD = new IntraComm(myDevice, rankTable, 0, 0, n, mapRankTable);
            AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
            appRegisterMessage.setID(myHash + "--0");
            appRegisterMessage.setRunCmd(string);
            appRegisterMessage.setIPRank0(MPI.getLocalhostIP());
            appRegisterMessage.setRunDir(System.getProperty("user.dir"));
            appRegisterMessage.setRank(0);
            appRegisterMessage.setPort(n6);
            appRegisterMessage.setMPISize(n);
            appRegisterMessage.setRealSize(rankTable.size());
            appRegisterMessage.setRankTable(rankTable);
            try {
                socket = new Socket("127.0.0.1", mpdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appRegisterMessage);
                objectOutputStream.flush();
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                serializable = (PingReplyMessage)objectInputStream.readObject();
                objectInputStream.close();
                objectOutputStream.close();
                outputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Please make sure that MPD is running.");
                System.exit(1);
            }
            System.out.println("* Create an gossip instance.");
            serializable = new GossipMessage(0, myHash);
            ((GossipMessage)serializable).setMyRank(0);
            ((GossipMessage)serializable).setMPIRank(0);
            ((GossipMessage)serializable).setMPIPort(n6);
            ((GossipMessage)serializable).setURIList(rankTable.getFDURIs());
            ((GossipMessage)serializable).setTGossip(p2PMPI_ConfigFile.getTGossip());
            ((GossipMessage)serializable).setTHang(p2PMPI_ConfigFile.getTHang());
            ((GossipMessage)serializable).setTMargin(t_sent * rankTable.size());
            ((GossipMessage)serializable).setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
            ((GossipMessage)serializable).setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - l));
            try {
                socket = new Socket("127.0.0.1", fdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Fault Detection Service is not running");
                System.exit(1);
            }
            System.out.println("* Program is executing ...");
        } else {
            MPIClient mPIClient = new MPIClient(n4, n5);
            stringArray2 = new String[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = new String(stringArray[n]);
            }
        }
        RSMessage rSMessage = new RSMessage(7, myHash);
        try {
            socket = new Socket("127.0.0.1", rsPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(rSMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.err.println("** [Error] Reservation Service is not running");
            System.exit(1);
        }
        while (!myDevice.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        COMM_WORLD.Barrier();
        return stringArray2;
    }

    public static int Rand() {
        return mpiRandom.nextInt();
    }

    public static int Rand(int n) {
        return mpiRandom.nextInt(n);
    }

    public static void Finalize() {
        Serializable serializable;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        COMM_WORLD.Barrier();
        if (rankTable.size() == 1) {
            if (myDevice != null) {
                myDevice.shutdown();
            }
            try {
                AppUnregisterMessage appUnregisterMessage = new AppUnregisterMessage(myHash, myRank);
                socket = new Socket("127.0.0.1", mpdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appUnregisterMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.out.println("MPD Service is not running");
            }
            return;
        }
        if (myDevice.getRankInList() == 0) {
            myDevice.meTerminated();
            while (!myDevice.isAllTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            myDevice.finalizeConfirm();
        } else {
            myDevice.finalize(myDevice.getRankInList());
            while (!myDevice.isTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        try {
            serializable = new GossipMessage(2, myHash);
            int n = myDevice.getRankInList();
            serializable.setMyRank(n);
            socket = new Socket("127.0.0.1", fdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Fault Detection Service is not running");
        }
        try {
            serializable = new AppUnregisterMessage(myHash, myRank);
            socket = new Socket("127.0.0.1", mpdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("MPD Service is not running");
        }
        int n = myDevice.getUnexpectedQueueSize();
        if (n != 0) {
            System.err.println("** [rank " + myDevice.getRank() + "] Warning : there was " + n + " message(s) left in reception buffer. **");
        }
        if (myDevice != null) {
            myDevice.shutdown();
        }
    }

    public static double Wtime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double Wtick() {
        double d = 1.0E-4;
        double d2 = 0.0;
        if (d2 == 0.0) {
            d2 = System.currentTimeMillis();
            d2 = (double)System.currentTimeMillis() - d2;
            for (int i = 0; i < 10; ++i) {
                double d3 = System.currentTimeMillis();
                d3 = (double)System.currentTimeMillis() - d3;
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            d2 = d2 > 0.0 ? d2 : 1.0E-5;
        }
        return d2 / 1000.0;
    }

    public static String Get_processor_name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        myHash = null;
        myDevice = null;
        cmdURI = null;
        ctrlURI = null;
        dataURI = null;
        hostIP = null;
        t_sent = 1000;
        NULL = new Datatype(0);
        BYTE = new Datatype(1);
        CHAR = new Datatype(2);
        SHORT = new Datatype(3);
        BOOLEAN = new Datatype(4);
        INT = new Datatype(5);
        LONG = new Datatype(6);
        FLOAT = new Datatype(7);
        DOUBLE = new Datatype(8);
        PACKED = new Datatype(9);
        STRING = new Datatype(10);
        OBJECT = new Datatype(11);
        BYTE2 = BYTE.Contiguous(2);
        CHAR2 = CHAR.Contiguous(2);
        SHORT2 = SHORT.Contiguous(2);
        INT2 = INT.Contiguous(2);
        LONG2 = LONG.Contiguous(2);
        FLOAT2 = FLOAT.Contiguous(2);
        DOUBLE2 = DOUBLE.Contiguous(2);
        ANY_SOURCE = Tag.MPI_ANYSOURCE;
        ANY_TAG = Tag.MPI_ANYTAG;
        UNDEFINED = -3;
        UNEQUAL = 0;
        SIMILAR = 1;
        IDENT = 2;
        MAX = new Op(1);
        MIN = new Op(2);
        SUM = new Op(3);
        PROD = new Op(4);
        BAND = new Op(6);
        MAXLOC = new Op(12);
        MINLOC = new Op(11);
    }
}

