/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.Comm;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.Request;
import p2pmpi.mpi.dev.BinomialTree;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.ProcTree;

public class IntraComm
extends Comm {
    private int systemTAG = 100000;

    public IntraComm(Device device, RankTable rankTable, int n, int n2, int n3, MapRankTable mapRankTable) {
        super(device, rankTable, n, n2, n3, mapRankTable);
    }

    public IntraComm(Group group) {
        super(group);
    }

    public IntraComm Create(Group group) {
        IntraComm intraComm = new IntraComm(group);
        return intraComm;
    }

    private void BarrierFlatImpl() {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        byte[] byArray = new byte[1];
        if (this.Rank() == 0) {
            int n;
            for (n = 1; n < this.Size(); ++n) {
                this.Recv(byArray, 0, 1, MPI.BYTE, n, this.systemTAG);
            }
            for (n = 1; n < this.Size(); ++n) {
                this.Send(byArray, 0, 1, MPI.BYTE, n, this.systemTAG);
            }
        } else {
            this.Send(byArray, 0, 1, MPI.BYTE, 0, this.systemTAG);
            this.Recv(byArray, 0, 1, MPI.BYTE, 0, this.systemTAG);
        }
        ++this.systemTAG;
    }

    private void BarrierTreeImpl() {
        int n;
        ProcTree procTree = new ProcTree();
        procTree.buildTree(this.Rank(), this.Size());
        int n2 = 0;
        Datatype datatype = MPI.BYTE;
        byte[] byArray = new byte[1];
        int n3 = 1;
        if (procTree.isRoot) {
            for (n = 0; n < procTree.child.length; ++n) {
                if (procTree.child[n] == -1) continue;
                this.Recv(byArray, n2, n3, datatype, procTree.child[n], this.systemTAG - procTree.child[n]);
            }
        } else {
            if (procTree.parent == -1) {
                // empty if block
            }
            for (n = 0; n < procTree.child.length; ++n) {
                if (procTree.child[n] == -1) continue;
                this.Recv(byArray, n2, n3, datatype, procTree.child[n], this.systemTAG - procTree.child[n]);
            }
            this.Send(byArray, n2, n3, datatype, procTree.parent, this.systemTAG - this.Rank());
        }
        if (procTree.isRoot) {
            for (n = 0; n < procTree.child.length; ++n) {
                if (procTree.child[n] == -1) continue;
                this.Send(byArray, n2, n3, datatype, procTree.child[n], this.systemTAG - procTree.child[n]);
            }
        } else {
            if (procTree.parent == -1) {
                // empty if block
            }
            this.Recv(byArray, n2, n3, datatype, procTree.parent, this.systemTAG - this.Rank());
            for (n = 0; n < procTree.child.length; ++n) {
                if (procTree.child[n] == -1) continue;
                this.Send(byArray, n2, n3, datatype, procTree.child[n], this.systemTAG - procTree.child[n]);
            }
        }
    }

    public void Barrier() {
        this.BarrierTreeImpl();
    }

    public void Bcast(Object object, int n, int n2, Datatype datatype, int n3) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.BcastBinomial(object, n, n2, datatype, n3);
    }

    private void BcastBinomial(Object object, int n, int n2, Datatype datatype, int n3) {
        int n4;
        int n5 = this.Size();
        BinomialTree binomialTree = new BinomialTree(n5);
        int n6 = binomialTree.getMaxDegree();
        int[] nArray = new int[n6 + 1];
        Request[] requestArray = new Request[n6 + 1];
        int n7 = this.Rank() - n3;
        if (n7 < 0) {
            n7 += this.Size();
        }
        if ((n4 = binomialTree.getParentChildrenInverse(n7, nArray)) != -1) {
            n4 = (n4 + n3) % n5;
            this.Recv(object, n, n2, datatype, n4, this.systemTAG);
        }
        int n8 = 0;
        while (nArray[n8] != -1) {
            requestArray[n8] = this.Isend(object, n, n2, datatype, (nArray[n8] + n3) % n5, this.systemTAG);
            ++n8;
        }
        for (int i = 0; i < n8; ++i) {
            requestArray[i].Wait();
        }
        ++this.systemTAG;
    }

    public void Reduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        if (op.isCommute()) {
            this.ReduceBinomial(object, n, object2, n2, n3, datatype, op, n4);
        } else {
            this.ReduceFlat(object, n, object2, n2, n3, datatype, op, n4);
        }
    }

    private void ReduceBinomial(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        int n5 = this.Size();
        BinomialTree binomialTree = new BinomialTree(n5);
        int n6 = binomialTree.getMaxDegree();
        int[] nArray = new int[n6 + 1];
        int n7 = this.Rank() - n4;
        if (n7 < 0) {
            n7 += this.Size();
        }
        int n8 = binomialTree.getParentChildren(n7, nArray);
        int n9 = datatype.getBaseType();
        if (n8 != -1) {
            n8 = (n8 + n4) % this.Size();
        }
        int n10 = nArray.length;
        for (int i = 0; i < n10 && nArray[i] != -1; ++i) {
            nArray[i] = (nArray[i] + n4) % this.Size();
        }
        Object object3 = datatype.createArrayBuffer(n3);
        System.arraycopy(object, n, object3, 0, n3);
        int n11 = 0;
        while (nArray[n11] != -1) {
            this.Recv(object2, n2, n3, datatype, nArray[n11], this.systemTAG);
            op.Call(object2, n2, object3, 0, n3, datatype);
            ++n11;
        }
        if (n8 != -1) {
            this.Send(object3, 0, n3, datatype, n8, this.systemTAG);
        } else {
            System.arraycopy(object3, 0, object2, n2, n3);
        }
        ++this.systemTAG;
    }

    private void ReduceFlat(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        if (this.Rank() != n4) {
            this.Send(object, n, n3, datatype, n4, this.systemTAG);
        } else {
            Object object3 = datatype.createArrayBuffer(n3);
            for (int i = 0; i < this.Size(); ++i) {
                if (i != n4) {
                    this.Recv(object3, 0, n3, datatype, i, this.systemTAG);
                    op.Call(object3, 0, object2, n2, n3, datatype);
                    continue;
                }
                System.arraycopy(object, n, object3, 0, n3);
                op.Call(object3, 0, object2, n2, n3, datatype);
            }
        }
        ++this.systemTAG;
    }

    public void Allreduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        if (this.myDevice.isPower2()) {
            this.AllreduceButterfly(object, n, object2, n2, n3, datatype, op);
        } else {
            this.AllreduceSimple(object, n, object2, n2, n3, datatype, op);
        }
    }

    public void AllreduceSimple(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce(object, n, object2, n2, n3, datatype, op, 0);
        this.Bcast(object2, n2, n3, datatype, 0);
    }

    public void AllreduceButterfly(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        int n4 = this.Rank();
        int n5 = this.Size();
        Object object3 = datatype.createArrayBuffer(n3);
        System.arraycopy(object, n, object2, n2, n3);
        for (int i = 1; i < n5; i <<= 1) {
            int n6 = n4 ^ i;
            this.Sendrecv(object2, n2, n3, datatype, n6, this.systemTAG, object3, 0, n3, datatype, n6, this.systemTAG);
            op.Call(object3, 0, object2, n2, n3, datatype);
        }
        ++this.systemTAG;
    }

    public void Alltoallv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallvAsynRotate(object, n, nArray, nArray2, datatype, object2, n2, nArray3, nArray4, datatype2);
    }

    private void AlltoallvAsynRotate(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        int n3;
        int n4;
        int n5 = this.Rank();
        int n6 = this.Size();
        int n7 = this.Size() - 1;
        Request[] requestArray = new Request[n7];
        Request[] requestArray2 = new Request[n7];
        for (n4 = 1; n4 < n6; ++n4) {
            int n8 = (n5 + n4) % n6;
            requestArray[n4 - 1] = this.Isend(object, n + nArray2[n8], nArray[n8], datatype, n8, this.systemTAG);
        }
        for (n3 = 1; n3 < n6; ++n3) {
            n4 = (n6 + (n5 - n3)) % n6;
            requestArray2[n3 - 1] = this.Irecv(object2, n2 + nArray4[n4], nArray3[n4], datatype2, n4, this.systemTAG);
        }
        System.arraycopy(object, n + nArray2[n5], object2, n2 + nArray4[n5], nArray3[n5]);
        for (n3 = 0; n3 < n7; ++n3) {
            requestArray[n3].Wait();
            requestArray2[n3].Wait();
        }
    }

    public void Alltoall(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallAsynRotate(object, n, n2, datatype, object2, n3, n4, datatype2);
        ++this.systemTAG;
    }

    private void AlltoallAsynRotate(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5;
        int n6;
        int n7 = this.Rank();
        int n8 = this.Size();
        int n9 = this.Size() - 1;
        Request[] requestArray = new Request[n9];
        Request[] requestArray2 = new Request[n9];
        for (n6 = 1; n6 < n8; ++n6) {
            int n10 = (n7 + n6) % n8;
            int n11 = n10 * n2;
            requestArray[n6 - 1] = this.Isend(object, n + n11, n2, datatype, n10, this.systemTAG);
        }
        for (n5 = 1; n5 < n8; ++n5) {
            n6 = (n8 + (n7 - n5)) % n8;
            int n12 = n6 * n4;
            this.Recv(object2, n3 + n12, n4, datatype2, n6, this.systemTAG);
        }
        System.arraycopy(object, n + n7 * n2, object2, n3 + n7 * n4, n4);
        for (n5 = 0; n5 < n9; ++n5) {
            requestArray[n5].Wait();
        }
    }

    public void Gather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GatherFlatTree(object, n, n2, datatype, object2, n3, n4, datatype2, n5);
    }

    private void GatherFlatTree(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        Request[] requestArray = new Request[this.Size() - 1];
        int n6 = 0;
        if (this.Rank() == n5) {
            int n7;
            for (n7 = 0; n7 < this.Size(); ++n7) {
                if (n7 != n5) {
                    requestArray[n6] = this.Irecv(object2, n3 + n7 * n4, n4, datatype2, n7, this.systemTAG);
                    ++n6;
                    continue;
                }
                System.arraycopy(object, n, object2, n3 + n5 * n4, n4);
            }
            for (n7 = 0; n7 < n6; ++n7) {
                requestArray[n7].Wait();
            }
        } else {
            this.Send(object, n, n2, datatype, n5, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Gatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GathervFlatTree(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2, n4);
    }

    private void GathervFlatTree(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2, int n4) {
        Request[] requestArray = new Request[this.Size() - 1];
        int n5 = 0;
        if (this.Rank() == n4) {
            int n6;
            for (n6 = 0; n6 < this.Size(); ++n6) {
                if (n6 != n4) {
                    requestArray[n5] = this.Irecv(object2, n3 + nArray2[n6], nArray[n6], datatype2, n6, this.systemTAG);
                    ++n5;
                    continue;
                }
                System.arraycopy(object, n, object2, n3 + nArray2[n6], nArray[n6]);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                requestArray[n6].Wait();
            }
        } else {
            this.Send(object, n, n2, datatype, n4, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Allgather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGatherSimple(object, n, n2, datatype, object2, n3, n4, datatype2);
    }

    private void AllGatherSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        this.Gather(object, n, n2, datatype, object2, n3, n4, datatype2, 0);
        this.Bcast(object2, n3, n4 * this.Size(), datatype2, 0);
    }

    public void Allgatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGathervSimple(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2);
    }

    private void AllGathervSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2) {
        this.Gatherv(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2, 0);
        int n4 = nArray2[nArray2.length - 1] + nArray[nArray.length - 1];
        this.Bcast(object2, n3, n4, datatype2, 0);
    }

    public void Scatter(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScatterSimple(object, n, n2, datatype, object2, n3, n4, datatype2, n5);
    }

    private void ScatterSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        int n6 = this.Size();
        Request[] requestArray = new Request[n6 - 1];
        int n7 = 0;
        if (this.Rank() == n5) {
            int n8;
            for (n8 = 0; n8 < n6; ++n8) {
                if (n8 != n5) {
                    requestArray[n7] = this.Isend(object, n + n8 * n2, n2, datatype, n8, this.systemTAG);
                    ++n7;
                    continue;
                }
                System.arraycopy(object, n + n8 * n2, object2, n3, n4);
            }
            for (n8 = 0; n8 < n7; ++n8) {
                requestArray[n8].Wait();
            }
        } else {
            this.Recv(object2, n3, n4, datatype2, n5, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Scatterv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int n3, Datatype datatype2, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScattervSimple(object, n, nArray, nArray2, datatype, object2, n2, n3, datatype2, n4);
    }

    private void ScattervSimple(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int n3, Datatype datatype2, int n4) {
        int n5 = this.Size();
        Request[] requestArray = new Request[n5 - 1];
        int n6 = 0;
        if (this.Rank() == n4) {
            int n7;
            for (n7 = 0; n7 < n5; ++n7) {
                if (n7 != n4) {
                    requestArray[n6] = this.Isend(object, n + nArray2[n7], nArray[n7], datatype, n7, this.systemTAG);
                    ++n6;
                    continue;
                }
                System.arraycopy(object, n + nArray2[n7], object2, n2, n3);
            }
            for (n7 = 0; n7 < n6; ++n7) {
                requestArray[n7].Wait();
            }
        } else {
            this.Recv(object2, n2, n3, datatype2, n4, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Reduce_scatter(Object object, int n, Object object2, int n2, int[] nArray, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce_scatterSimple(object, n, object2, n2, nArray, datatype, op);
    }

    private void Reduce_scatterSimple(Object object, int n, Object object2, int n2, int[] nArray, Datatype datatype, Op op) {
        int n3 = this.Size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 += nArray[i];
        }
        int[] nArray2 = new int[n3];
        nArray2[0] = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            nArray2[i + 1] = nArray2[i] + nArray[i];
        }
        Object object3 = datatype.createArrayBuffer(n4);
        this.Reduce(object, 0, object3, 0, n4, datatype, op, 0);
        this.Scatterv(object3, 0, nArray, nArray2, datatype, object2, 0, nArray[this.Rank()], datatype, 0);
    }

    public void Scan(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == 0) {
            System.arraycopy(object, n, object2, n2, n3);
        } else {
            this.Recv(object2, n2, n3, datatype, this.Rank() - 1, this.systemTAG);
            op.Call(object, n, object2, n2, n3, datatype);
        }
        if (this.Rank() < this.Size() - 1) {
            this.Send(object2, n2, n3, datatype, this.Rank() + 1, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public IntraComm Split(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = this.Size();
        int[] nArray = new int[]{n4, n5};
        int[] nArray2 = new int[2 * n6];
        this.Allgather(nArray, 0, 2, MPI.INT, nArray2, 0, 2, MPI.INT);
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < n6; ++i) {
            if (nArray2[2 * i] != n4) continue;
            int[] nArray3 = new int[]{nArray2[2 * i + 1], i};
            vector.add(nArray3);
        }
        Vector<int[]> vector2 = new Vector<int[]>();
        int n7 = vector.size();
        while (n7 != 0) {
            int[] nArray4 = (int[])vector.elementAt(0);
            int n8 = 0;
            for (n3 = 1; n3 < n7; ++n3) {
                if (nArray4[0] <= ((int[])vector.elementAt(n3))[0]) continue;
                n8 = n3;
                nArray4 = (int[])vector.elementAt(n3);
            }
            vector2.add(nArray4);
            vector.remove(n8);
            n7 = vector.size();
        }
        int n9 = vector2.size();
        int[] nArray5 = new int[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            nArray5[n3] = ((int[])vector2.elementAt(n3))[1];
        }
        Group group = this.Group().Incl(nArray5);
        return this.Create(group);
    }
}

