/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Request;
import p2pmpi.mpi.Status;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.NIORequest;

public class Comm {
    private static short globalCommID = 0;
    protected Device myDevice;
    protected short commID;
    protected Group myGroup;
    protected MapRankTable mapRankTable;
    protected HashMap<String, Integer> midLog = new HashMap();
    private int numReplica;
    private int[] myReplica;
    private int[] myReplicaRIL;
    private static int MAX_REPLICA = 256;
    private int numProc;
    private int waitingTime;

    public Comm(Device device, RankTable rankTable, int n, int n2, int n3, MapRankTable mapRankTable) {
        int n4;
        int n5;
        int n6;
        this.myDevice = device;
        this.myGroup = new Group(device, rankTable, n, n2, n3, mapRankTable);
        this.commID = globalCommID;
        globalCommID = (short)(globalCommID + 1);
        this.myReplica = new int[MAX_REPLICA];
        RankTable rankTable2 = this.myGroup.__getCommTable();
        MapRankTable mapRankTable2 = this.myGroup.__getMapCommTable();
        this.numProc = mapRankTable2.size();
        int n7 = this.myGroup.Rank();
        for (n6 = 0; n6 < this.numProc; ++n6) {
            n5 = mapRankTable2.getRankInList(n6);
            if (!rankTable2.isAlive(n5) || n7 != mapRankTable2.getCurrentRank(n6)) continue;
            this.myReplica[this.numReplica] = n6;
            ++this.numReplica;
        }
        n6 = this.myGroup.RankInList();
        n5 = 1;
        int n8 = n6;
        for (int i = 0; i < this.numReplica; ++i) {
            n4 = mapRankTable2.getRankInList(this.myReplica[i]);
            if (!rankTable2.isAlive(n4)) continue;
            if (n6 > this.myReplica[i]) {
                n5 = 0;
            }
            if (n8 <= this.myReplica[i]) continue;
            n8 = this.myReplica[i];
        }
        device.setMaster(n5 != 0);
        device.setMyMaster(n8);
        String string = device.getGossipProtocol();
        this.waitingTime = string.equalsIgnoreCase("DBRR") ? (int)(Math.log(this.numProc) / Math.log(2.0)) * 3 * device.getTGossip() * 2 + device.getTMargin() : (int)(Math.log(this.numProc) / Math.log(2.0)) * 2 * device.getTGossip() * 2 + device.getTMargin();
        this.myReplicaRIL = new int[this.myReplica.length];
        for (int i = 0; i < this.numReplica; ++i) {
            n4 = this.myReplica[i];
            this.myReplicaRIL[i] = mapRankTable2.getRankInList(this.myReplica[i]);
        }
        device.registerMap(this.commID, this.myGroup.__getMapCommTable());
        device.registerCOMMWORLD(rankTable);
    }

    public Comm(Group group) {
        int n;
        int n2;
        int n3;
        this.myGroup = group;
        this.myDevice = group.__getDevice();
        this.commID = globalCommID;
        globalCommID = (short)(globalCommID + 1);
        this.myReplica = new int[MAX_REPLICA];
        RankTable rankTable = this.myGroup.__getCommTable();
        MapRankTable mapRankTable = this.myGroup.__getMapCommTable();
        this.numProc = mapRankTable.size();
        int n4 = this.myGroup.Rank();
        for (n3 = 0; n3 < this.numProc; ++n3) {
            n2 = mapRankTable.getRankInList(n3);
            if (!rankTable.isAlive(n2) || n4 != mapRankTable.getCurrentRank(n3)) continue;
            this.myReplica[this.numReplica] = n3;
            ++this.numReplica;
        }
        n3 = this.myGroup.RankInList();
        n2 = 1;
        int n5 = n3;
        for (int i = 0; i < this.numReplica; ++i) {
            n = mapRankTable.getRankInList(this.myReplica[i]);
            if (!rankTable.isAlive(n)) continue;
            if (n3 > this.myReplica[i]) {
                n2 = 0;
            }
            if (n5 <= this.myReplica[i]) continue;
            n5 = this.myReplica[i];
        }
        this.myDevice.setMaster(n2 != 0);
        this.myDevice.setMyMaster(n5);
        String string = this.myDevice.getGossipProtocol();
        this.waitingTime = string.equalsIgnoreCase("DBRR") ? (int)(Math.log(this.numProc) / Math.log(2.0)) * 3 * this.myDevice.getTGossip() * 2 + this.myDevice.getTMargin() : (int)(Math.log(this.numProc) / Math.log(2.0)) * 2 * this.myDevice.getTGossip() * 2 + this.myDevice.getTMargin();
        this.myReplicaRIL = new int[this.myReplica.length];
        for (int i = 0; i < this.numReplica; ++i) {
            n = this.myReplica[i];
            this.myReplicaRIL[i] = mapRankTable.getRankInList(this.myReplica[i]);
        }
        this.myDevice.registerMap(this.commID, this.myGroup.__getMapCommTable());
    }

    public Group Group() {
        return this.myGroup;
    }

    public int Size() {
        return this.myGroup.Size();
    }

    public int SizeTotal() {
        return this.myGroup.__sizetotal();
    }

    public int Rank() {
        return this.myGroup.Rank();
    }

    public int Ssend(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return -1;
        }
        if (datatype.getBaseType() == 0) {
            return 0;
        }
        int n5 = this.increaseAndGetNumSend(this.Rank(), n3, n4);
        ByteBuffer byteBuffer = datatype.getByteBuffer(object, n, n2, this.commID, this.Rank(), n3, n4, n5);
        RankTable rankTable = this.myGroup.__getCommTable();
        MapRankTable mapRankTable = this.myGroup.__getMapCommTable();
        Vector<Integer> vector = mapRankTable.getRankInListByCurrentRank(n3);
        if (this.myDevice.isMaster()) {
            this.myDevice.ssend(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL);
        } else {
            this.myDevice.sendToBackup(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL);
        }
        return n2;
    }

    public int Send(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return -1;
        }
        if (datatype.getBaseType() == 0) {
            return 0;
        }
        int n5 = this.increaseAndGetNumSend(this.Rank(), n3, n4);
        ByteBuffer byteBuffer = datatype.getByteBuffer(object, n, n2, this.commID, this.Rank(), n3, n4, n5);
        RankTable rankTable = this.myGroup.__getCommTable();
        MapRankTable mapRankTable = this.myGroup.__getMapCommTable();
        Vector<Integer> vector = mapRankTable.getRankInListByCurrentRank(n3);
        if (this.myDevice.isMaster()) {
            this.myDevice.send(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL);
        } else {
            this.myDevice.sendToBackup(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL);
        }
        return n2;
    }

    public Request Isend(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        NIORequest nIORequest = null;
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int n5 = this.increaseAndGetNumSend(this.Rank(), n3, n4);
        ByteBuffer byteBuffer = datatype.getByteBuffer(object, n, n2, this.commID, this.Rank(), n3, n4, n5);
        RankTable rankTable = this.myGroup.__getCommTable();
        MapRankTable mapRankTable = this.myGroup.__getMapCommTable();
        Vector<Integer> vector = mapRankTable.getRankInListByCurrentRank(n3);
        nIORequest = this.myDevice.isMaster() ? this.myDevice.isend(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL) : this.myDevice.sendToBackup(rankTable, byteBuffer, vector, this.commID, this.Rank(), n3, n4, n5, this.myReplicaRIL);
        return new Request(nIORequest);
    }

    public Status Sendrecv(Object object, int n, int n2, Datatype datatype, int n3, int n4, Object object2, int n5, int n6, Datatype datatype2, int n7, int n8) {
        Request request = this.Irecv(object2, n5, n6, datatype2, n7, n8);
        this.Send(object, n, n2, datatype, n3, n4);
        return request.Wait();
    }

    public Status Recv(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int n5 = this.increaseAndGetNumSend(n3, this.Rank(), n4);
        IStatus iStatus = this.myDevice.recv(object, n, n2, this.commID, n3, this.Rank(), n4, n5, datatype.getBuffer());
        return new Status(iStatus);
    }

    public Request Irecv(Object object, int n, int n2, Datatype datatype, int n3, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return null;
        }
        if (datatype.getBaseType() == 0) {
            return null;
        }
        int n5 = this.increaseAndGetNumSend(n3, this.Rank(), n4);
        NIORequest nIORequest = this.myDevice.irecv(object, n, n2, this.commID, n3, this.Rank(), n4, n5, datatype.getBuffer());
        Request request = new Request(nIORequest);
        return request;
    }

    private synchronized int increaseAndGetNumSend(int n, int n2, int n3) {
        int n4;
        String string = n + "_" + n2 + "_" + n3;
        Integer n5 = this.midLog.get(string);
        if (n5 == null) {
            n4 = 0;
            this.midLog.put(string, new Integer(1));
        } else {
            n4 = n5;
            this.midLog.put(string, new Integer(n4 + 1));
        }
        return n4;
    }
}

