/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;
import java.net.URI;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankTable
implements Serializable {
    private static final long serialVersionUID = 1000004L;
    Vector<TableInfo> table = new Vector();
    int numProcess;
    int numReplica;

    public void addProcess(int n, URI uRI, URI uRI2, URI uRI3, int n2) {
        TableInfo tableInfo = new TableInfo(n, uRI, uRI2, uRI3, true, n2);
        this.table.addElement(tableInfo);
    }

    public void setNumProcess(int n) {
        this.numProcess = n;
    }

    public void setNumReplica(int n) {
        this.numReplica = n;
    }

    public int getNumProcess() {
        return this.numProcess;
    }

    public int getNumReplica() {
        return this.numReplica;
    }

    public int size() {
        return this.table.size();
    }

    public URI getDataURI(int n) {
        return this.table.elementAt(n).getDataURI();
    }

    public String getCmdHost(int n) {
        return this.table.elementAt(n).getCmdURI().getHost();
    }

    public int getCmdPort(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return this.table.elementAt(n).getCmdURI().getPort();
    }

    public URI getCmdURI(int n) {
        return this.table.elementAt(n).getCmdURI();
    }

    public URI getCtrlURI(int n) {
        return this.table.elementAt(n).getCtrlURI();
    }

    public String getCtrlHost(int n) {
        return this.table.elementAt(n).getCtrlURI().getHost();
    }

    public int getCtrlPort(int n) {
        return this.table.elementAt(n).getCtrlURI().getPort();
    }

    public String getDataHost(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getDataURI().getHost();
    }

    public int getDataPort(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getDataURI().getPort();
    }

    public int getFDPort(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getFDPort();
    }

    public int getRank(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getRank();
    }

    public boolean isAlive(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.isAlive();
    }

    public boolean isTerminated(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.isTerminated();
    }

    public void setAlive(int n, boolean bl) {
        TableInfo tableInfo = this.table.elementAt(n);
        tableInfo.setAlive(bl);
    }

    public void setTerminated(int n, boolean bl) {
        TableInfo tableInfo = this.table.elementAt(n);
        tableInfo.setTerminated(bl);
    }

    public URI[] getURIs() {
        int n = this.size();
        URI[] uRIArray = new URI[n];
        for (int i = 0; i < n; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            try {
                uRIArray[i] = new URI(tableInfo.getCmdURI().toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRIArray;
    }

    public URI[] getFDURIs() {
        int n = this.size();
        URI[] uRIArray = new URI[n];
        for (int i = 0; i < n; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            try {
                uRIArray[i] = new URI(tableInfo.getFDURI().toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRIArray;
    }

    public Vector<Integer> getRankInListByRank(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            if (tableInfo.getRank() != n || !tableInfo.isAlive()) continue;
            Integer n3 = new Integer(i);
            vector.addElement(n3);
        }
        return vector;
    }

    public int getRankInReplica(URI uRI, int n) {
        int n2 = this.size();
        int n3 = 0;
        TableInfo tableInfo = this.table.elementAt(n);
        int n4 = tableInfo.getRank();
        for (int i = 0; i < n2; ++i) {
            tableInfo = this.table.elementAt(i);
            if (tableInfo.getRank() != n4) continue;
            if (tableInfo.getDataURI().toString().equals(uRI.toString())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Vector<URI> getURIByRank(int n) {
        Vector<URI> vector = new Vector<URI>();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            if (tableInfo.getRank() != n || !tableInfo.isAlive()) continue;
            vector.addElement(tableInfo.getCmdURI());
        }
        return vector;
    }

    public class TableInfo
    implements Serializable {
        private static final long serialVersionUID = 1000006L;
        int rank;
        URI cmdURI;
        URI ctrlURI;
        URI dataURI;
        boolean alive;
        int fdPort;
        boolean terminated;

        public TableInfo(int n, URI uRI, URI uRI2, URI uRI3, boolean bl, int n2) {
            this.rank = n;
            this.cmdURI = uRI;
            this.ctrlURI = uRI2;
            this.dataURI = uRI3;
            this.alive = bl;
            this.terminated = false;
            this.fdPort = n2;
        }

        public void setAlive(boolean bl) {
            this.alive = bl;
        }

        public void setTerminated(boolean bl) {
            this.terminated = bl;
        }

        public void setFDPort(int n) {
            this.fdPort = n;
        }

        public int getFDPort() {
            return this.fdPort;
        }

        public URI getFDURI() {
            URI uRI = null;
            try {
                uRI = new URI("tcp://" + this.cmdURI.getHost() + ":" + this.fdPort);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return uRI;
        }

        public boolean isAlive() {
            return this.alive;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public URI getCmdURI() {
            return this.cmdURI;
        }

        public URI getDataURI() {
            return this.dataURI;
        }

        public URI getCtrlURI() {
            return this.ctrlURI;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

