package p2pmpi.tools;
import p2pmpi.common.*;

public class MPIArgs {

	public static void main(String[] args)
	{
	 	int c;
		int numProc = -1;
		int numRep  = 1;
		int waitTime = -1;
       	 	String filelist = null;
		String allocationMode = null;
  		//boolean interactive = true;

 		//Getopt g = new Getopt("P2P-MPI", args, "n:r:l:o");
 		Getopt g = new Getopt("P2P-MPI", args, "w:n:r:l:a:");
	 	g.setOpterr(false); //manual error handle

		String arg;
 		while ((c = g.getopt()) != -1) {
   			switch (c) {
        			case 'n':
					arg = g.getOptarg();
					numProc = Integer.parseInt(arg);
          			break;
        			case 'r':
					arg = g.getOptarg();
					numRep = Integer.parseInt(arg);
				break;
				case 'w' :
					arg = g.getOptarg();
					waitTime = Integer.parseInt(arg);
				break;
				case 'l':
					arg = g.getOptarg();
					filelist = new String(arg);
				break;
				case 'a' :
					arg = g.getOptarg();
					allocationMode = new String(arg);
				break;
				/*
				case 'o' :
					interactive = false;
				break;
				*/
     			}
		}
		String runCmd = "";
		boolean once = true;
 		for (int i = g.getOptind(); i < args.length ; i++) {
			if(once) {
				runCmd += args[i];
				runCmd += " ";
				once = false;
			}
			runCmd += args[i];
			runCmd += " ";
		}
		runCmd = runCmd + "-n " + numProc + " -r " + numRep;
		if(waitTime != -1) {
			runCmd = runCmd + " -w " + waitTime;
		}
	        if(filelist != null) {
			runCmd = runCmd + " -l " + filelist;
		}
		if(allocationMode != null) {
			runCmd = runCmd + " -a " + allocationMode;
		} else {
			runCmd = runCmd + " -a spread";
		}
		/*
		if(!interactive) {
			runCmd += " -o ";
		}
		*/
		System.out.println(runCmd);
	}
} 


