import p2pmpi.mpi.*;
import java.lang.Math;

public class MpiCommTest {
	public static void main(String[] args) {
		int[] BUF_SIZE = new int[11];
		BUF_SIZE[0] = 1024;
		BUF_SIZE[1] = 2048;
		BUF_SIZE[2] = 4096;
		BUF_SIZE[3] = 8192;
		BUF_SIZE[4] = 16384;	
		BUF_SIZE[5] = 32768;
		BUF_SIZE[6] = 65536;	
		BUF_SIZE[7] = 131072;	
		BUF_SIZE[8] = 262144;
		BUF_SIZE[9] = 524288;	
		BUF_SIZE[10] = 1048576;


		MPI.Init(args);
		int myRank = MPI.COMM_WORLD.Rank();
		int size   = MPI.COMM_WORLD.Size();

		for(int x = 0; x < BUF_SIZE.length; x++) {
			byte[] sendBuf = new byte[BUF_SIZE[x]];
			byte[] recvBuf = new byte[BUF_SIZE[x]];
			if(myRank == 0) {
				long start = System.currentTimeMillis();
				MPI.COMM_WORLD.Send(sendBuf, 0, BUF_SIZE[x], MPI.BYTE, 1, 2);
				MPI.COMM_WORLD.Recv(recvBuf, 0, BUF_SIZE[x], MPI.BYTE, 1, 2);
				long stop = System.currentTimeMillis();
				double timeusage = stop-start;
				System.out.println("=============Loop " + x + "==========");
				double datatransfer = (BUF_SIZE[x]*2);
				double throughput = (datatransfer*1000)/timeusage; //B/s
				System.out.println("For Data = " + datatransfer + "B");
				System.out.println("Time Usage = " + timeusage + "ms");
				System.out.println("ThroughPut = " + throughput + "  B/s");
				System.out.println("ThroughPut = " + (throughput/1024) + "  kB/s");
				System.out.println("ThroughPut = " + (throughput/1048576) + "  MB/s");
				System.out.println("======================================");
			} else {
				MPI.COMM_WORLD.Recv(recvBuf, 0, BUF_SIZE[x], MPI.BYTE, 0, 2);
				MPI.COMM_WORLD.Send(recvBuf, 0, BUF_SIZE[x], MPI.BYTE, 0, 2);
			}
		}

		MPI.Finalize();	
	}
}
