package p2pmpi.mpi.internal;

import p2pmpi.mpi.*;
import p2pmpi.message.*;
import p2pmpi.common.*;
import java.net.*;
import java.io.*;
import java.util.*;

/**
 * Asynchronous message handler for handling all received messages
 */
public class MessageHandler implements Runnable 
{
	private String key;
	//private int port;				// MPI Port
	private boolean ready;				// Ready Flag
	private boolean terminated;			// Terminated Flag
	private ServerSocket servSocket = null;
	private RankTable rankTable;			// Communication Table
	private int myRank;				// Rank in MPI
	private int myRankInList;			// Rank in Com Table
	private int commSize;				// Number of MPI Rank
	private int mpdPort;
	private int fdPort;
	private Vector<RecvBufferInformation>  messageBuffer;	// Receive Part
	private MessageIDLog recvLog;	// to compare duplicate message

	private Vector<SendBufferInformation> backupBuffer;	// Send Part
	private MessageIDLog sendLog;  	// backup log

	private int myMaster;		// Master Rank of this replica
	private boolean master;		// True if this process is a master of replica

	private int t_gossip; 		// time for each gossip
	private String gossipProtocol;	// gossip protocol
	private int t_margin;		// margin time because starting counting heartbeat
	private int t_diff;		// different time of rank 0 and this rank receive rank table
	private int t_hang;

	private volatile boolean shutdown = false;

	private boolean rankZero;
	/*
	public MessageHandler(int port, RankTable rankTable, String key) {
		this.key	= key;
		this.port	= port;
		this.rankTable	= rankTable;
		this.ready 	= false;
		messageBuffer = new Vector();
		recvLog = new MessageIDLog();
		shutdown = false;

		try {
			servSocket = new ServerSocket(port);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}
	*/

	/**
	 * Internal use
	 */
	public MessageHandler(ServerSocket servSocket, int commSize, RankTable rankTable, String key, int mpdPort, int fdPort) {
		this.commSize	= commSize;
		this.key	= key;
		this.rankTable	= rankTable;
		this.ready 	= false;
		this.terminated = false;
		this.rankZero	= true;
		this.mpdPort	= mpdPort;
		this.fdPort	= fdPort;
		messageBuffer = new Vector<RecvBufferInformation>();
		recvLog = new MessageIDLog();
		shutdown = false;

		this.servSocket = servSocket;
		try {
			this.servSocket.setSoTimeout(0);
		} catch (Exception e) {
			//e.printStackTrace();
		}
		/*
		try {
			servSocket = new ServerSocket(port);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
		*/
	}



	/*
	public MessageHandler(int port, String key) {
		this.key	= key;
		this.port	= port;
		this.ready 	= false;
		messageBuffer = new Vector();
		recvLog = new MessageIDLog();
		shutdown = false;

		servSocket = null;
		for(int i = 0; i < 3; i++) {
			try {
				servSocket = new ServerSocket(port);
				break;
			} catch (Exception e) {
				System.out.println("Try to open Port" + port + " but failed");
				e.printStackTrace();
				continue;
			}
		}
		if (servSocket == null) {
			System.out.println("Can't bind port to socket..EXIT NOW");
			System.exit(-1);
		}
	}
	*/

	/**
	 * Internal use
	 */
	public MessageHandler(ServerSocket servSocket, String key, int mpdPort, int fdPort) {
		this.key	= key;
		this.ready 	= false;
		this.mpdPort	= mpdPort;
		this.fdPort	= fdPort;
		messageBuffer = new Vector<RecvBufferInformation>();
		recvLog = new MessageIDLog();
		shutdown = false;
		this.rankZero	= false;

		this.servSocket = servSocket;
		try  {
			this.servSocket.setSoTimeout(0);
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}

	public void cleanupProcess() {
		 //Unregister FD Service
		Socket conn = null;
		OutputStream os = null;
		ObjectOutputStream oos = null;
                try {
	                GossipMessage gossipMsg = new GossipMessage(MessageCmd.GOSSIP_UNREGISTER, key);
			int rankInList = getRankInList();
                        gossipMsg.setMyRank(rankInList);
                        conn = new Socket("127.0.0.1", fdPort);
                        os = conn.getOutputStream();
                        oos = new ObjectOutputStream(os);
                        oos.writeObject(gossipMsg);
                        oos.flush();
                        oos.close();
                        os.close();
                        conn.close();
                } catch (Exception e) {
                        System.out.println("Fault Detection Service is not running");
                }

                // Unregister to MPD
                try {
                        //System.out.println("Finalize HashKey = " + myHash);
                        AppUnregisterMessage unRegMsg = new AppUnregisterMessage(key, myRank);
                        conn = new Socket("127.0.0.1", mpdPort);
                        os = conn.getOutputStream();
                        oos = new ObjectOutputStream(os);
                        oos.writeObject(unRegMsg);
                        oos.flush();
                        oos.close();
                        os.close();
                        conn.close();
                } catch (Exception e) {
                        System.out.println("MPD Service is not running");
                        //e.printStackTrace();
                }

	}


	public void shutdown() {
		shutdown = true;
		try {
			if(servSocket != null) {
				servSocket.close();
			}
		} catch (Exception e) {}
	}

	public boolean isMaster() {
		return master;
	}

	public void setMaster(boolean master) {
		this.master = master;
	}

	public void setMyMaster(int rankInList) {
		this.myMaster = rankInList;
	}

	public void setSendBackupAndLog(Vector<SendBufferInformation> backupBuffer, MessageIDLog sendLog) {
		this.backupBuffer = backupBuffer;
		this.sendLog	  = sendLog;
	}

	public void setRankTable(RankTable rankTable) {
		this.rankTable = rankTable;
	}

	public void setTHang(int t_hang) {
		this.t_hang = t_hang;
	}

	public int getTHang() {
		return t_hang;
	}

	public RankTable getRankTable() {
		return rankTable;
	}

	public void run() {
		Socket socket = null;
		InputStream in = null;
		ObjectInputStream ois = null;
		Object msg = null;
		RecvBufferInformation buff = null;
		String mid;

		//Set Timeout to wait for ranktable from rank 0
		if(!rankZero) {
			try {
				servSocket.setSoTimeout(600000); //timeout 10 minutes
			} catch (Exception e) {
				//e.printStackTrace();
			}
		}

		//servSocket.setSoTimeout(600000);
		while(!shutdown) {
			try {
				socket = servSocket.accept();
			} catch (SocketTimeoutException soe) {
				//No syn message from peers
				//System.out.println(" Oooh ... tell me what others are doing, rank 0 !");
				//soe.printStackTrace();
				System.exit(1);
			} catch (IOException e) {
				continue;
			}

			try {
				in = socket.getInputStream();
				ois = new ObjectInputStream(in);
				msg = ois.readObject();
			} catch (Exception e) {
				try {
					ois.close();
					in.close();
					socket.close();
				} catch (Exception ee) { 
					//ee.printStackTrace();
				}
				//e.printStackTrace();
				continue;
			}

			if(msg instanceof MPIMessage) {
				MPIMessage mpiMsg = (MPIMessage)msg;
				switch(mpiMsg.getCmd()) {
					case MessageCmd.MPI_SYN2 :
						ready = true;
						myRank = mpiMsg.getRank();
						myRankInList = mpiMsg.getRankInList();
						commSize = mpiMsg.getSize();
						setRankTable(mpiMsg.getCommTable());
						t_gossip = mpiMsg.getTGossip();
						t_margin = mpiMsg.getTMargin();
						t_hang   = mpiMsg.getTHang();
						t_diff   = mpiMsg.getTDiff();
						gossipProtocol = mpiMsg.getGossipProtocol();
						try {
							servSocket.setSoTimeout(0);
						} catch (Exception e) {
							//e.printStackTrace();
						}
					break;
				}

			} else if(msg instanceof DataMessage) {
				DataMessage dataMsg = (DataMessage)msg;
				mid = dataMsg.getMID();
				if(recvLog.isExist(mid) == -1) {
					// If message ID is not exist
					// Put it in Buffer 
					buff = new RecvBufferInformation(dataMsg.getMID(),
								     dataMsg.getFromRank(), 
								     dataMsg.getToRank(),
								     dataMsg.getData(),
								     dataMsg.getTag()
								    );
					synchronized (messageBuffer) {
						messageBuffer.addElement(buff);
					}
					synchronized (recvLog) {
						recvLog.add(mid);
					}
				} 
			} else if(msg instanceof UpdateStatusMessage) {
				// Compare with sendLog and backupMessage
				UpdateStatusMessage updateMsg = (UpdateStatusMessage)msg;
				/*System.out.println("================================================");
				System.out.println("Receive update status message");
				System.out.println("====================My Log List=================");
				*/
				while(sendLog == null) {
					try {
						Thread.sleep(100);
					} catch (Exception e) {}
				}
				/*
				synchronized(sendLog) {
					sendLog.printInfo();
				}
				System.out.println("================================================");
				System.out.println("");
				*/
				//Check if message is existed
				mid = updateMsg.getMID();
				int logIndex;
				synchronized (sendLog) {
					logIndex = sendLog.isExist(mid);
				}
				if(logIndex != -1) {
					// If log is existed, it means that
					// this process is faster than master
					// then just remove log and backupBuffer
					synchronized (sendLog) {
						sendLog.remove(mid);
					}
					synchronized (backupBuffer) {
						backupBuffer.removeElementAt(logIndex);
					}

				} else {
					// log does not exist. it means that
					// this process is slower than master
					// then just add log 
					synchronized(sendLog) {
						sendLog.add(mid);
					}
				}

			} else if(msg instanceof NotifyMessage) {
				//Calendar tmpCal = Calendar.getInstance();
				//System.out.println(""+myRank+"__"+myRankInList+ ":Notify Time->" + tmpCal.get(Calendar.HOUR)+":"+tmpCal.get(Calendar.MINUTE)+":"+tmpCal.get(Calendar.SECOND)+":"+tmpCal.get(Calendar.MILLISECOND));
				NotifyMessage noMsg = (NotifyMessage)msg;
				int deadNodeRank = noMsg.getRankInList();
			
				//set deadNode boolean in rankTable
				synchronized(rankTable) {
					rankTable.setAlive(deadNodeRank, false);
					rankTable.setTerminated(deadNodeRank, true);
				}	

				int numPeers = rankTable.size();

				/*
				System.out.println("I Got a Notify!! Node " + deadNodeRank + " is DEAD");
				System.out.println("My Master is " + myMaster);
				System.out.println("------DEBUG PROPOSE---------------");
				for(int i = 0; i < numPeers; i++) {
					System.out.println("RankInList" + i + ": RankMPI = " + rankTable.getRank(i) + ",HOST=" + rankTable.getHost(i));
				}
				System.out.println("----------------------------------");
				*/

				// Rank 0 is not there to take the result
				// Useless to compute for it!!
				// Let's QUIT, and let FD check-back to die
				if(deadNodeRank == 0) {
					System.out.println("[Warning] Rank 0 crashes, quit application");	

					cleanupProcess();
					System.exit(1);
				}

				//Check if at least 1 rank still alive

				boolean[] rankAliveNode = new boolean[commSize];
				//init with false;
				for(int i = 0; i < commSize; i++) {
					rankAliveNode[i] = false;
				}
				synchronized(rankTable) {
					for(int i = 0; i < numPeers; i++) {
						if(rankTable.isAlive(i)) {
							rankAliveNode[rankTable.getRank(i)] = true;
						}
					}
				}
				for(int i = 0; i < commSize; i++) {
					if(!rankAliveNode[i]) {
						System.err.println("** [Error] rank " + i + " process failed (i.e. all replicas for that rank failed). Application did not complete. <<detected by rank in list: "+ myRankInList + ">>");

						cleanupProcess();
						System.exit(1);
					}
				}


				//Send Notify to MPD
				NotifyMessage noMPDMsg = new NotifyMessage(key+"--"+myRank ,deadNodeRank);
				Socket so;
				OutputStream oout;
				ObjectOutputStream ooos;
				try {
					so = new Socket("127.0.0.1", mpdPort);
					oout = so.getOutputStream();
					ooos = new ObjectOutputStream(oout);
					ooos.writeObject(noMPDMsg);
					ooos.flush();
					ooos.close();
					oout.close();
					so.close();
				} catch (Exception e) {
					//System.out.println("NEW MASTER SEND :Can't reach dest");
				}
		
				// if dead node is master, check if it's a new master
				// if it's a new master then resend message from backupBuffer
				if(deadNodeRank == myMaster) {

					//System.out.println(">>>>>Yes my master is DEAD");
					// Check for new master
					int myNewMaster = myRankInList;
					int myCommSize = rankTable.size();
					for(int i = 0; i < myCommSize; i++) {
						if(myRank == rankTable.getRank(i)) {
							if(rankTable.isAlive(i)) {
								if(myNewMaster <= i) {
									// myself is a new master
									myMaster = i;
									master = true;
									break;
								} else {
									// found new master
									master = false;
									myMaster = i;
									break;
								}
							}
						}
					}
					//System.out.println("My New Master is " + myMaster);
					//if i'm a master resend mesages in backup
					if(master) {
						//System.out.println("************* I'm a NEW MASTER *********************");

						synchronized(backupBuffer) {
							// While backupBuffer is not empty, send message to destination
							while(backupBuffer.size() != 0) {
								SendBufferInformation binfo = backupBuffer.elementAt(0);
								Vector<URI> dests = rankTable.getURIByRank(binfo.toRank());
								int numDest = dests.size();
								Socket s;
								OutputStream out;
								ObjectOutputStream oos;
								URI destURI;

								// send message to destination
								for(int i = 0; i < numDest; i++) {
									try {
										destURI = dests.elementAt(i);
										s = new Socket(destURI.getHost(), destURI.getPort());
										out = s.getOutputStream();
										oos = new ObjectOutputStream(out);
										oos.writeObject(binfo.getData());
										oos.flush();
										oos.close();
										out.close();
										s.close();
									} catch (Exception e) {
										//System.out.println("NEW MASTER SEND :Can't reach dest");
									}
								}

								// update status to replica
								UpdateStatusMessage updateMsg = new UpdateStatusMessage(binfo.getMID());
								Vector<Integer> myRep = rankTable.getRankInListByRank(myRank);
								int numRep = myRep.size();
								for(int i = 0; i < numRep; i++) {
									int rRank = (myRep.elementAt(i)).intValue();
									try {
										if((rRank != myRankInList) && (rankTable.isAlive(rRank))) {
											s = new Socket( rankTable.getHost(rRank),
													rankTable.getPort(rRank));
											out = s.getOutputStream();
											oos = new ObjectOutputStream(out);
											oos.writeObject(updateMsg);
											oos.flush();
											oos.close();
											out.close();
											s.close();
										}
									} catch (Exception e) {
										//System.out.println("Can't reach replica");
									}
								}

								// remove backup buffer
								backupBuffer.removeElementAt(0);
								sendLog.remove(binfo.getMID());
							}
						}
					}
				}
				// if not just ignore
				// PERF :
				
				//tmpCal = Calendar.getInstance();
				//System.out.println(""+myRank+"__"+myRankInList+ ":Recovery Time->" + tmpCal.get(Calendar.HOUR)+":"+tmpCal.get(Calendar.MINUTE)+":"+tmpCal.get(Calendar.SECOND)+":"+tmpCal.get(Calendar.MILLISECOND));
			} else if (msg instanceof IsAliveMessage) {
				IsAliveMessage isAliveMsg = (IsAliveMessage)msg;
				Socket s = null;
				OutputStream out = null;
				ObjectOutputStream oos = null;

				if(key.equals(isAliveMsg.getKey())) {
					//Return my key	
					AliveMessage aliveMsg = new AliveMessage(key);
					try {
						out = socket.getOutputStream();
						oos = new ObjectOutputStream(out);
						oos.writeObject(aliveMsg);
						oos.close();
						out.close();
					} catch (Exception e) {}
				} else {
					NoAliveMessage noaliveMsg = new NoAliveMessage();
					try {
						out = socket.getOutputStream();
						oos = new ObjectOutputStream(out);
						oos.writeObject(noaliveMsg);
						oos.close();
						out.close();
					} catch (Exception e) {}
				}
			} else if (msg instanceof FinalizedMessage) {
				//mask terminated flag = true
				FinalizedMessage finalMsg = (FinalizedMessage)msg;
				int doneNodeRank = finalMsg.getRankInList();
			
				synchronized(rankTable) {
					rankTable.setTerminated(doneNodeRank, true);
				}	

			} else if (msg instanceof FinalizedConfirmMessage) {
				//change local variable canExit = true
				terminated = true;

			} else if (msg instanceof RequestQuitMessage) {
				//just exit
				System.exit(0);
			} else if (msg instanceof OutputMessage) {
				OutputMessage outputMsg = (OutputMessage)msg;
				System.out.println(outputMsg.getOutput());	
			} else {
				System.err.println("** [Warning] received unknow type of message.");
			}

			try {
				ois.close();
				in.close();
				socket.close();
			} catch (Exception e) {
				System.err.println("** [Error] cannot close communication, maybe a network problem.");
			}
		}
	}
	
	public int getMessageBufferSize() {
		return (messageBuffer.size());
	}

	public boolean isReady() {
		return ready;
	}

	public boolean isTerminated() {
		return terminated;
	}

	public boolean isAllTerminated() {
		synchronized(rankTable) {
			for(int i = 0; i < rankTable.size(); i++) {
				if(!rankTable.isTerminated(i))
					return false;
			}
			return true;
		}
	}

	public void meTerminated() {
		synchronized(rankTable) {
			rankTable.setTerminated(0, true);
		}
	}

	public Object getDataFromBuffer(int fromRank, int toRank, int tag, IStatus status) {
		RecvBufferInformation tmp;
		synchronized (messageBuffer) {
			int numElement = messageBuffer.size();
			for(int i = 0; i < numElement; i++) {
				tmp = messageBuffer.elementAt(i);

                        	boolean match_dst = (tmp.fromRank() == fromRank) && (tmp.toRank() == toRank);
                        	boolean match_tag = tmp.getTag() == tag ;
                        	boolean any_src   = fromRank == Tag.MPI_ANYSOURCE;
                        	boolean any_tag   = tag == Tag.MPI_ANYTAG ;

				// DEBUG System.out.println("mbuf ["+tmp.fromRank()+"->"+tmp.toRank()+",tag="+tmp.getTag()+"]");
				if ((match_dst || any_src)  && (match_tag || any_tag))  
				{
					// Set length in Status
                        		status.setStatus(tmp.fromRank(),tmp.getTag());
					// DEBUG System.out.println("took ["+tmp.fromRank()+"->"+tmp.toRank()+",tag="+tmp.getTag()+"]");
					return tmp.getData();
				}
			}
		}	
		return null;
	}

	//TODO : performance may drop because we search 2 times
	public void removeDataFromBuffer(int fromRank, int toRank, int tag) {
		RecvBufferInformation tmp;
		synchronized (messageBuffer) {
			int numElement = messageBuffer.size();
			for(int i = 0; i < numElement; i++) {
				tmp = messageBuffer.elementAt(i);

                        	boolean match_dst = (tmp.fromRank() == fromRank) && (tmp.toRank() == toRank);
                        	boolean match_tag = tmp.getTag() == tag ;
                        	boolean any_src   = fromRank == Tag.MPI_ANYSOURCE;
                        	boolean any_tag   = tag == Tag.MPI_ANYTAG ;

				if ((match_dst || any_src)  && (match_tag || any_tag))  
				{
					messageBuffer.removeElementAt(i);
					return;
				}
			}
		}	
	}

	public void setTGossip(int t_gossip) {
		this.t_gossip = t_gossip;
	}

	public void setTMargin(int t_margin) {
		this.t_margin = t_margin;
	}

	public int getTDiff() {
		return t_diff;
	}

	public int getTGossip() {
		return t_gossip;
	}

	public void setGossipProtocol(String protocol) {
		gossipProtocol = new String(protocol);
	}

	public String getGossipProtocol() {
		return gossipProtocol;
	}

	public int getTMargin() {
		return t_margin;
	}

	public int getRank() {
		return myRank;
	}

	public int getRankInList() {
		return myRankInList;
	}

	public int getCommSize() {
		return commSize;
	}
	public void stop() {
		try {
			//System.out.println("CLOSE  ServSocket");
			servSocket.close();
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}
}
