package p2pmpi.common;

import java.net.*;
import java.io.*;
import java.util.*;
import p2pmpi.common.*;

public class NetIface {

	  private String ifname=null;
	  private String extIfIpv4Address=null;
	  private String extIfIpv6Address=null;
	  private String canonicalHostName=null;

	  public NetIface() {
		    byte [] ipv4;
		    NetworkInterface iface = null;

		    // First check if IP has been set in config file
		    P2PMPI_ConfigFile conf = new P2PMPI_ConfigFile( );
		    String extIp = conf.getExternalIP();
		    if ( extIp != null ) {
				// FIXME : put more checkings here (valid IP,etc)
				this.ifname="eth0"; // default
				extIfIpv6Address="/undefined";
				extIfIpv4Address="/"+extIp;
		    }
		    // No, guess which IP is best suited.
		    else {
				try {
					  for( Enumeration ifaces = NetworkInterface.getNetworkInterfaces();ifaces.hasMoreElements();){
						    iface = (NetworkInterface)ifaces.nextElement();
						    InetAddress ia = null;
						    for (Enumeration ips = iface.getInetAddresses();ips.hasMoreElements();){
								ia = (InetAddress)ips.nextElement();
								ipv4 = ia.getAddress();


								if ( !ia.isLinkLocalAddress() && !ia.isLoopbackAddress()) {
									  ifname = iface.getDisplayName();
									  canonicalHostName = ia.getCanonicalHostName();
									  if ( isIPv4Address( ipv4 ) ) {
										    this.extIfIpv4Address = ia.toString();
									  }
									  else {
										    this.extIfIpv6Address = ia.toString();
									  }							
								}
						    }

					  }
				}
				catch (SocketException e) { System.err.println("[Error] cannot determine network interfaces.");}
		    }
	  }
	  /**
	   * Return the name or the IP contained in the result of InetAddress.toString().
	   * The result parsed should be of the form "<hostname>/<ip>". After split,
	   * first string is the hostname if resolved, 2nd string is the IP.
	   * Return preferably hostname if non empy.
	   **/
	  private String splitStringAddress( String s ) {
		    String [] ret = s.split("/",2);
		    if (ret[0].length() > 0)
				return( ret[0] );
		    return ( ret[1] );
	  }

	  public String getIfName( ) {
		    return( this.ifname );
	  }

	  /**
	   * Return the IP address of network interface automatically selected.
	   * If an IP has been set in config file, this is the IP returned.
	   * Otherwise, returns the hostname if available, or the ip of the selected interface.
	   * If no network interface is available, returns null.
	   **/ 
	  public String getExternalIfIpv4( ) {
		    if	(this.extIfIpv4Address ==null)
				return( null );
		    else 
				return ( splitStringAddress(  this.extIfIpv4Address ));
	  }
	  public String getExternalIfIpv6( ) {
		    if	(this.extIfIpv6Address ==null)
				return( null );
		    else 
				return( splitStringAddress( this.extIfIpv6Address ));
	  }

	  public String getCanonicalHostName() {
		    return( canonicalHostName );
	  }


	  private static boolean isIPv4Address(byte[] address) {
		    return address.length == 4;
	  }

	 /**
	  * main. Just tot test and see how to use class.
	  **/
	  public static void main(String[] args) {
		    NetIface extIf  = new NetIface();
		    System.out.println("selected interface: " + extIf.getIfName() 
					  + ": ipv4="+extIf.getExternalIfIpv4( )
					  +"  ipv6="+extIf.getExternalIfIpv6( ));
	  }

}
