/*
 * @author Choopan Rattanapoka
 * @author Ghazi Bouabene
 * @author Stephane Genaud
 *
 */

package p2pmpi.common;

import java.io.*;
import java.util.*;

public class OsInfo {

      /*
	-------------------------------- System Name -----------------------
	*/	
	private static String normalizedOsCategory [] = {"Linux","Windows","Macosx","SunOS"};

	public static String getName()  
	{
		return (System.getProperty("os.name"));
	}
      /**
	* return true if realName ressembles suspectedOs
      *
      * @param realName exact system name (e.g. returned by the JVM)
      * @param suspectedOs a simplified name of your invention
      */
	public static boolean equalsOs(String realName,String suspectedOs) 
	{
		String simpleRealName = realName.replaceAll(" ","").toLowerCase();
		return (simpleRealName.startsWith(suspectedOs.toLowerCase()));
	}
				    
	public static boolean isLinux(String s)
	{
		return (equalsOs(s,normalizedOsCategory[0]));
	}

	public static boolean isWindows(String s) {
		return (equalsOs(s,normalizedOsCategory[1]));
	}

	public static boolean isMacosx(String s)
	{
		return (equalsOs(s,normalizedOsCategory[2]));
	}

	/**
	* return the OS category name given a detailed OS name 
      *
      * @param s  exact system name (e.g. returned by the JVM)
      */
	public static String normalizedOsInfo(String s) 
	{
		int i;
		for (i=0;i<normalizedOsCategory.length;i++) {
		    if (equalsOs(s,normalizedOsCategory[i])) {
				return (normalizedOsCategory[i]);
		    }
		 }
		 return("Unknown");
	}
      /*
	-------------------------------- System info -----------------------
	*/	

	/**
	 * returns a String array with various info item related to system CPU.
	 * or null if information cannot be retrieved (retrieving method not implemented.
	 * Array results consits in:
	 * - first element is CPU model name 
	 * - second element is frequency 
	 */
	
	public static String [] cpuInfo () { 
		String infos [] = null;
		String s = OsInfo.getName();

		//here we add the system information according to the os
		if (isLinux(s)) {
			//we read the info in the /proc FS
			try {
				// Open the file /proc/cpuinfo
				FileInputStream fstream = new FileInputStream("/proc/cpuinfo");

				// Convert our input stream to a DataInputStream
				//DataInputStream in = new DataInputStream(fstream);
				BufferedReader in = new BufferedReader(new InputStreamReader(fstream));

				// Continue to read lines while 
				// there are still some left to read
				boolean stop= false;
				infos = new String [2];
				while (!stop){
						String tmp = in.readLine();
						if (tmp.startsWith("model name")){
							String m[] = tmp.split(":",2);
							infos[0] = new String(m[1]);
									
						}
						if (tmp.startsWith("cpu MHz")){
							String m[] = tmp.split(":",2);
							infos[1] = new String (m[1]);
							stop = true;
						}
				}
				in.close();
			}
                  catch (Exception e) {
				System.err.println("** Warning: could not read /proc/cpuinfo filesystem.");
			}
		}
		// ----- MacOsX ---
		if (isMacosx(s))  {
			String modelSymbol = "hw.model =";
			String freqSymbol =  "hw.cpufrequency =";
			try {            
           			Process sysctl = Runtime.getRuntime().exec("sysctl hw");
				InputStream stdout = sysctl.getInputStream();
				InputStreamReader isr = new InputStreamReader(stdout);
				BufferedReader br = new BufferedReader(isr);
				String tmp = null;
				infos = new String [2];
				while ( (tmp = br.readLine()) != null) {
                			if (tmp.startsWith(modelSymbol)) {
						infos[0] = tmp.substring(tmp.indexOf("=")+1);
					}
                			if (tmp.startsWith(freqSymbol)) {
						infos[1] = tmp.substring(tmp.indexOf("=")+1);
					}
				}
				if ((infos[0]==null) || (infos[1]==null))
					infos = null; 
            		int exitVal = sysctl.waitFor();
				// ... we could do something clever with this.
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}

		else  {
			// nothing, as long as we have no method to get this
		}
		return (infos);
	}

	/**
	 * returns a String array with various info item related to memory.
	 * or null if information cannot be retrieved (retrieving method not implemented.
	 * Array results consits in:
	 * - first element is RAM hardware capacity 
	 * (only one item for the momemnt. We could add space disk in the future)
	 */
	public static String [] memInfo () {
		String infos [] = null;
		String s = OsInfo.getName();

		// --- Linux ----
		if (isLinux(s)) {
			try {
				// Open the file /proc/meminfo
				FileInputStream fstream = new FileInputStream("/proc/meminfo");

				// Convert our input stream to a DataInputStream
				//DataInputStream in = new DataInputStream(fstream);
				BufferedReader in = new BufferedReader(new InputStreamReader(fstream));

				String tmp = in.readLine();		
				String m[] = tmp.split(":",2);
				infos = new String [1];
				infos [0] = new String(m[1]);
				in.close();
			} 
                  catch (Exception e) {
				System.err.println("** Warning: could not read /proc/meminfo filesystem.");
			}
		}
		// --- MacOsX ----
		if (isMacosx(s))  {
			String memsizeSymbol = "hw.memsize:";
			
			try {            
           			Process sysctl = Runtime.getRuntime().exec("sysctl -a hw");
				InputStream stdout = sysctl.getInputStream();
				InputStreamReader isr = new InputStreamReader(stdout);
				BufferedReader br = new BufferedReader(isr);
				String tmp = null;
				while ( (tmp = br.readLine()) != null) {
                			if (tmp.startsWith(memsizeSymbol)) {
						infos = new String [1];
						infos[0] = tmp.substring(tmp.indexOf(":")+1);
					}
				}
            		int exitVal = sysctl.waitFor();
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}
		return(infos);
	}

	/**
	 * Returns the number of processors available to the Java virtual machine.
	 */
/*	public int availableProcessors() {
		return(Runtime.availableProcessors());
	}
*/
	public static void main(String[] args) {
		String s = OsInfo.getName();
		System.out.println("Exact system name as returned by  System.getProperty() : " + s);
		System.out.println("normalizedOsInfo("+s+") : "+normalizedOsInfo(s));
		System.out.println("normalizedOsInfo(Mac Os X) : "+normalizedOsInfo("Mac Os X"));
		System.out.println("Is Linux : " + OsInfo.isLinux(s));
		System.out.println("Is Windows : " + OsInfo.isWindows(s));
		System.out.println("Is MacOSX : " + OsInfo.isMacosx(s));
            String [] cpuinfo = OsInfo.cpuInfo();
            String [] meminfo = OsInfo.memInfo();
		if (cpuinfo != null)
			System.out.println("CPU model:" + cpuinfo[0] + " / "+ cpuinfo[1]+ "MHz");
		else
			System.out.println("CPU model: N/A");
		if (meminfo != null)
			System.out.println("RAM:" + meminfo[0]);
		else
			System.out.println("RAM: N/A");
	}
}
