/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.internal;

public class BinomialTree {
    int numNode;
    int maxDegree;

    public BinomialTree(int n) {
        this.numNode = n;
        this.maxDegree = (int)Math.ceil(Math.log(n) / Math.log(2.0));
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public int getParentChildren(int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        if (n == 0) {
            for (int i = 0; i < this.maxDegree; ++i) {
                nArray[i] = (int)Math.pow(2.0, i);
            }
            nArray[i] = -1;
            return -1;
        }
        while (true) {
            int n4;
            int n5;
            if (n2 + (n5 = (int)Math.pow(2.0, n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0)))) == n) {
                if (n4 == 0) {
                    nArray[0] = -1;
                    break;
                }
                for (int i = 0; i < n4; ++i) {
                    int n6 = n + (int)Math.pow(2.0, i);
                    nArray[i] = n6 < this.numNode ? n6 : -1;
                }
                nArray[i] = -1;
                break;
            }
            n3 = n - (n2 += n5);
        }
        return n2;
    }

    public int getParentChildrenInverse(int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        if (n == 0) {
            for (int i = 0; i < this.maxDegree; ++i) {
                nArray[this.maxDegree - i - 1] = (int)Math.pow(2.0, i);
            }
            nArray[i] = -1;
            return -1;
        }
        while (true) {
            int n4;
            int n5;
            if (n2 + (n5 = (int)Math.pow(2.0, n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0)))) == n) {
                int n6;
                if (n4 == 0) {
                    nArray[0] = -1;
                    break;
                }
                for (n6 = 0; n6 < this.maxDegree; ++n6) {
                    nArray[n6] = -1;
                }
                for (n6 = n4 - 1; n6 >= 0; --n6) {
                    int n7 = n + (int)Math.pow(2.0, n6);
                    if (n7 >= this.numNode) continue;
                    nArray[n6] = n7;
                }
                break;
            }
            n3 = n - (n2 += n5);
        }
        return n2;
    }
}

