/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.internal.MessageHandler;
import p2pmpi.mpi.internal.MessageIDLog;
import p2pmpi.mpi.internal.SendBufferInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    MessageHandler msgHandle;
    RankTable rankTable;
    MapRankTable mapRankTable;
    int myRank;
    int myRankInList;
    int groupSize;
    Vector<SendBufferInformation> backupMessage;
    MessageIDLog log;

    public Group(MessageHandler messageHandler, RankTable rankTable, int n, int n2, int n3, Vector<SendBufferInformation> vector, MessageIDLog messageIDLog, MapRankTable mapRankTable) {
        this.msgHandle = messageHandler;
        this.rankTable = rankTable;
        this.myRank = n;
        this.myRankInList = n2;
        this.groupSize = n3;
        this.backupMessage = vector;
        this.log = messageIDLog;
        this.mapRankTable = mapRankTable;
    }

    public int Rank() {
        return this.myRank;
    }

    public int RankInList() {
        return this.myRankInList;
    }

    public int Size() {
        return this.groupSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int __sizetotal() {
        int n = 0;
        int n2 = this.__getNumPeers();
        MapRankTable mapRankTable = this.mapRankTable;
        synchronized (mapRankTable) {
            for (int i = 0; i < n2; ++i) {
                if (!this.rankTable.isAlive(this.mapRankTable.getRank(i))) continue;
                ++n;
            }
        }
        return n;
    }

    public Group Excl(int[] nArray) {
        int n = this.groupSize;
        int n2 = this.__getNumPeers();
        MapRankTable mapRankTable = new MapRankTable();
        int n3 = MPI.UNDEFINED;
        int n4 = MPI.UNDEFINED;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = this.mapRankTable.getRank(i);
            int n7 = 0;
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] < n6) {
                    ++n7;
                    continue;
                }
                if (nArray[j] != n6) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            mapRankTable.addMap(n6 - n7, this.mapRankTable.getRankInList(i));
            if (i == this.myRankInList) {
                n3 = n6 - n7;
                n4 = n5;
            }
            ++n5;
        }
        Group group = new Group(this.msgHandle, this.rankTable, n3, n4, n -= nArray.length, this.backupMessage, this.log, mapRankTable);
        return group;
    }

    public Group Incl(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        MapRankTable mapRankTable = new MapRankTable();
        int n4 = MPI.UNDEFINED;
        int n5 = MPI.UNDEFINED;
        int n6 = this.mapRankTable.size();
        for (n = 0; n < nArray.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < n6; ++i) {
                if (this.mapRankTable.getRank(i) != nArray[n]) continue;
                mapRankTable.addMap(n2, this.mapRankTable.getRankInList(i));
                if (i == this.myRankInList) {
                    n4 = n2;
                    n5 = n3;
                }
                bl = true;
                ++n3;
            }
            if (!bl) continue;
            ++n2;
        }
        n = n2;
        Group group = new Group(this.msgHandle, this.rankTable, n4, n5, n, this.backupMessage, this.log, mapRankTable);
        return group;
    }

    public static int Compare(Group group, Group group2) {
        int n;
        MapRankTable mapRankTable = group.__getMapCommTable();
        MapRankTable mapRankTable2 = group2.__getMapCommTable();
        if (mapRankTable.size() != mapRankTable2.size()) {
            return MPI.UNEQUAL;
        }
        int n2 = mapRankTable.size();
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            if (mapRankTable.getRank(n) == mapRankTable2.getRank(n) && mapRankTable.getRankInList(n) == mapRankTable2.getRankInList(n)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (mapRankTable.getRankInList(i) != mapRankTable2.getRankInList(j)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                return MPI.UNEQUAL;
            }
            return MPI.SIMILAR;
        }
        return MPI.IDENT;
    }

    public static Group Union(Group group, Group group2) {
        int n;
        MapRankTable mapRankTable = group.__getMapCommTable();
        MapRankTable mapRankTable2 = group2.__getMapCommTable();
        MapRankTable mapRankTable3 = new MapRankTable();
        int n2 = 0;
        int n3 = mapRankTable.size();
        int n4 = group.Size();
        for (n = 0; n < n3; ++n) {
            mapRankTable3.addMap(mapRankTable.getRank(n), mapRankTable.getRankInList(n));
        }
        n = group.Rank();
        int n5 = group.RankInList();
        int n6 = mapRankTable2.size();
        int n7 = group2.Size();
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (int j = 0; j < n6; ++j) {
                if (mapRankTable2.getRank(j) != i) continue;
                boolean bl2 = false;
                for (int k = 0; k < n3; ++k) {
                    if (mapRankTable2.getRankInList(j) != mapRankTable.getRankInList(k)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                mapRankTable3.addMap(n8 + n4, mapRankTable2.getRankInList(j));
                if (j == group2.RankInList()) {
                    n = n8 + n4;
                    n5 = n3 + n9;
                }
                ++n9;
                bl = true;
            }
            if (!bl) continue;
            ++n8;
        }
        n2 = n8 + n4;
        Group group3 = new Group(group.__getMessageHandler(), group.__getRankTable(), n, n5, n2, group.__getBackupMessage(), group.__getLog(), mapRankTable3);
        return group3;
    }

    public static Group Intersection(Group group, Group group2) {
        int n;
        MapRankTable mapRankTable = new MapRankTable();
        MapRankTable mapRankTable2 = group.__getMapCommTable();
        MapRankTable mapRankTable3 = group2.__getMapCommTable();
        int n2 = mapRankTable2.size();
        int n3 = mapRankTable3.size();
        int[] nArray = new int[n2];
        int n4 = 0;
        block0: for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                if (mapRankTable2.getRankInList(i) != mapRankTable3.getRankInList(n)) continue;
                boolean bl = false;
                for (int j = 0; j < n4; ++j) {
                    if (nArray[j] != mapRankTable2.getRank(i)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue block0;
                nArray[n4] = mapRankTable2.getRank(i);
                ++n4;
                continue block0;
            }
        }
        int[] nArray2 = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray2[n] = nArray[n];
        }
        return group.Incl(nArray2);
    }

    public static Group Difference(Group group, Group group2) {
        int n;
        MapRankTable mapRankTable = new MapRankTable();
        MapRankTable mapRankTable2 = group.__getMapCommTable();
        MapRankTable mapRankTable3 = group2.__getMapCommTable();
        int n2 = mapRankTable2.size();
        int n3 = mapRankTable3.size();
        int[] nArray = new int[n2];
        int n4 = 0;
        block0: for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                if (mapRankTable2.getRankInList(i) != mapRankTable3.getRankInList(n)) continue;
                boolean bl = false;
                for (int j = 0; j < n4; ++j) {
                    if (nArray[j] != mapRankTable2.getRank(i)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue block0;
                nArray[n4] = mapRankTable2.getRank(i);
                ++n4;
                continue block0;
            }
        }
        int[] nArray2 = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray2[n] = nArray[n];
        }
        return group.Excl(nArray2);
    }

    public Vector<SendBufferInformation> __getBackupMessage() {
        return this.backupMessage;
    }

    public MessageIDLog __getLog() {
        return this.log;
    }

    public MessageHandler __getMessageHandler() {
        return this.msgHandle;
    }

    public int __getNumPeers() {
        return this.mapRankTable.size();
    }

    public RankTable __getCommTable() {
        return this.rankTable;
    }

    public MapRankTable __getMapCommTable() {
        return this.mapRankTable;
    }

    public RankTable __getRankTable() {
        return this.rankTable;
    }
}

