/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.Timer;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.HostEntry;
import p2pmpi.mpd.PingRTT;
import p2pmpi.p2p.message.PeerReplyMessage;
import p2pmpi.p2p.message.PeerRequestMessage;
import p2pmpi.p2p.message.RegisterMessage;

public abstract class P2PMPI_MPDPeer
extends Thread {
    protected HostEntry myHost;
    protected int numProcPerJob;
    protected String tmpDir = null;
    protected File runPath = null;
    protected String peerCacheFile = null;
    protected int ftPort;
    protected int fdPort;
    protected int mpdPort;
    protected int rsPort;
    protected String externalIP;
    protected String usingIP;
    protected static Logger log;
    protected String peerName = null;
    protected int processID;
    protected Timer peerDiscovery = null;
    protected final int connectNumTry = 240;
    protected final int connectSleep = 1000;
    protected InetAddress myIPAddress = null;
    protected volatile HashMap<String, HostEntry> hostCache = new HashMap();

    public abstract void run();

    protected boolean joinMpiGroup(URI uRI) {
        int n = 10;
        while (n-- > 0) {
            try {
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(uRI.getHost(), uRI.getPort());
                socket.connect(inetSocketAddress, 1000);
                RegisterMessage registerMessage = new RegisterMessage(this.myHost);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(registerMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
                return true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {}
            }
        }
        return false;
    }

    protected void updateHostCache(URI uRI) {
        try {
            log.info((Object)("Waiting for SuperNode " + uRI.getHost() + ":" + uRI.getPort() + " host list ..."));
            Socket socket = new Socket(uRI.getHost(), uRI.getPort());
            PeerRequestMessage peerRequestMessage = new PeerRequestMessage();
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(peerRequestMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            PeerReplyMessage peerReplyMessage = (PeerReplyMessage)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
            Vector<HostEntry> vector = peerReplyMessage.getHostList();
            int n = vector.size();
            log.info((Object)("SuperNode sends back a host list (size=" + n + ")"));
            for (int i = 0; i < n; ++i) {
                int n2;
                PingRTT pingRTT;
                HostEntry hostEntry = vector.elementAt(i);
                String string = hostEntry.toString();
                if (hostEntry.toString().equals(this.myHost.toString())) continue;
                if (!this.hostCache.containsKey(string)) {
                    pingRTT = new PingRTT(hostEntry.getIp(), hostEntry.getMpdPort());
                    n2 = pingRTT.ping();
                    hostEntry.setRtt(n2);
                    hostEntry.setAlive(true);
                    hostEntry.setLastUpdate();
                    this.hostCache.put(string, hostEntry);
                    log.info((Object)"Put new entry to local cache");
                    continue;
                }
                if (this.hostCache.get(string).getLastUpdate() > 300000L) {
                    pingRTT = new PingRTT(hostEntry.getIp(), hostEntry.getMpdPort());
                    n2 = pingRTT.ping();
                    this.hostCache.get(string).setRtt(n2);
                    this.hostCache.get(string).setLastUpdate();
                }
                this.hostCache.get(string).setAlive(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

