/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class GLPanel
extends JPanel {
    public String zoomLabel = "Zoom";
    public String rotateLabel = "Rotate";
    public String localityLabel = "Locality";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public RotateScroll rotateScroll;
    public LocalityScroll localityScroll;
    public JPopupMenu glPopup;
    public Hashtable scrollBarHash;
    protected TGPanel tgPanel;
    protected TGLensSet tgLensSet;
    protected TGUIManager tgUIManager;
    private Color defaultColor = Color.lightGray;

    public GLPanel() {
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.defaultColor = Color.WHITE;
        this.setBackground(Color.WHITE);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.initialize();
    }

    public GLPanel(Color color) {
        this.defaultColor = color;
        this.setBackground(color);
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setBackground(color);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.initialize();
    }

    public void initialize() {
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        this.setVisible(true);
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public HVScroll getHVScroll() {
        return this.hvScroll;
    }

    public void setOffset(Point point) {
        this.hvScroll.setOffset(point);
    }

    public Point getOffset() {
        return this.hvScroll.getOffset();
    }

    public RotateScroll getRotateScroll() {
        return this.rotateScroll;
    }

    public void setRotationAngle(int n) {
        this.rotateScroll.setRotationAngle(n);
    }

    public int getRotationAngle() {
        return this.rotateScroll.getRotationAngle();
    }

    public LocalityScroll getLocalityScroll() {
        return this.localityScroll;
    }

    public void setLocalityRadius(int n) {
        this.localityScroll.setLocalityRadius(n);
    }

    public int getLocalityRadius() {
        return this.localityScroll.getLocalityRadius();
    }

    public ZoomScroll getZoomScroll() {
        return this.zoomScroll;
    }

    public void setZoomValue(int n) {
        this.zoomScroll.setZoomValue(n);
    }

    public int getZoomValue() {
        return this.zoomScroll.getZoomValue();
    }

    public JPopupMenu getGLPopup() {
        return this.glPopup;
    }

    public void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        this.tgLensSet.addLens(this.zoomScroll.getLens());
        this.tgLensSet.addLens(this.rotateScroll.getLens());
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    protected JPanel scrollSelectPanel(String[] stringArray) {
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setBackground(this.defaultColor);
        jComboBox.setPreferredSize(new Dimension(80, 20));
        jComboBox.setSelectedIndex(0);
        final JScrollBar jScrollBar = (JScrollBar)this.scrollBarHash.get(stringArray[0]);
        jComboBox.addActionListener(new ActionListener(){
            JScrollBar currentSB;
            {
                this.currentSB = jScrollBar;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar2 = (JScrollBar)GLPanel.this.scrollBarHash.get((String)jComboBox.getSelectedItem());
                if (this.currentSB != null) {
                    this.currentSB.setVisible(false);
                }
                if (jScrollBar2 != null) {
                    jScrollBar2.setVisible(true);
                }
                this.currentSB = jScrollBar2;
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(this.defaultColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add(jComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 17);
        gridBagConstraints.fill = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            JScrollBar jScrollBar2 = (JScrollBar)this.scrollBarHash.get(stringArray[i]);
            if (jScrollBar2 == null) continue;
            if (i != 0) {
                jScrollBar2.setVisible(false);
            }
            jPanel.add((Component)jScrollBar2, gridBagConstraints);
        }
        return jPanel;
    }

    public void addUIs() {
        this.tgUIManager = new TGUIManager();
        GLEditUI gLEditUI = new GLEditUI(this);
        GLNavigateUI gLNavigateUI = new GLNavigateUI(this);
        this.tgUIManager.addUI(gLEditUI, "Edit");
        this.tgUIManager.addUI(gLNavigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    public void randomGraph() throws TGException {
        Node node = this.tgPanel.addNode();
        node.setType(0);
        for (int i = 0; i < 249; ++i) {
            Node node2 = this.tgPanel.getGES().getRandomNode();
            Node node3 = this.tgPanel.addNode();
            node3.setType(0);
            if (this.tgPanel.findEdge(node2, node3) == null) {
                this.tgPanel.addEdge(node2, node3, Edge.DEFAULT_LENGTH);
            }
            if (i % 2 != 0 || this.tgPanel.findEdge(node2 = this.tgPanel.getGES().getRandomNode(), node3) != null) continue;
            this.tgPanel.addEdge(node2, node3, Edge.DEFAULT_LENGTH);
        }
        this.tgPanel.setLocale(node, 2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Graph Layout");
        GLPanel gLPanel = new GLPanel();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", gLPanel);
        jFrame.setSize(500, 500);
        jFrame.setVisible(true);
    }
}

