/*********************************/
/*       DOMAIN SIMPLIFY         */
/* input : 2 constraint matrices */
/* output : P1 simplified by P2  */
/*********************************/

#include <stdio.h>
#include <polylib/polylib64.h>

#define WS 256

int main()
{
	Matrix *c;
	Polyhedron *P1, *P2, *P;

	c = Matrix_Read();
	P1 = Constraints2Polyhedron(c, WS);
	Matrix_Free( c );

	c = Matrix_Read();
	P2 = Constraints2Polyhedron(c, WS);
	Matrix_Free( c );

	printf( "P1 = ");
	Polyhedron_Print( stdout, "%3d ", P1 );
	printf( "P2 = ");
	Polyhedron_Print( stdout, "%3d ", P2 );
	printf( "\n");

	P = DomainSimplify( P1, P2, WS );
	printf( "P = ");
	Polyhedron_Print( stdout, "%3d ", P );

	return( 0 );
}
