/*     domain splitting for group reuse
*/
/*
   input : n integer : searches k<=n such that T^k=Id
           t1 and t2 reference matrices
           D domain
           C context
	ouput : a lot :)
*/
/* try "cache_split <ex/article | visudoain"
   You get the result from research report pub-00-03
   http://icps.u-strasbg.fr/pub-00/ pub-00-03.ps.gz
*/

#include <stdio.h>
#include <stdlib.h>
#include <polylib/polylib64.h>

#define WS 1000
#define AFF_POLY(P) {	fprintf( stderr, "\n"#P" = "); \
                        Polyhedron_Print( stderr, "%3d ", P ); }

#define AFFCONTRAINTES(p) {	printf( "\n# "#p "\n" ); \
                        AffContraintes( p ); }

int Aff( int i )
{
	if( i==0 ) return 0;
	if( i==1 ) { printf( "+" ); return 1; }
	if( i==-1 ) { printf( "-" ); return -1; }
	else if( i>0 ) printf( "+%d", i );
	else printf( "%d", i );
	return( i );
}
void AffContraintes( Polyhedron *p )
{
	int i,j;
	for( ; p ; p=p->next )
	{
		printf( "%d %d\n", p->NbConstraints, p->Dimension+2 );
		for( i=0 ; i<p->NbConstraints ; i++ )
		{
		 for( j=0 ; j<p->Dimension+2 ; j++ )
				printf( "%3lld ", p->Constraint[i][j] );
		 if( p->Dimension == 3 )
		 {
			printf( "   # " );
			if( p->Constraint[i][1]>0 || (p->Constraint[i][1]==0 && p->Constraint[i][2]>0) )
			{
				if(Aff(p->Constraint[i][1])) printf( "i " );
				if(Aff(p->Constraint[i][2])) printf( "j " );
				if( p->Constraint[i][0] == 1 )
					printf( "\\ge " );
				else
					printf( "= " );
				if(Aff(-p->Constraint[i][3])) printf( "N " );
				if( abs(Aff(-p->Constraint[i][4]))==1 )
					printf( "%d",abs(p->Constraint[i][4]) );
			}
			else if( p->Constraint[i][1]==0 && p->Constraint[i][2]==0 )
				printf("No i, j");
			else
			{
				if(Aff(-p->Constraint[i][1])) printf( "i ");
				if(Aff(-p->Constraint[i][2])) printf( "j ");
				if( p->Constraint[i][0] == 1 )
					printf( "\\le " );
				else
					printf( "= " );
				if(Aff(p->Constraint[i][3])) printf( "N ");
				if( abs(Aff(p->Constraint[i][4]))==1 )
					printf( "%d",abs(p->Constraint[i][4]) );
			}
		 }
		 printf( "\n" );
		}
	}
}

int Matrice_identite( Matrix *M )
{
	int i,j;
	if( M->NbRows != M->NbColumns )
		return( 0 );
	for( i=0 ; i<M->NbRows ; i++ )
		for( j=0 ; j<M->NbColumns ; j++ )
			if( i == j )
			{
				if( M->p[i][j] != 1 )
					return( 0 );
			}
			else
			{
				if( M->p[i][j] != 0 )
					return( 0 );
			}
	return( 1 );
}

int main(int argc, char *argv[])
{
	int n, s;
	Matrix *r1, *r2, *ri;
	Matrix *T, *nTk, *en, *c, *context, **Tk;
	Polyhedron  *D, *C, *Cn;
	Polyhedron *P1, *P2, *D1, *D2, *L, *p, *pp, *TiD2, *D12, *D21;
	Polyhedron  *RD1;
	int i,j,l;

	scanf( "%d", &n );

/*	T = Matrix_Read(); */
	r1 = Matrix_Read();
	r2 = Matrix_Read();
	s = r1->NbColumns;
	if( s != r2->NbColumns || s != r2->NbRows || s != r1->NbRows )
	{
		fprintf(stderr,
		"Les matrices r1 et r2 doivent etre carrees et avoir la meme taille\n" );
		exit(0);
	}
	ri = Matrix_Alloc(s, s+1);
	if( !MatInverse( r2, ri ) )
	{
		fprintf( stderr, "r2 non inversible!\n");
		exit(0);
	}
/*	r2i = Matrix_Alloc( s, s );
	for( i=0 ; i<s ; i++ )
	{
		if( ri->p[i][s] != 1 )
		{
			fprintf(stderr, "La matrice r1 doit etre unimodulaire\n" );
			exit(0);
		}
		for( j=0; j<s ; j++ )
			r2i->p[i][j] = ri->p[i][j];
	}
	Matrix_Free( ri );
	T = Matrix_Alloc(s, s );
	Matrix_Product( r2i, r1, T );
	Matrix_Free( r2i );
*/
	T = Matrix_Alloc(s, s );
	for( i=0 ; i<s ; i++ )
		for( j=0 ; j<s ; j++ )
		{
			int z,k;
			z=0;
			for( k=0 ; k<s ; k++ )
				z += ri->p[i][k] * r1->p[k][j];
			if( z % ri->p[i][s] != 0 )
			{
				fprintf(stderr,
					"Les matrices r1 et r2 n'ont pas le meme determinant\n" );
				exit(0);
			}
			T->p[i][j] = z / ri->p[i][s];
		}
	Matrix_Free( ri );
	Matrix_Free( r1 );
	Matrix_Free( r2 );

	en = Matrix_Read();
	D = Constraints2Polyhedron(en, WS );
	Matrix_Free(en);

	context = Matrix_Read();

	fprintf( stderr, "T = ");
	Matrix_Print( stderr, "%3d ", T );
	if( T->NbColumns != D->Dimension+1 || T->NbColumns != T->NbRows )
	{
		fprintf(stderr,
		"Matrice T incompatible avec la dimension de D !\n" );
		exit(0);
	}

	/* calcul des T^k, 1 <= k <= n */
	Tk = (Matrix **) malloc( (n+1)*sizeof(Matrix *) );
	/* initialise Tk = Id */
	Tk[0] = Matrix_Alloc(T->NbRows, T->NbColumns);
	for( i=0 ; i<T->NbRows ; i++ )
		for( j=0 ; j<T->NbColumns ; j++ )
			if( i!=j )
				Tk[0]->p[i][j]=0;
			else
				Tk[0]->p[i][j]=1;
	for( l=1 ; l<=n ; l++ )
	{
		Tk[l] = Matrix_Alloc(T->NbRows, T->NbColumns);
		Matrix_Product( Tk[l-1], T, Tk[l] );
		fprintf(stderr, "T^%d = ",l);
		Matrix_Print( stderr, "%3d ", Tk[l]);

		if( Matrice_identite(Tk[l]) )
		{
			n = l;	/* inutile d'aller plus loin ! */
			break;
		}
	}
	fprintf(stderr, "k = %d\n",n);

	/* calcul de C */
	C = DomainIntersection( 
			DomainIntersection( D, DomainPreimage(D,T,WS), WS),
			DomainImage(D,T,WS),
			WS);
AFF_POLY(C);
	/* calcul de D1, D2, L */
	p = DomainPreimage( D, T, WS );
	P1 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	p = DomainImage( D, T, WS );
	P2 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	D1 = DomainDifference( P1, P2, WS);
	D2 = DomainDifference( P2, P1, WS);
	p = DomainDifference( D, P1, WS );
	L = DomainDifference( p, P2, WS );
	Domain_Free( p );

/*
AFFCONTRAINTES( P1 );
AFFCONTRAINTES( P2 );
AFFCONTRAINTES( D1 );
AFFCONTRAINTES( D2 );
*/
	AFF_POLY(D1);
	AFF_POLY(D2);
	AFFCONTRAINTES( L );

	/* calcul de D12 et D21 */
	TiD2 = DomainPreimage( D2, T, WS );
	D12 = DomainIntersection( D1, TiD2, WS );
	p = DomainImage( D1, T, WS );
	D21 = DomainIntersection( D2, p, WS );
	Domain_Free( p );
	AFFCONTRAINTES( D12 );
	AFFCONTRAINTES( D21 );

	/* Calcul de la decomposition de C : points qui bouclent dans C */
	/* tq  T^l x = x,  avec 1 <= l <= n  */
	nTk = Matrix_Alloc( T->NbRows, T->NbColumns );
	c = Matrix_Alloc( T->NbRows, T->NbColumns+1 );
	for( l=1 ; l<=n ; l++ )
	{
		Polyhedron *LEX, *Ci, *EE, *E, *L2, *E2, *Lt;
		int lex, ll, k;
		/* calcule E = { x | T^l x = x } */
		c->NbRows = T->NbRows;
		for( i=0 ; i<T->NbRows ; i++ )
		{
			c->p[i][0] = 0;
			memcpy( &c->p[i][1], &Tk[l]->p[i][0], T->NbColumns*sizeof(int) );
			c->p[i][i+1] --;	/* T^l - Id */
		}
		Ci = DomainAddConstraints( C, c, WS );

		/* reduit Ci tel que tous les points par les images T^l sont dans C */
		EE = Ci;
		for( k=1 ; k<=l ; k++ )
		{
			EE = DomainPreimage(EE,T,WS);
			Ci = DomainIntersection( EE, Ci, WS );
		}

		/* pas de nouveaux points ? */
		if( emptyQ(Ci) )
		{
			printf( "\n# empty C%d\n",l);
			continue;	/* passe au l suivant */
		}

		/* C = C \ Ci */
		Cn = DomainDifference( C, Ci, WS );
		Domain_Free( C );
		C = Cn;

		/* decompose Ci en sous domaines : calcule E */
		E = Ci;
		/* calcule L = { T x > x, T^2 x>x, ..., T^(l-1) x>x} */
		for( k=1 ; k<=l-1 ; k++ )
		{
			/* copie Tk[k] dans nTk */
			memcpy( nTk->p_Init, Tk[k]->p_Init, T->NbRows*T->NbColumns*sizeof(int) );
			/* nTk = Tk-Id */
			for( i=0 ; i<T->NbRows ; i++ )
				nTk->p[i][i] --;
			/* Cree le domaine { nTk x > 0 (lexico.) } */
			LEX=NULL;
			for( lex=0 ; lex<nTk->NbRows-1 ; lex++ )
			{
				c->NbRows = lex+1;
				/* 'lex' egalites */
				for( ll=0 ; ll<lex ; ll++ )
				{
					c->p[ll][0] = 0;
					memcpy( &c->p[ll][1], &nTk->p[ll][0], T->NbColumns*sizeof(int) );
				}
				/* et une inegalite */
				c->p[ll][0] = 1;
				memcpy( &c->p[ll][1], &nTk->p[ll][0], T->NbColumns*sizeof(int) );
				c->p[ll][T->NbColumns] --;  /* STRICTE ! */
				Lt = Constraints2Polyhedron( c, WS );

				if( !LEX )
					LEX = Lt;
				else
				{
					L2 = DomainUnion( LEX, Lt, WS );
					Domain_Free( LEX );
					Domain_Free( Lt );
					LEX = L2;
				}
			}
			/* ajoute les contraintes min lexico a E */
			E2 = DomainIntersection( E, LEX, WS );
			Domain_Free( E );
			Domain_Free( LEX );
			E = E2;
		}

		/* simplifie E si possible */
		E2 = DomainConvex( E, WS );
		L = DomainDifference( E2, E, WS );
		if( emptyQ(L) )
		{
			Domain_Free( E );
			E = E2;
		}
		else
		{
			Domain_Free( E2 );
		}
		Domain_Free( L );
		
		/* affiche E, puis les autres sous domaines (T E, T^2 E, ...) */
		AFF_POLY( E );
		printf( "# E%d,%d", l, 0 );
		AFFCONTRAINTES(E);
		for( k=1 ; k<l ; k++ )
		{
			EE = DomainImage(E,T,WS);
			Domain_Free( E );
			E = EE;
			printf( "# E%d,%d", l, k );
			AFFCONTRAINTES( EE );
		}
		Domain_Free( E );
	}

	/*  Calcul des D C_l , avec 1 <= l < n (pas la peine de tester pour n) */
	/* on s'arrete aussi quand C est vide */
	RD1 = D1;
	for( l=1 ; l<n && !emptyQ(C) ; l++ )
	{
		int k;
		Polyhedron *DCl, *DClk;
		/* RD1 = RD1 \cap T^-l C  */
		p = DomainPreimage( C, Tk[l], WS );
		pp = DomainIntersection( RD1, p, WS );
		Domain_Free( p );
		if( l!=1 ) Domain_Free( RD1 );	/* ne libere pas le premier (D1) */
		RD1 = pp;

		p = DomainPreimage( D2, Tk[l+1], WS );
		DCl = DomainIntersection( RD1, p, WS );
		Domain_Free( p );

		if( emptyQ( DCl ) )
		{
			printf( "# DC%d empty\n", l );
			continue;
		}
		/* Affiche DCl, T DCl, ... , T^(l+1) DCl et les supprime de C */
		printf( "# DC%d,0", l );
		AFFCONTRAINTES(DCl);
		for( k=1 ; k<=l+1 ; k++ )
		{
			DClk = DomainImage(DCl,T,WS);
			Domain_Free( DCl );
			DCl = DClk;
			printf( "# DCl%d,%d", l, k );
			AFFCONTRAINTES( DClk );
			p = DomainDifference( C, DCl, WS );
			Domain_Free( C );
			C = p;
		}
		Domain_Free( DCl );
	}


	if( ! emptyQ( C ) )
	{
		printf( "# ATTENTION : reste de C (non parcouru) ci-dessous :" );
		AFFCONTRAINTES( C );
	}
	else
	{
		printf( "# Parfait, C a ete entierement parcouru\n");
	}




	if( argc==2 )
	{
		if( strcmp(argv[1],"-nocontext") )
		{
			printf("#context\n");
			Matrix_Print( stdout, "%3d ", context);
		}
	}
	else
	{
		printf("#context\n");
		Matrix_Print( stdout, "%3d ", context);
	}

	/* il faudrait faire des free... */
	return 0;
}

