/* test du package arithmetique */

#include <stdio.h>

#include "assert.h"
#include "arithmetique.h"

/* test complet des predicats arithmetiques sur la division, le modulo
 * et le pgcd pour les paires de nombres comprises entre (0,1) et 
 * (TEST_NUMBER,TEST_NUMBER)
 */
main()
{
#define TEST_NUMBER 100
    int a, b;				/* paire a tester */
    int quotient, mod, gcd;		/* resultats */

    for(a=0; a<=TEST_NUMBER; a++) 
	for(b=1; b<=TEST_NUMBER; b++) {

	    /* appel des fonctions a tester */
	    quotient = divide(a,b);
	    mod = modulo(a,b);
	    gcd = pgcd_fast(a,b);
	
	    /*
	     * printf("essai %d\ta=%d\tb=%d\tq=%d\tr=%d\tgcd=%d\tgcdr=%d\n",
	     *        i,a,b,quotient,mod,gcd,pgcd_slow(a,b));
	     */

	    /* concordance des deux versions du calcul du pgcd */
	    assert(gcd == pgcd_slow(a,b));

	    /* definition de la division entiere a reste positif */
	    assert(b*quotient+mod==a);
	    assert(mod>=0);
	    assert(mod<b);

	    /* definition du pgcd */
	    assert(modulo(a,gcd)==0);
	    assert(modulo(b,gcd)==0);
	    assert(pgcd_fast(divide(a,gcd),divide(b,gcd))==1);
	    assert(gcd>0);
	}
}

