/*       Polyhedron disjoint intersections
*/

/*
 union_disjointe computes the disjoint union of the given list of domains.
 input :
		(integer) # of polyhedra
		list of polyhedra in the usual matrix (constraints) format
*/

#include <stdio.h>
#include <stdlib.h>

#include <polylib/polylib.h>

#define WS 200

typedef struct LP_ { struct LP_ *next; Polyhedron *P; } LP;

int main()
{
	int np, i;

	Matrix *a;
	LP *P, *lP;
	LP *Result, *lR, *tmp;
	Polyhedron *reste;
	Polyhedron *d1,*d2,*dx;

	scanf( "%d", &np );

	P = Result = NULL;
	for( i=0 ; i<np ; ++i )
	{
		a = Matrix_Read();
		lP = (LP *) malloc( sizeof(LP) );
		lP->next = P;
		lP->P = Constraints2Polyhedron(a, WS);
		Matrix_Free(a);
		P = lP;
	}

	for( lP=P ; lP ; lP=lP->next )
	{
		reste = lP->P;
		/* intersection avec chacun des domaines deja trouves (dans Result) */
		for( lR=Result ; lR && reste ; lR=lR->next )
		{
			dx = PDomainIntersection ( reste, lR->P, WS);
			if( !dx ) continue;
			if ( emptyQ(dx) )
			{	Domain_Free( dx );
				continue;
			}

			d1 = PDomainDifference( reste, lR->P, WS);	/* dans reste */
			d2 = PDomainDifference( lR->P, reste, WS);	/* dans lR->P */

			if( !d1 || emptyQ(d1) )
			{
				if( d1 )
					Domain_Free( d1 );

				if( !d2 || emptyQ(d2) )
				{
					/* d2 = d1 = vide. dx = reste */
					/* dx est le courant. */
					/* on ne fait rien. */
				}
				else
				{
					/* ajoute l'intersection en tete : */
					tmp = (LP *)malloc( sizeof(LP) );
					tmp->next = Result;
					tmp->P = dx;
					Result = tmp;
					/* remplace le courant par d2 */
					lR->P = d2;
				}
				reste = NULL;
			}
			else
			{
				if( !d2 || emptyQ(d2) )
				{
					if( d2 )
						Domain_Free( d2 );
					/* remplace le courant par dx. */
					lR->P = dx;
					reste = d1;
				}
				else
				{
					/* ajoute d2 en tete */
					tmp = (LP *)malloc( sizeof(LP) );
					tmp->next = Result;
					tmp->P = d2;
					Result = tmp;

					/* remplace le courant par dx. */
					lR->P = dx;

					reste = d1;
				}
			}
		}
		/* s'il reste qqchosea la fin, on le rajoute au debut de Result */
		if( reste )
			if( !emptyQ(reste) )
			{
				lR = (LP *)malloc( sizeof(LP) );
				lR->next = Result;
				lR->P = reste;
				Result = lR;
			}
	}


	for( lR = Result ; lR ; lR=lR->next )
	{
		Polyhedron_Print( stdout, "%3d ", lR->P );
		printf( "---------------------------------------------\n" );
	}

	/* free.... :-) */

	return 0;
}
