
#ifndef POLY_MP_H
#define POLY_MP_H

#include "types-polylib_mp.h"


mpz_t *Vector_Mp_Alloc(int length);
void Vector_Mp_Free(mpz_t *vect, int length);
Matrix_Mp *Matrix_Mp_Alloc(int rows, int cols);
void Matrix_Mp_Free(Matrix_Mp *mat);
void Matrix_2_Matrix_Mp(Matrix_Mp *dest, Matrix *src);
void Matrix_Mp_2_Matrix(Matrix *dest, Matrix_Mp *src);
void Vector_Gcd_Mp(mpz_t gcd, mpz_t *p, mpz_t *q, int length);
void Vector_Combine_Mp(mpz_t *p1, mpz_t *p2, mpz_t *p3, mpz_t lambda, mpz_t mu,
		       int length);
void Vector_Normalize_Mp(mpz_t *p, mpz_t *tmp, int length);
int Gauss_Mp(Matrix_Mp *Mat, int NbEq, int Dimension, mpz_t *temp);

#endif

