#include <stdio.h>
#include "stdansi.h"
#include "types.h"
#include "vector.h"
#include "polyhedron.h"
#include "polyparam.h"

int main()
{
	Matrix *a, *b;
	Polyhedron *A, *B;
	Param_Polyhedron *PA;
	Param_Domain *P;
	Param_Vertices *V;
	int i, ix, nbPV;
	unsigned bx;

	a = Matrix_Read();
	if( !a || a->NbColumns == 0 )
	{
		fprintf( stderr, "Input error: empty matrix\n" );
		exit( 0 );
	}
	A = Constraints2Polyhedron(a, 200);
	Matrix_Free(a);

	b = Matrix_Read();
	if( !b || b->NbColumns == 0 )
	{
		fprintf( stderr, "Input error: empty matrix\n" );
		exit( 0 );
	}
	B = Constraints2Polyhedron(b, 200);
	Matrix_Free(b);

	PA = Polyhedron2Param_Domain( A, B, 200 );
	if( !PA || PA->D==NULL )
	{
		printf( "---------------------------------------\n" );
		printf( "Empty polyhedron\n" );
		return 0;
	}
	nbPV = PA->nbV;

	Domain_Free(A);
	Domain_Free(B);

	for( P=PA->D ; P ; P=P->next )
	{
		printf( "---------------------------------------\n" );
		printf( "Domain :\n");
		Print_Domain( stdout, P->Domain );

		printf( "Vertices :\n");
		for( i=0, ix=0, bx=MSB, V=PA->V ; V && i<nbPV ; ++i, V=V->next )
		{
			if (P->F[ix] & bx)
			{	Print_Vertex( stdout, V->Vertex );
				printf( "\n" );
			}
			NEXT(ix,bx);
		}
	}

	Param_Polyhedron_Free( PA );

	return 0;
}
