/* types.h
     COPYRIGHT
          Both this software and its documentation are

              Copyright 1993, IRISA /Universite de Rennes I - France
              Copyright 1996, Doran Wilde and Vincent Loechner
              All rights reserved.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
#ifndef _types_h_
#define _types_h_

#include <stdio.h>

/* put a one in the MSB of an int (portable) */
#define MSB ((unsigned)1<<(sizeof(int)*8-1))

/* largest representable positive number */
#define TOP ((int)(MSB-1))

#define NEXT(j,b) { if (!((b)>>=1)) { (b)=MSB; (j)++; } }

/* status of last Polyhedron operation */
extern int Pol_status;

typedef struct vector {
  unsigned Size;
  int *p;
} Vector;

typedef struct matrix {
  unsigned NbRows, NbColumns;
  int **p;
  int *p_Init;
} Matrix;

typedef struct polyhedron
{ struct polyhedron *next;
  unsigned Dimension, NbConstraints, NbRays, NbEq, NbBid;
  int **Constraint;
  int **Ray;
  int *p_Init;
} Polyhedron;

typedef struct
{ int MaxN, MaxD, MaxI, MinN, MinD, MinI; } Interval;

/* #define emptyQ(P) (P->NbEq==(P->Dimension+1)) */
#define emptyQ(P) (P->NbRays==0)
#define universeQ(P) (P->Dimension==P->NbLines)

typedef struct _Param_V
{	struct _Param_V *next;	/* ptr to the next vertex, NULL terminated */
	Matrix *Vertex;			/* Each line is a coordinate of the vertex: */
				/* the first m values of each line are the */
				/* coefficients of the parameters, */
				/* the (m+1)th value is the constant, */
				/* the (m+2)th value is the common denom */
	Matrix *Domain;			/* Constraints on parameters */
									/* Inequalities only. (Polyhedron format) */
}
Param_Vertices;

typedef struct _Param_Domain
{
	struct _Param_Domain *next; /* ptr to next record in list, null term. */
	Polyhedron *Domain;		/* ptr to Domain (constraints on parameters) */
	int	*F;					/* bit array of faces */
} Param_Domain;

typedef struct _Param_Poly
{	int		nbV;	/* number of parameterized vertices */
	Param_Vertices *V;		/* linked list of parameterized vertices */
	Param_Domain   *D;		/* linked list of validity domains */
}
Param_Polyhedron;

/* A FOR loop for scanning the vertices of a parameterized polyhedron */
/* Example usage:                                                     */
/* (declarations)                                                     */
/*       Param_Polyhedron *P;                                         */
/*       Param_Domain     *D;                                         */
/*       Param_Vertices   *V;                                         */
/* (code)                                                             */
/*       FORALL_PVertex_in_ParamPolyhedron( V, D, P )                 */
/*       {                                                            */
/*               Print_Vertex( stdout, V->Vertex );                   */
/*               printf( "\n" );                                      */
/*       }                                                            */
/*       END_FORALL_PVertex_in_ParamPolyhedron;                       */

#define FORALL_PVertex_in_ParamPolyhedron(V, D, P)   \
{     int _i, _ix;                                   \
      unsigned _bx;                                  \
      for( _i=0, _ix=0, _bx=MSB, V=P->V ;            \
           V && (_i<P->nbV) ; _i++, V=V->next )      \
      {       if (D->F[_ix] & _bx)                   \
              {

#define END_FORALL_PVertex_in_ParamPolyhedron  \
              }                                \
              NEXT(_ix, _bx);                  \
      }                                        \
}

#endif
